/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.components.impl;

import es.bsc.compss.components.impl.DataInfoProvider;
import es.bsc.compss.components.monitor.impl.GraphGenerator;
import es.bsc.compss.types.Task;
import es.bsc.compss.types.TaskDescription;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.data.AccessParams;
import es.bsc.compss.types.data.DataAccessId;
import es.bsc.compss.types.data.DataInstanceId;
import es.bsc.compss.types.data.FileInfo;
import es.bsc.compss.types.data.operation.ResultListener;
import es.bsc.compss.types.implementations.Implementation;
import es.bsc.compss.types.parameter.DependencyParameter;
import es.bsc.compss.types.parameter.ExternalObjectParameter;
import es.bsc.compss.types.parameter.FileParameter;
import es.bsc.compss.types.parameter.ObjectParameter;
import es.bsc.compss.types.parameter.Parameter;
import es.bsc.compss.types.request.ap.BarrierRequest;
import es.bsc.compss.types.request.ap.EndOfAppRequest;
import es.bsc.compss.types.request.ap.WaitForTaskRequest;
import es.bsc.compss.util.ErrorManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.Semaphore;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import storage.StubItf;

public class TaskAnalyser {
    private DataInfoProvider DIP;
    private GraphGenerator GM;
    private TreeMap<Integer, Task> writers;
    private HashMap<Integer, Integer> currentTaskCount = new HashMap();
    private HashMap<Long, Integer> appIdToTotalTaskCount;
    private HashMap<Long, Integer> appIdToTaskCount;
    private HashMap<Long, Semaphore> appIdToSemaphore;
    private HashSet<Long> appIdBarrierFlags;
    private HashMap<Long, TreeSet<Integer>> appIdToWrittenFiles;
    private HashMap<Long, TreeSet<Integer>> appIdToSCOWrittenIds;
    private Hashtable<Task, List<Semaphore>> waitedTasks;
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Components.TaskProcessor.TaskAnalyser");
    private static final boolean DEBUG = LOGGER.isDebugEnabled();
    private static final String TASK_FAILED = "Task failed: ";
    private static final boolean drawGraph = GraphGenerator.isEnabled();
    private static int synchronizationId;
    private static boolean taskDetectedAfterSync;

    public TaskAnalyser() {
        this.writers = new TreeMap();
        this.appIdToTaskCount = new HashMap();
        this.appIdToTotalTaskCount = new HashMap();
        this.appIdToSemaphore = new HashMap();
        this.appIdBarrierFlags = new HashSet();
        this.appIdToWrittenFiles = new HashMap();
        this.appIdToSCOWrittenIds = new HashMap();
        this.waitedTasks = new Hashtable();
        synchronizationId = 0;
        LOGGER.info("Initialization finished");
    }

    public void setCoWorkers(DataInfoProvider DIP) {
        this.DIP = DIP;
    }

    public void setGM(GraphGenerator GM) {
        this.GM = GM;
    }

    public void processTask(Task currentTask) {
        Integer methodId;
        Integer actualCount;
        TaskDescription params = currentTask.getTaskDescription();
        LOGGER.info("New " + (params.getType() == Implementation.TaskType.METHOD ? "method" : "service") + " task(" + params.getName() + "), ID = " + currentTask.getId());
        if (drawGraph) {
            this.addNewTask(currentTask);
        }
        if ((actualCount = this.currentTaskCount.get(methodId = params.getId())) == null) {
            actualCount = 0;
        }
        this.currentTaskCount.put(methodId, actualCount + 1);
        Long appId = currentTask.getAppId();
        Integer taskCount = this.appIdToTaskCount.get(appId);
        if (taskCount == null) {
            taskCount = 0;
        }
        Integer n = taskCount;
        Integer n2 = taskCount = Integer.valueOf(taskCount + 1);
        this.appIdToTaskCount.put(appId, taskCount);
        Integer totalTaskCount = this.appIdToTotalTaskCount.get(appId);
        if (totalTaskCount == null) {
            totalTaskCount = 0;
        }
        n2 = totalTaskCount;
        Integer n3 = totalTaskCount = Integer.valueOf(totalTaskCount + 1);
        this.appIdToTotalTaskCount.put(appId, totalTaskCount);
        int constrainingParam = -1;
        if (params.getType() == Implementation.TaskType.SERVICE && params.hasTargetObject()) {
            constrainingParam = params.hasReturnValue() ? params.getParameters().length - 2 : params.getParameters().length - 1;
        }
        Parameter[] parameters = params.getParameters();
        block16: for (int paramIdx = 0; paramIdx < parameters.length; ++paramIdx) {
            DataAccessId daId;
            Parameter p = parameters[paramIdx];
            if (DEBUG) {
                LOGGER.debug("* Parameter : " + p);
            }
            AccessParams.AccessMode am = AccessParams.AccessMode.R;
            switch (p.getDirection()) {
                case IN: {
                    am = AccessParams.AccessMode.R;
                    break;
                }
                case OUT: {
                    am = AccessParams.AccessMode.W;
                    break;
                }
                case INOUT: {
                    am = AccessParams.AccessMode.RW;
                }
            }
            switch (p.getType()) {
                case FILE_T: {
                    FileParameter fp = (FileParameter)p;
                    daId = this.DIP.registerFileAccess(am, fp.getLocation());
                    break;
                }
                case PSCO_T: {
                    ObjectParameter pscop = (ObjectParameter)p;
                    pscop.setType(DataType.PSCO_T);
                    daId = this.DIP.registerObjectAccess(am, pscop.getValue(), pscop.getCode());
                    break;
                }
                case EXTERNAL_OBJECT_T: {
                    ExternalObjectParameter externalPSCOparam = (ExternalObjectParameter)p;
                    externalPSCOparam.setType(DataType.EXTERNAL_OBJECT_T);
                    daId = this.DIP.registerExternalObjectAccess(am, externalPSCOparam.getId(), externalPSCOparam.getCode());
                    break;
                }
                case OBJECT_T: {
                    ObjectParameter op = (ObjectParameter)p;
                    if (op.getValue() instanceof StubItf && ((StubItf)op.getValue()).getID() != null) {
                        op.setType(DataType.PSCO_T);
                    }
                    daId = this.DIP.registerObjectAccess(am, op.getValue(), op.getCode());
                    break;
                }
                default: {
                    continue block16;
                }
            }
            DependencyParameter dp = (DependencyParameter)p;
            dp.setDataAccessId(daId);
            switch (am) {
                case R: {
                    DataAccessId raId;
                    DataInstanceId dependingDataId;
                    this.checkDependencyForRead(currentTask, dp);
                    if (paramIdx != constrainingParam || (dependingDataId = ((DataAccessId.RAccessId)(raId = (DataAccessId.RAccessId)dp.getDataAccessId())).getReadDataInstance()) == null || dependingDataId.getVersionId() <= 1) continue block16;
                    currentTask.setEnforcingTask(this.writers.get(dependingDataId.getDataId()));
                    continue block16;
                }
                case RW: {
                    DataAccessId raId;
                    DataInstanceId dependingDataId;
                    this.checkDependencyForRead(currentTask, dp);
                    if (paramIdx == constrainingParam && (dependingDataId = ((DataAccessId.RWAccessId)(raId = (DataAccessId.RWAccessId)dp.getDataAccessId())).getReadDataInstance()) != null && dependingDataId.getVersionId() > 1) {
                        currentTask.setEnforcingTask(this.writers.get(dependingDataId.getDataId()));
                    }
                    this.registerOutputValues(currentTask, dp);
                    continue block16;
                }
                case W: {
                    this.registerOutputValues(currentTask, dp);
                }
            }
        }
    }

    public void endTask(Task task) {
        List<Semaphore> sems;
        int taskId = task.getId();
        boolean isFree = task.isFree();
        Task.TaskState taskState = task.getStatus();
        LOGGER.info("Notification received for task " + taskId + " with end status " + (Object)((Object)taskState));
        if (!isFree) {
            LOGGER.debug("Task " + taskId + " is not registered as free. Waiting for other executions to end");
            return;
        }
        if (taskState == Task.TaskState.FAILED) {
            ErrorManager.error(TASK_FAILED + task);
            return;
        }
        LOGGER.debug("Ending task " + taskId);
        Long appId = task.getAppId();
        Integer taskCount = this.appIdToTaskCount.get(appId) - 1;
        this.appIdToTaskCount.put(appId, taskCount);
        if (taskCount == 0) {
            this.appIdBarrierFlags.remove(appId);
            Semaphore sem = this.appIdToSemaphore.remove(appId);
            if (sem != null) {
                this.appIdToTaskCount.remove(appId);
                sem.release();
            }
        }
        if ((sems = this.waitedTasks.remove(task)) != null) {
            for (Semaphore sem : sems) {
                sem.release();
            }
        }
        for (Parameter param : task.getTaskDescription().getParameters()) {
            DataType type = param.getType();
            if (type != DataType.FILE_T && type != DataType.OBJECT_T && type != DataType.PSCO_T && type != DataType.EXTERNAL_OBJECT_T) continue;
            DependencyParameter dPar = (DependencyParameter)param;
            DataAccessId dAccId = dPar.getDataAccessId();
            LOGGER.debug("Treating that data " + dAccId + " has been accessed at " + dPar.getDataTarget());
            this.DIP.dataHasBeenAccessed(dAccId);
        }
        if (this.appIdToSemaphore.get(appId) != null && !this.appIdBarrierFlags.contains(appId)) {
            this.checkResultFileTransfer(task);
        }
        task.releaseDataDependents();
    }

    private void checkResultFileTransfer(Task t) {
        LinkedList<DataInstanceId> fileIds = new LinkedList<DataInstanceId>();
        block10: for (Parameter p : t.getTaskDescription().getParameters()) {
            switch (p.getType()) {
                case FILE_T: {
                    FileParameter fp = (FileParameter)p;
                    switch (fp.getDirection()) {
                        case IN: {
                            break;
                        }
                        case INOUT: {
                            DataInstanceId dId = ((DataAccessId.RWAccessId)fp.getDataAccessId()).getWrittenDataInstance();
                            if (this.writers.get(dId.getDataId()) != t) break;
                            fileIds.add(dId);
                            break;
                        }
                        case OUT: {
                            DataInstanceId dId = ((DataAccessId.WAccessId)fp.getDataAccessId()).getWrittenDataInstance();
                            if (this.writers.get(dId.getDataId()) != t) break;
                            fileIds.add(dId);
                        }
                    }
                    continue block10;
                }
            }
        }
        int numFT = fileIds.size();
        if (numFT > 0) {
            for (DataInstanceId fileId : fileIds) {
                try {
                    int id = fileId.getDataId();
                    this.DIP.blockDataAndGetResultFile(id, new ResultListener(new Semaphore(0)));
                    this.DIP.unblockDataId(id);
                }
                catch (Exception e) {
                    LOGGER.error("Exception ordering trasnfer when task ends", (Throwable)e);
                }
            }
        }
    }

    public void findWaitedTask(WaitForTaskRequest request) {
        int dataId = request.getDataId();
        AccessParams.AccessMode am = request.getAccessMode();
        Semaphore sem = request.getSemaphore();
        Task lastWriter = this.writers.get(dataId);
        if (lastWriter != null) {
            if (am == AccessParams.AccessMode.RW) {
                this.writers.put(dataId, null);
            }
            if (drawGraph) {
                this.addEdgeFromTaskToMain(lastWriter, dataId);
            }
        }
        if (lastWriter == null || lastWriter.getStatus() == Task.TaskState.FINISHED) {
            sem.release();
        } else {
            List<Semaphore> list = this.waitedTasks.get(lastWriter);
            if (list == null) {
                list = new LinkedList<Semaphore>();
                this.waitedTasks.put(lastWriter, list);
            }
            list.add(sem);
        }
    }

    public void barrier(BarrierRequest request) {
        Long appId = request.getAppId();
        Integer count = this.appIdToTaskCount.get(appId);
        if (drawGraph) {
            this.addNewBarrier();
            this.GM.commitGraph();
        }
        if (count == null || count == 0) {
            request.getSemaphore().release();
        } else {
            this.appIdBarrierFlags.add(appId);
            this.appIdToSemaphore.put(appId, request.getSemaphore());
        }
    }

    public void noMoreTasks(EndOfAppRequest request) {
        Long appId = request.getAppId();
        Integer count = this.appIdToTaskCount.get(appId);
        if (drawGraph) {
            this.GM.commitGraph();
        }
        if (count == null || count == 0) {
            this.appIdToTaskCount.remove(appId);
            request.getSemaphore().release();
        } else {
            this.appIdToSemaphore.put(appId, request.getSemaphore());
        }
    }

    public TreeSet<Integer> getAndRemoveWrittenFiles(Long appId) {
        return this.appIdToWrittenFiles.remove(appId);
    }

    public void shutdown() {
        if (drawGraph) {
            GraphGenerator.removeTemporaryGraph();
        }
    }

    public String getTaskStateRequest() {
        StringBuilder sb = new StringBuilder("\t").append("<TasksInfo>").append("\n");
        for (Map.Entry<Long, Integer> e : this.appIdToTotalTaskCount.entrySet()) {
            Long appId = e.getKey();
            Integer totalTaskCount = e.getValue();
            Integer taskCount = this.appIdToTaskCount.get(appId);
            if (taskCount == null) {
                taskCount = 0;
            }
            int completed = totalTaskCount - taskCount;
            sb.append("\t\t").append("<Application id=\"").append(appId).append("\">").append("\n");
            sb.append("\t\t\t").append("<TotalCount>").append(totalTaskCount).append("</TotalCount>").append("\n");
            sb.append("\t\t\t").append("<InProgress>").append(taskCount).append("</InProgress>").append("\n");
            sb.append("\t\t\t").append("<Completed>").append(completed).append("</Completed>").append("\n");
            sb.append("\t\t").append("</Application>").append("\n");
        }
        sb.append("\t").append("</TasksInfo>").append("\n");
        return sb.toString();
    }

    public void deleteFile(FileInfo fileInfo) {
        int dataId = fileInfo.getDataId();
        LOGGER.debug("Deleting file with id " + dataId + " and location " + fileInfo.getOriginalLocation());
        Task task = this.writers.get(dataId);
        if (task != null) {
            return;
        }
        LOGGER.debug("Removing " + fileInfo.getDataId() + " from written files");
        for (TreeSet<Integer> files : this.appIdToWrittenFiles.values()) {
            files.remove(fileInfo.getDataId());
        }
    }

    private void checkDependencyForRead(Task currentTask, DependencyParameter dp) {
        int dataId = dp.getDataAccessId().getDataId();
        Task lastWriter = this.writers.get(dataId);
        if (lastWriter != null && lastWriter != currentTask) {
            if (DEBUG) {
                LOGGER.debug("Last writer for datum " + dp.getDataAccessId().getDataId() + " is task " + lastWriter.getId());
                LOGGER.debug("Adding dependency between task " + lastWriter.getId() + " and task " + currentTask.getId());
            }
            currentTask.addDataDependency(lastWriter);
            if (drawGraph) {
                this.addEdgeFromTaskToTask(lastWriter, currentTask, dataId);
            }
        } else if (drawGraph) {
            this.addEdgeFromMainToTask(currentTask, dataId);
        }
    }

    private void registerOutputValues(Task currentTask, DependencyParameter dp) {
        TreeSet<Integer> idsWritten;
        int currentTaskId = currentTask.getId();
        int dataId = dp.getDataAccessId().getDataId();
        Long appId = currentTask.getAppId();
        this.writers.put(dataId, currentTask);
        if (dp.getType() == DataType.FILE_T) {
            idsWritten = this.appIdToWrittenFiles.get(appId);
            if (idsWritten == null) {
                idsWritten = new TreeSet();
                this.appIdToWrittenFiles.put(appId, idsWritten);
            }
            idsWritten.add(dataId);
        }
        if (dp.getType() == DataType.PSCO_T) {
            idsWritten = this.appIdToSCOWrittenIds.get(appId);
            if (idsWritten == null) {
                idsWritten = new TreeSet();
                this.appIdToSCOWrittenIds.put(appId, idsWritten);
            }
            idsWritten.add(dataId);
        }
        if (DEBUG) {
            LOGGER.debug("New writer for datum " + dp.getDataAccessId().getDataId() + " is task " + currentTaskId);
        }
    }

    private void addNewTask(Task task) {
        this.GM.addTaskToGraph(task);
        task.setSynchronizationId(synchronizationId);
        taskDetectedAfterSync = true;
    }

    private void addEdgeFromTaskToTask(Task source, Task dest, int dataId) {
        if (source.getSynchronizationId() == dest.getSynchronizationId()) {
            String src = String.valueOf(source.getId());
            String dst = String.valueOf(dest.getId());
            String dep = String.valueOf(dataId);
            this.GM.addEdgeToGraph(src, dst, dep);
        } else {
            String src = "Synchro" + dest.getSynchronizationId();
            String dst = String.valueOf(dest.getId());
            String dep = String.valueOf(dataId);
            this.GM.addEdgeToGraph(src, dst, dep);
        }
    }

    private void addEdgeFromMainToTask(Task dest, int dataId) {
        String src = "Synchro" + dest.getSynchronizationId();
        String dst = String.valueOf(dest.getId());
        String dep = String.valueOf(dataId);
        this.GM.addEdgeToGraph(src, dst, dep);
    }

    private void addEdgeFromTaskToMain(Task task, int dataId) {
        if (taskDetectedAfterSync) {
            taskDetectedAfterSync = false;
            this.GM.addSynchroToGraph(++synchronizationId);
            if (synchronizationId > 1) {
                String oldSync = "Synchro" + (synchronizationId - 1);
                String currentSync = "Synchro" + synchronizationId;
                this.GM.addEdgeToGraph(oldSync, currentSync, "");
            }
        }
        String src = String.valueOf(task.getId());
        String dest = "Synchro" + synchronizationId;
        this.GM.addEdgeToGraph(src, dest, String.valueOf(dataId));
    }

    private void addNewBarrier() {
        taskDetectedAfterSync = false;
        this.GM.addBarrierToGraph(++synchronizationId);
        if (synchronizationId > 1) {
            this.GM.addEdgeToGraph("Synchro" + (synchronizationId - 1), "Synchro" + synchronizationId, "");
        }
        HashSet<Task> uniqueWriters = new HashSet<Task>(this.writers.values());
        for (Task writer : uniqueWriters) {
            if (writer.getSynchronizationId() != synchronizationId - 1) continue;
            this.GM.addEdgeToGraph(String.valueOf(writer.getId()), "Synchro" + synchronizationId, "");
        }
    }
}

