/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.scheduler.multiobjective;

import es.bsc.compss.components.impl.ResourceScheduler;
import es.bsc.compss.components.impl.TaskScheduler;
import es.bsc.compss.scheduler.multiobjective.MOResourceOptimizer;
import es.bsc.compss.scheduler.multiobjective.MOResourceScheduler;
import es.bsc.compss.scheduler.multiobjective.MOScheduleOptimizer;
import es.bsc.compss.scheduler.multiobjective.MOSchedulingInformation;
import es.bsc.compss.scheduler.multiobjective.config.MOConfiguration;
import es.bsc.compss.scheduler.multiobjective.types.MOProfile;
import es.bsc.compss.scheduler.multiobjective.types.MOScore;
import es.bsc.compss.scheduler.types.AllocatableAction;
import es.bsc.compss.scheduler.types.Score;
import es.bsc.compss.types.resources.Worker;
import es.bsc.compss.types.resources.WorkerResourceDescription;
import es.bsc.compss.util.ResourceOptimizer;
import es.bsc.compss.util.SchedulingOptimizer;
import java.util.HashSet;
import java.util.List;
import org.json.JSONObject;

public class MOScheduler
extends TaskScheduler {
    public MOScheduler() {
        MOConfiguration.load();
    }

    public MOProfile generateProfile(JSONObject json) {
        return new MOProfile(json);
    }

    public <T extends WorkerResourceDescription> MOResourceScheduler<T> generateSchedulerForResource(Worker<T> w, JSONObject res, JSONObject impls) {
        return new MOResourceScheduler<T>(w, res, impls);
    }

    public <T extends WorkerResourceDescription> MOSchedulingInformation generateSchedulingInformation(ResourceScheduler<T> enforcedTargetResource) {
        return new MOSchedulingInformation(enforcedTargetResource);
    }

    public Score generateActionScore(AllocatableAction action) {
        return MOScheduler.getActionScore(action);
    }

    public static MOScore getActionScore(AllocatableAction action) {
        long actionScore = MOScore.getActionScore(action);
        long dataTime = MOScore.getDataPredecessorTime(action.getDataPredecessors());
        return new MOScore(actionScore, dataTime, 0L, 0L, 0.0, 0.0);
    }

    public void shutdown() {
        super.shutdown();
    }

    public ResourceOptimizer generateResourceOptimizer() {
        return new MOResourceOptimizer(this);
    }

    public SchedulingOptimizer generateSchedulingOptimizer() {
        return new MOScheduleOptimizer(this);
    }

    public <T extends WorkerResourceDescription> void handleDependencyFreeActions(List<AllocatableAction> dataFreeActions, List<AllocatableAction> resourceFreeActions, List<AllocatableAction> blockedCandidates, ResourceScheduler<T> resource) {
        HashSet<AllocatableAction> freeTasks = new HashSet<AllocatableAction>();
        freeTasks.addAll(dataFreeActions);
        freeTasks.addAll(resourceFreeActions);
        for (AllocatableAction freeAction : freeTasks) {
            this.tryToLaunch(freeAction);
        }
    }
}

