/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.scheduler.multiobjective.types;

import es.bsc.compss.scheduler.multiobjective.MOSchedulingInformation;
import es.bsc.compss.scheduler.types.AllocatableAction;
import java.util.Comparator;
import java.util.PriorityQueue;

public class PriorityActionSet {
    private final PriorityQueue<AllocatableAction> noCoreActions;
    private PriorityQueue<AllocatableAction>[] coreActions;
    private final PriorityQueue<AllocatableAction> priority;
    public final Comparator<AllocatableAction> comparator;

    public PriorityActionSet(Comparator<AllocatableAction> comparator) {
        this.comparator = comparator;
        this.noCoreActions = new PriorityQueue<AllocatableAction>(1, comparator);
        this.priority = new PriorityQueue<AllocatableAction>(1, comparator);
        this.coreActions = new PriorityQueue[0];
    }

    public PriorityActionSet(PriorityActionSet clone) {
        this.comparator = clone.comparator;
        this.noCoreActions = new PriorityQueue<AllocatableAction>(clone.noCoreActions);
        this.coreActions = new PriorityQueue[clone.coreActions.length];
        for (int idx = 0; idx < this.coreActions.length; ++idx) {
            this.coreActions[idx] = new PriorityQueue<AllocatableAction>(clone.coreActions[idx]);
        }
        this.priority = new PriorityQueue<AllocatableAction>(clone.priority);
    }

    public void offer(AllocatableAction action) {
        if (((MOSchedulingInformation)action.getSchedulingInfo()).isToReschedule()) {
            Integer coreId = action.getCoreId();
            AllocatableAction currentPeek = null;
            if (coreId == null) {
                currentPeek = this.noCoreActions.peek();
                this.noCoreActions.offer(action);
            } else {
                if (coreId < this.coreActions.length) {
                    currentPeek = this.coreActions[coreId].peek();
                } else {
                    int originalSize = this.coreActions.length;
                    PriorityQueue[] coreActions = new PriorityQueue[coreId + 1];
                    System.arraycopy(this.coreActions, 0, coreActions, 0, originalSize);
                    for (int coreIdx = originalSize; coreIdx < coreId + 1; ++coreIdx) {
                        coreActions[coreIdx] = new PriorityQueue<AllocatableAction>(1, this.comparator);
                    }
                    this.coreActions = coreActions;
                }
                this.coreActions[coreId].offer(action);
            }
            if (currentPeek != action) {
                this.rebuildPriorityQueue();
            }
        }
    }

    public AllocatableAction poll() {
        AllocatableAction currentPeek;
        while ((currentPeek = this.priority.poll()) != null) {
            MOSchedulingInformation dsi;
            AllocatableAction nextPeek;
            Integer coreId = currentPeek.getCoreId();
            if (coreId == null) {
                this.noCoreActions.poll();
                nextPeek = this.noCoreActions.peek();
            } else {
                this.coreActions[coreId].poll();
                nextPeek = this.coreActions[coreId].peek();
            }
            if (nextPeek != null) {
                this.priority.offer(nextPeek);
            }
            if (!(dsi = (MOSchedulingInformation)currentPeek.getSchedulingInfo()).isToReschedule()) continue;
            break;
        }
        return currentPeek;
    }

    public void removeFirst(Integer coreId) {
        if (coreId == null) {
            this.noCoreActions.poll();
        } else {
            this.coreActions[coreId].poll();
        }
        this.rebuildPriorityQueue();
    }

    public AllocatableAction peek() {
        AllocatableAction currentPeek = this.priority.peek();
        while (currentPeek != null && !((MOSchedulingInformation)currentPeek.getSchedulingInfo()).isToReschedule()) {
            this.removeFirst(currentPeek.getCoreId());
            currentPeek = this.priority.peek();
        }
        return currentPeek;
    }

    public PriorityQueue<AllocatableAction> peekAll() {
        PriorityQueue<AllocatableAction> peeks = new PriorityQueue<AllocatableAction>(this.coreActions.length + 1, this.comparator);
        AllocatableAction currentCore = this.noCoreActions.peek();
        if (currentCore != null && !((MOSchedulingInformation)currentCore.getSchedulingInfo()).isToReschedule()) {
            this.noCoreActions.poll();
            currentCore = this.noCoreActions.peek();
        }
        if (currentCore != null) {
            peeks.offer(currentCore);
        }
        for (PriorityQueue<AllocatableAction> core : this.coreActions) {
            currentCore = core.peek();
            if (currentCore != null && !((MOSchedulingInformation)currentCore.getSchedulingInfo()).isToReschedule()) {
                core.poll();
                currentCore = core.peek();
            }
            if (currentCore == null) continue;
            peeks.offer(currentCore);
        }
        return peeks;
    }

    private void rebuildPriorityQueue() {
        this.priority.clear();
        AllocatableAction action = this.noCoreActions.peek();
        if (action != null) {
            this.priority.offer(action);
        }
        for (PriorityQueue<AllocatableAction> coreAction : this.coreActions) {
            action = coreAction.peek();
            if (action == null) continue;
            this.priority.offer(action);
        }
    }

    public int size() {
        int size = 0;
        size += this.noCoreActions.size();
        for (PriorityQueue<AllocatableAction> pq : this.coreActions) {
            size += pq.size();
        }
        return size;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public void remove(AllocatableAction action) {
        if (action.getCoreId() == null) {
            this.noCoreActions.remove(action);
        } else {
            this.coreActions[action.getCoreId()].remove(action);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("noCore -> ").append(this.noCoreActions).append("\n");
        for (int i = 0; i < this.coreActions.length; ++i) {
            sb.append("Core ").append(i).append(" -> ").append(this.coreActions[i]).append("\n");
        }
        return sb.toString();
    }
}

