/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.worker.invokers;

import es.bsc.compss.exceptions.InvokeExecutionException;
import es.bsc.compss.types.annotations.parameter.Stream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class BinaryRunner {
    private static final String ERROR_PARAM_NOT_STRING = "ERROR: Binary parameter cannot be serialized to string";
    private static final String ERROR_OUTPUTREADER = "ERROR: Cannot retrieve command output";
    private static final String ERROR_ERRORREADER = "ERROR: Cannot retrieve command error";
    private static final String ERROR_PROC_EXEC = "ERROR: Exception executing Binary command";

    public static ArrayList<String> createCMDParametersFromValues(Object[] values, Stream[] paramStreams, String[] prefixes, StreamSTD streamValues) throws InvokeExecutionException {
        ArrayList<String> binaryParams = new ArrayList<String>();
        block10: for (int i = 0; i < values.length; ++i) {
            switch (paramStreams[i]) {
                case STDIN: {
                    streamValues.setStdIn((String)values[i]);
                    continue block10;
                }
                case STDOUT: {
                    streamValues.setStdOut((String)values[i]);
                    continue block10;
                }
                case STDERR: {
                    streamValues.setStdErr((String)values[i]);
                    continue block10;
                }
                case UNSPECIFIED: {
                    if (prefixes[i].equals("#")) continue block10;
                    if (values[i] != null && values[i].getClass().isArray()) {
                        try {
                            if (prefixes[i] != null && !prefixes[i].isEmpty() && !prefixes[i].equals("null")) {
                                binaryParams.add(prefixes[i]);
                            }
                            binaryParams.addAll(BinaryRunner.serializeArrayParam(values[i]));
                            continue block10;
                        }
                        catch (Exception e) {
                            throw new InvokeExecutionException(ERROR_PARAM_NOT_STRING, e);
                        }
                    }
                    if (values[i] != null && values[i] instanceof Collection) {
                        try {
                            if (prefixes[i] != null && !prefixes[i].isEmpty() && !prefixes[i].equals("null")) {
                                binaryParams.add(prefixes[i]);
                            }
                            binaryParams.addAll(BinaryRunner.serializeCollectionParam((Collection)values[i]));
                            continue block10;
                        }
                        catch (Exception e) {
                            throw new InvokeExecutionException(ERROR_PARAM_NOT_STRING, e);
                        }
                    }
                    if (prefixes[i] != null && !prefixes[i].isEmpty() && !prefixes[i].equals("null")) {
                        binaryParams.add(prefixes[i] + String.valueOf(values[i]));
                        continue block10;
                    }
                    binaryParams.add(String.valueOf(values[i]));
                }
            }
        }
        return binaryParams;
    }

    public static Object executeCMD(String[] cmd, StreamSTD streamValues, File taskSandboxWorkingDir) throws InvokeExecutionException {
        String fileErrPath;
        String fileOutPath;
        ProcessBuilder builder = new ProcessBuilder(cmd);
        builder.directory(taskSandboxWorkingDir);
        builder.environment().remove("LD_PRELOAD");
        String fileInPath = streamValues.getStdIn();
        if (fileInPath != null) {
            builder.redirectInput(new File(fileInPath));
        }
        if ((fileOutPath = streamValues.getStdOut()) != null) {
            builder.redirectOutput(ProcessBuilder.Redirect.appendTo(new File(fileOutPath)));
        }
        if ((fileErrPath = streamValues.getStdErr()) != null) {
            builder.redirectError(ProcessBuilder.Redirect.appendTo(new File(fileErrPath)));
        }
        Process process = null;
        int exitValue = -1;
        try {
            System.out.println("[BINARY EXECUTION WRAPPER] ------------------------------------");
            System.out.println("[BINARY EXECUTION WRAPPER] Executing binary command");
            process = builder.start();
            process.getOutputStream().close();
            exitValue = process.waitFor();
        }
        catch (Exception e) {
            try {
                throw new InvokeExecutionException(ERROR_PROC_EXEC, e);
            }
            catch (Throwable throwable) {
                BinaryRunner.logBinaryExecution(process, exitValue, fileOutPath, fileErrPath);
                throw throwable;
            }
        }
        BinaryRunner.logBinaryExecution(process, exitValue, fileOutPath, fileErrPath);
        return exitValue;
    }

    private static void logBinaryExecution(Process process, int exitValue, String fileOutPath, String fileErrPath) throws InvokeExecutionException {
        String line2;
        Throwable throwable;
        System.out.println("[BINARY EXECUTION WRAPPER] ------------------------------------");
        System.out.println("[BINARY EXECUTION WRAPPER] CMD EXIT VALUE: " + exitValue);
        System.out.println("[BINARY EXECUTION WRAPPER] ------------------------------------");
        System.out.println("[BINARY EXECUTION WRAPPER] CMD OUTPUT:");
        if (process != null) {
            try {
                throwable = null;
                try (BufferedReader outputReader = fileOutPath != null ? new BufferedReader(new FileReader(fileOutPath)) : new BufferedReader(new InputStreamReader(process.getInputStream()));){
                    line2 = null;
                    while ((line2 = outputReader.readLine()) != null) {
                        System.out.println(line2);
                    }
                }
                catch (Throwable line2) {
                    throwable = line2;
                    throw line2;
                }
            }
            catch (IOException ioe) {
                throw new InvokeExecutionException(ERROR_OUTPUTREADER, ioe);
            }
        }
        System.out.println("[BINARY EXECUTION WRAPPER] ------------------------------------");
        System.err.println("[BINARY EXECUTION WRAPPER] ------------------------------------");
        System.err.println("[BINARY EXECUTION WRAPPER] CMD ERROR:");
        if (process != null) {
            try {
                throwable = null;
                try (BufferedReader errorReader = fileErrPath != null ? new BufferedReader(new FileReader(fileErrPath)) : new BufferedReader(new InputStreamReader(process.getErrorStream()));){
                    line2 = null;
                    while ((line2 = errorReader.readLine()) != null) {
                        System.err.println(line2);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (IOException ioe) {
                throw new InvokeExecutionException(ERROR_ERRORREADER, ioe);
            }
        }
        System.err.println("[BINARY EXECUTION WRAPPER] ------------------------------------");
    }

    private static ArrayList<String> serializeArrayParam(Object value) throws Exception {
        ArrayList<String> serializedValue = new ArrayList<String>();
        if (value instanceof int[]) {
            int[] arrayValues;
            for (int paramValue : arrayValues = (int[])value) {
                serializedValue.add(String.valueOf(paramValue));
            }
        } else if (value instanceof boolean[]) {
            boolean[] arrayValues;
            for (boolean paramValue : arrayValues = (boolean[])value) {
                serializedValue.add(String.valueOf(paramValue));
            }
        } else if (value instanceof byte[]) {
            byte[] arrayValues;
            for (byte paramValue : arrayValues = (byte[])value) {
                serializedValue.add(String.valueOf(paramValue));
            }
        } else if (value instanceof short[]) {
            short[] arrayValues;
            for (short paramValue : arrayValues = (short[])value) {
                serializedValue.add(String.valueOf(paramValue));
            }
        } else if (value instanceof char[]) {
            int[] arrayValues;
            for (int paramValue : arrayValues = (int[])value) {
                serializedValue.add(String.valueOf(paramValue));
            }
        } else if (value instanceof long[]) {
            long[] arrayValues;
            for (long paramValue : arrayValues = (long[])value) {
                serializedValue.add(String.valueOf(paramValue));
            }
        } else if (value instanceof float[]) {
            float[] arrayValues;
            for (float paramValue : arrayValues = (float[])value) {
                serializedValue.add(String.valueOf(paramValue));
            }
        } else if (value instanceof double[]) {
            double[] arrayValues;
            for (double paramValue : arrayValues = (double[])value) {
                serializedValue.add(String.valueOf(paramValue));
            }
        } else if (value instanceof Integer[]) {
            Integer[] arrayValues;
            for (Integer paramValue : arrayValues = (Integer[])value) {
                serializedValue.add(String.valueOf(paramValue));
            }
        } else if (value instanceof Boolean[]) {
            Boolean[] arrayValues;
            for (Boolean paramValue : arrayValues = (Boolean[])value) {
                serializedValue.add(String.valueOf(paramValue));
            }
        } else if (value instanceof Character[]) {
            Character[] arrayValues;
            for (Character paramValue : arrayValues = (Character[])value) {
                serializedValue.add(String.valueOf(paramValue));
            }
        } else if (value instanceof Byte[]) {
            Byte[] arrayValues;
            for (Byte paramValue : arrayValues = (Byte[])value) {
                serializedValue.add(String.valueOf(paramValue));
            }
        } else if (value instanceof Short[]) {
            Short[] arrayValues;
            for (Short paramValue : arrayValues = (Short[])value) {
                serializedValue.add(String.valueOf(paramValue));
            }
        } else if (value instanceof Long[]) {
            Long[] arrayValues;
            for (Long paramValue : arrayValues = (Long[])value) {
                serializedValue.add(String.valueOf(paramValue));
            }
        } else if (value instanceof Float[]) {
            Float[] arrayValues;
            for (Float paramValue : arrayValues = (Float[])value) {
                serializedValue.add(String.valueOf(paramValue));
            }
        } else if (value instanceof Double[]) {
            Double[] arrayValues;
            for (Double paramValue : arrayValues = (Double[])value) {
                serializedValue.add(String.valueOf(paramValue));
            }
        } else if (value instanceof String[]) {
            String[] arrayValues;
            for (String paramValue : arrayValues = (String[])value) {
                serializedValue.add(String.valueOf(paramValue));
            }
        } else if (value instanceof Object[]) {
            Object[] arrayValues;
            for (Object paramValue : arrayValues = (Object[])value) {
                serializedValue.addAll(BinaryRunner.serializeArrayParam(paramValue));
            }
        } else {
            serializedValue.add(String.valueOf(value));
        }
        return serializedValue;
    }

    private static ArrayList<String> serializeCollectionParam(Collection<?> value) throws Exception {
        ArrayList<String> serializedValue = new ArrayList<String>();
        Iterator<?> iterator = value.iterator();
        while (iterator.hasNext()) {
            serializedValue.add(String.valueOf(iterator.next()));
        }
        return serializedValue;
    }

    public static class StreamSTD {
        private String stdIn = null;
        private String stdOut = null;
        private String stdErr = null;

        public String getStdIn() {
            return this.stdIn;
        }

        public String getStdOut() {
            return this.stdOut;
        }

        public String getStdErr() {
            return this.stdErr;
        }

        public void setStdIn(String stdIn) {
            this.stdIn = stdIn;
        }

        public void setStdOut(String stdOut) {
            this.stdOut = stdOut;
        }

        public void setStdErr(String stdErr) {
            this.stdErr = stdErr;
        }
    }
}

