/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.suppliers;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.Maps;
import java.util.Map;
import javax.inject.Inject;
import org.jclouds.cloudstack.CloudStackApi;
import org.jclouds.cloudstack.domain.Project;
import org.jclouds.cloudstack.domain.User;
import org.jclouds.cloudstack.features.ProjectApi;
import org.jclouds.cloudstack.options.ListProjectsOptions;
import org.jclouds.collect.Memoized;

public class ProjectsForCurrentUser
implements Supplier<Map<String, Project>> {
    private final CloudStackApi api;
    private final Supplier<User> currentUserSupplier;

    @Inject
    public ProjectsForCurrentUser(CloudStackApi api, @Memoized Supplier<User> currentUserSupplier) {
        this.api = Preconditions.checkNotNull(api, "api");
        this.currentUserSupplier = Preconditions.checkNotNull(currentUserSupplier, "currentUserSupplier");
    }

    @Override
    public Map<String, Project> get() {
        User currentUser = this.currentUserSupplier.get();
        ProjectApi projectApi = this.api.getProjectApi();
        return Maps.uniqueIndex(projectApi.listProjects(ListProjectsOptions.Builder.accountInDomain(currentUser.getAccount(), currentUser.getDomainId())), new Function<Project, String>(){

            @Override
            public String apply(Project arg0) {
                return arg0.getId();
            }
        });
    }
}

