/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ForwardingSet;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Ordering;
import java.util.Set;
import org.jclouds.ec2.domain.RunningInstance;
import org.jclouds.javax.annotation.Nullable;

public class Reservation<T extends RunningInstance>
extends ForwardingSet<T>
implements Comparable<Reservation<T>> {
    private final String region;
    private final ImmutableSet<String> groupNames;
    private final ImmutableSet<T> instances;
    @Nullable
    private final String ownerId;
    @Nullable
    private final String requesterId;
    @Nullable
    private final String reservationId;

    public static <T extends RunningInstance> Builder<T> builder() {
        return new Builder();
    }

    public Builder<T> toBuilder() {
        return Reservation.builder().fromReservation(this);
    }

    public Reservation(String region, Iterable<String> groupNames, Iterable<T> instances, @Nullable String ownerId, @Nullable String requesterId, @Nullable String reservationId) {
        this.region = Preconditions.checkNotNull(region, "region");
        this.groupNames = ImmutableSet.copyOf(Preconditions.checkNotNull(groupNames, "groupNames"));
        this.instances = ImmutableSet.copyOf(Preconditions.checkNotNull(instances, "instances"));
        this.ownerId = ownerId;
        this.requesterId = requesterId;
        this.reservationId = reservationId;
    }

    @Override
    protected Set<T> delegate() {
        return this.instances;
    }

    @Deprecated
    public String getRegion() {
        return this.region;
    }

    public Set<String> getGroupNames() {
        return this.groupNames;
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    public String getRequesterId() {
        return this.requesterId;
    }

    public String getReservationId() {
        return this.reservationId;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.region, this.reservationId, super.hashCode());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Reservation that = (Reservation)Reservation.class.cast(obj);
        return super.equals(that) && Objects.equal(this.region, that.region) && Objects.equal(this.reservationId, that.reservationId);
    }

    @Override
    public String toString() {
        return Objects.toStringHelper(this).omitNullValues().add("region", this.region).add("reservationId", this.reservationId).add("requesterId", this.requesterId).add("instances", this.instances).add("groupNames", this.groupNames).toString();
    }

    @Override
    public int compareTo(Reservation<T> other) {
        return ComparisonChain.start().compare((Comparable<?>)((Object)this.region), (Comparable<?>)((Object)other.region)).compare(this.reservationId, other.reservationId, Ordering.natural().nullsLast()).result();
    }

    public static class Builder<T extends RunningInstance> {
        private String region;
        private String ownerId;
        private String requesterId;
        private String reservationId;
        private ImmutableSet.Builder<T> instances = ImmutableSet.builder();
        private ImmutableSet.Builder<String> groupNames = ImmutableSet.builder();

        public Builder<T> region(String region) {
            this.region = region;
            return this;
        }

        public Builder<T> ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public Builder<T> requesterId(String requesterId) {
            this.requesterId = requesterId;
            return this;
        }

        public Builder<T> reservationId(String reservationId) {
            this.reservationId = reservationId;
            return this;
        }

        public Builder<T> instance(T instance) {
            this.instances.add((Object)Preconditions.checkNotNull(instance, "instance"));
            return this;
        }

        public Builder<T> instances(Set<T> instances) {
            this.instances.addAll(Preconditions.checkNotNull(instances, "instances"));
            return this;
        }

        public Builder<T> groupName(String groupName) {
            this.groupNames.add((Object)Preconditions.checkNotNull(groupName, "groupName"));
            return this;
        }

        public Builder<T> groupNames(Iterable<String> groupNames) {
            this.groupNames = ImmutableSet.builder().addAll(Preconditions.checkNotNull(groupNames, "groupNames"));
            return this;
        }

        public Reservation<T> build() {
            return new Reservation(this.region, this.groupNames.build(), this.instances.build(), this.ownerId, this.requesterId, this.reservationId);
        }

        public Builder<T> fromReservation(Reservation<T> in) {
            return this.region(((Reservation)in).region).ownerId(((Reservation)in).ownerId).requesterId(((Reservation)in).requesterId).reservationId(((Reservation)in).reservationId).instances(in).groupNames(((Reservation)in).groupNames);
        }
    }
}

