/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.nio.master;

import es.bsc.comm.Connection;
import es.bsc.comm.nio.NIONode;
import es.bsc.compss.comm.Comm;
import es.bsc.compss.exceptions.InitNodeException;
import es.bsc.compss.exceptions.UnstartedNodeException;
import es.bsc.compss.nio.NIOAgent;
import es.bsc.compss.nio.NIOTask;
import es.bsc.compss.nio.NIOTracer;
import es.bsc.compss.nio.NIOURI;
import es.bsc.compss.nio.commands.CommandExecutorShutdown;
import es.bsc.compss.nio.commands.CommandNewTask;
import es.bsc.compss.nio.commands.CommandShutdown;
import es.bsc.compss.nio.commands.Data;
import es.bsc.compss.nio.commands.tracing.CommandGeneratePackage;
import es.bsc.compss.nio.commands.workerFiles.CommandGenerateWorkerDebugFiles;
import es.bsc.compss.nio.dataRequest.MasterDataRequest;
import es.bsc.compss.nio.master.NIOAdaptor;
import es.bsc.compss.nio.master.NIOJob;
import es.bsc.compss.nio.master.WorkerStarter;
import es.bsc.compss.nio.master.configuration.NIOConfiguration;
import es.bsc.compss.types.COMPSsWorker;
import es.bsc.compss.types.TaskDescription;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.data.LogicalData;
import es.bsc.compss.types.data.Transferable;
import es.bsc.compss.types.data.listener.EventListener;
import es.bsc.compss.types.data.location.DataLocation;
import es.bsc.compss.types.data.operation.DataOperation;
import es.bsc.compss.types.data.operation.copy.DeferredCopy;
import es.bsc.compss.types.data.operation.copy.StorageCopy;
import es.bsc.compss.types.implementations.Implementation;
import es.bsc.compss.types.job.Job;
import es.bsc.compss.types.job.JobListener;
import es.bsc.compss.types.resources.ExecutorShutdownListener;
import es.bsc.compss.types.resources.Resource;
import es.bsc.compss.types.resources.ShutdownListener;
import es.bsc.compss.types.uri.MultiURI;
import es.bsc.compss.types.uri.SimpleURI;
import es.bsc.compss.util.ErrorManager;
import es.bsc.compss.util.Tracer;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import storage.StorageException;
import storage.StorageItf;

public class NIOWorkerNode
extends COMPSsWorker {
    protected static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Communication");
    private NIONode node;
    private final NIOConfiguration config;
    private final NIOAdaptor commManager;
    private boolean started = false;
    private WorkerStarter workerStarter;

    @Override
    public String getName() {
        return this.config.getHost();
    }

    public NIOWorkerNode(String name, NIOConfiguration config, NIOAdaptor adaptor) {
        super(name, config);
        this.config = config;
        this.commManager = adaptor;
    }

    @Override
    public void start() throws InitNodeException {
        NIONode n = null;
        try {
            this.workerStarter = new WorkerStarter(this);
            n = this.workerStarter.startWorker();
        }
        catch (InitNodeException e) {
            ErrorManager.warn("There was an exception when initiating worker " + this.getName() + ".", e);
            throw e;
        }
        this.node = n;
        this.started = true;
        if (NIOTracer.isActivated()) {
            LOGGER.debug("Initializing NIO tracer " + this.getName());
            NIOTracer.startTracing(this.getName(), this.getUser(), this.getHost(), this.getLimitOfTasks());
        }
    }

    @Override
    public String getUser() {
        return this.config.getUser();
    }

    public String getHost() {
        return this.config.getHost();
    }

    public String getInstallDir() {
        return this.config.getInstallDir();
    }

    public String getBaseWorkingDir() {
        return this.config.getWorkingDir();
    }

    public String getWorkingDir() {
        return this.config.getSandboxWorkingDir();
    }

    public String getAppDir() {
        return this.config.getAppDir();
    }

    public String getLibPath() {
        return this.config.getLibraryPath();
    }

    @Override
    public String getClasspath() {
        return this.config.getClasspath();
    }

    @Override
    public String getPythonpath() {
        return this.config.getPythonpath();
    }

    public int getLimitOfTasks() {
        return this.config.getLimitOfTasks();
    }

    public int getTotalComputingUnits() {
        return this.config.getTotalComputingUnits();
    }

    public int getTotalGPUs() {
        return this.config.getTotalGPUComputingUnits();
    }

    public NIOConfiguration getConfiguration() {
        return this.config;
    }

    @Override
    public void setInternalURI(MultiURI uri) throws UnstartedNodeException {
        if (this.node == null) {
            throw new UnstartedNodeException();
        }
        NIOURI nio = new NIOURI(this.node, uri.getPath());
        uri.setInternalURI(NIOAdaptor.ID, nio);
    }

    @Override
    public Job<?> newJob(int taskId, TaskDescription taskParams, Implementation impl, Resource res, List<String> slaveWorkersNodeNames, JobListener listener) {
        return new NIOJob(taskId, taskParams, impl, res, slaveWorkersNodeNames, listener);
    }

    @Override
    public void stop(ShutdownListener sl) {
        if (this.started) {
            LOGGER.debug("Shutting down " + this.getName());
            if (this.node == null) {
                sl.notifyFailure(new UnstartedNodeException());
                LOGGER.error("Shutdown has failed");
            }
            Connection c = NIOAgent.getTransferManager().startConnection(this.node);
            this.commManager.shuttingDown(this, c, sl);
            CommandShutdown cmd = new CommandShutdown(null, null);
            c.sendCommand(cmd);
            c.receive();
            c.finishConnection();
        } else {
            LOGGER.debug("Worker " + this.getName() + " has not started. Setting this to be stopped");
            this.workerStarter.setToStop();
            sl.notifyEnd();
        }
    }

    @Override
    public void shutdownExecutionManager(ExecutorShutdownListener esl) {
        if (this.started) {
            LOGGER.debug("Shutting down execution manager " + this.getName());
            if (this.node == null) {
                esl.notifyFailure(new UnstartedNodeException());
                LOGGER.error("Shutdown execution manager has failed");
            }
            Connection c = NIOAgent.getTransferManager().startConnection(this.node);
            this.commManager.shuttingDownEM(this, c, esl);
            CommandExecutorShutdown cmd = new CommandExecutorShutdown(null);
            c.sendCommand(cmd);
            c.receive();
            c.finishConnection();
        } else {
            LOGGER.debug("Worker " + this.getName() + " has not started. Considering execution manager stopped");
            esl.notifyEnd();
        }
    }

    @Override
    public void sendData(LogicalData ld, DataLocation source, DataLocation target, LogicalData tgtData, Transferable reason, EventListener listener) {
        if (target.getHosts().contains(Comm.getAppHost())) {
            MultiURI u;
            if (tgtData != null && (u = ld.alreadyAvailable(Comm.getAppHost())) != null) {
                reason.setDataTarget(u.getPath());
                listener.notifyEnd(null);
                return;
            }
            DeferredCopy c = new DeferredCopy(ld, null, target, tgtData, reason, listener);
            Data d = new Data(ld);
            if (source != null) {
                for (MultiURI uri : source.getURIs()) {
                    try {
                        NIOURI nURI = (NIOURI)uri.getInternalURI(NIOAdaptor.ID);
                        if (nURI == null) continue;
                        d.getSources().add(nURI);
                    }
                    catch (UnstartedNodeException unstartedNodeException) {}
                }
            }
            String path = target.getURIInHost(Comm.getAppHost()).getPath();
            c.setFinalTarget(path);
            ld.startCopy(c, c.getTargetLoc());
            MasterDataRequest dr = new MasterDataRequest(c, reason.getType(), d, path);
            this.commManager.addTransferRequest(dr);
            this.commManager.requestTransfers();
        } else {
            this.orderCopy(new DeferredCopy(ld, source, target, tgtData, reason, listener));
        }
    }

    @Override
    public void obtainData(LogicalData ld, DataLocation source, DataLocation target, LogicalData tgtData, Transferable reason, EventListener listener) {
        if (ld == null) {
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Obtain Data " + ld.getName() + " as " + target);
        }
        for (DataLocation loc : ld.getLocations()) {
            if (!loc.getProtocol().equals((Object)DataLocation.Protocol.PERSISTENT_URI)) continue;
            this.orderStorageCopy(new StorageCopy(ld, source, target, tgtData, reason, listener));
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Ordering deferred copy " + ld.getName());
        }
        this.orderCopy(new DeferredCopy(ld, source, target, tgtData, reason, listener));
    }

    private void orderStorageCopy(StorageCopy sc) {
        LOGGER.info("Order PSCO Copy for " + sc.getSourceData().getName());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("LD Target " + sc.getTargetData());
            LOGGER.debug("FROM: " + sc.getPreferredSource());
            LOGGER.debug("TO: " + sc.getTargetLoc());
            LOGGER.debug("MUST PRESERVE: " + sc.mustPreserveSourceData());
        }
        LogicalData source = sc.getSourceData();
        LogicalData target = sc.getTargetData();
        if (target != null) {
            if (target.getName().equals(source.getName())) {
                this.newReplica(sc);
            } else {
                this.newVersion(sc);
            }
        } else {
            this.newVersion(sc);
        }
    }

    private void newReplica(StorageCopy sc) {
        String targetHostname = this.getName();
        LogicalData srcLD = sc.getSourceData();
        LogicalData targetLD = sc.getTargetData();
        LOGGER.debug("Ask for new Replica of " + srcLD.getName() + " to " + targetHostname);
        String pscoId = srcLD.getId();
        List<Object> currentLocations = new LinkedList();
        try {
            currentLocations = StorageItf.getLocations(pscoId);
        }
        catch (StorageException se) {
            sc.end(DataOperation.OpEndState.OP_FAILED, se);
            return;
        }
        if (!currentLocations.contains(targetHostname)) {
            LOGGER.debug("Performing new replica for PSCO " + pscoId);
            if (NIOTracer.isActivated()) {
                NIOTracer.emitEvent(Tracer.Event.STORAGE_NEWREPLICA.getId(), Tracer.Event.STORAGE_NEWREPLICA.getType());
            }
            if (NIOTracer.isActivated()) {
                NIOTracer.emitEvent(0L, Tracer.Event.STORAGE_NEWREPLICA.getType());
            }
        } else {
            LOGGER.debug("PSCO " + pscoId + " already present. Skip replica.");
        }
        sc.setFinalTarget(pscoId);
        if (targetLD != null) {
            targetLD.setId(pscoId);
        }
        sc.end(DataOperation.OpEndState.OP_OK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void newVersion(StorageCopy sc) {
        String targetHostname = this.getName();
        LogicalData srcLD = sc.getSourceData();
        LogicalData targetLD = sc.getTargetData();
        boolean preserveSource = sc.mustPreserveSourceData();
        if (DEBUG) {
            LOGGER.debug("Ask for new Version of " + srcLD.getName() + " with id " + srcLD.getId() + " to " + targetHostname + " with must preserve " + preserveSource);
        }
        String pscoId = srcLD.getId();
        LOGGER.debug("Performing new version for PSCO " + pscoId);
        if (NIOTracer.isActivated()) {
            NIOTracer.emitEvent(Tracer.Event.STORAGE_NEWVERSION.getId(), Tracer.Event.STORAGE_NEWVERSION.getType());
        }
        try {
            String newId = StorageItf.newVersion(pscoId, preserveSource, Comm.getAppHost().getName());
            LOGGER.debug("Register new new version of " + pscoId + " as " + newId);
            sc.setFinalTarget(newId);
            if (targetLD != null) {
                targetLD.setId(newId);
            }
        }
        catch (Exception e) {
            sc.end(DataOperation.OpEndState.OP_FAILED, e);
            return;
        }
        finally {
            if (NIOTracer.isActivated()) {
                NIOTracer.emitEvent(0L, Tracer.Event.STORAGE_NEWVERSION.getType());
            }
        }
        sc.end(DataOperation.OpEndState.OP_OK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void orderCopy(DeferredCopy c) {
        LogicalData ld;
        LOGGER.info("Order Copy for " + c.getSourceData());
        Resource tgtRes = (Resource)((LinkedList)c.getTargetLoc().getHosts()).getFirst();
        LogicalData logicalData = ld = c.getSourceData();
        synchronized (logicalData) {
            MultiURI u;
            String path = c.getTargetData() != null ? ((u = ld.alreadyAvailable(tgtRes)) != null ? u.getPath() : c.getTargetLoc().getURIInHost(tgtRes).getPath()) : c.getTargetLoc().getURIInHost(tgtRes).getPath();
            c.setProposedSource(new Data(ld));
            LOGGER.debug("Setting final target in deferred copy " + path);
            c.setFinalTarget(path);
            ld.startCopy(c, c.getTargetLoc());
            this.commManager.registerCopy(c);
        }
        c.end(DataOperation.OpEndState.OP_OK);
    }

    @Override
    public void updateTaskCount(int processorCoreCount) {
    }

    @Override
    public void announceDestruction() {
    }

    @Override
    public void announceCreation() {
    }

    @Override
    public SimpleURI getCompletePath(DataType type, String name) {
        String path = null;
        switch (type) {
            case FILE_T: {
                path = DataLocation.Protocol.FILE_URI.getSchema() + this.config.getSandboxWorkingDir() + name;
                break;
            }
            case OBJECT_T: {
                path = DataLocation.Protocol.OBJECT_URI.getSchema() + name;
                break;
            }
            case PSCO_T: {
                String id = Comm.getData(name).getId();
                path = DataLocation.Protocol.PERSISTENT_URI.getSchema() + id;
                break;
            }
            case EXTERNAL_OBJECT_T: {
                path = DataLocation.Protocol.PERSISTENT_URI.getSchema() + name;
                break;
            }
            default: {
                return null;
            }
        }
        return new SimpleURI(path);
    }

    @Override
    public void deleteTemporary() {
    }

    @Override
    public boolean generatePackage() {
        if (this.started) {
            LOGGER.debug("Sending command to generated tracing package for " + this.getHost());
            if (this.node == null) {
                LOGGER.error("ERROR: Package generation for " + this.getHost() + " has failed.");
                return false;
            }
            Connection c = NIOAgent.getTransferManager().startConnection(this.node);
            CommandGeneratePackage cmd = new CommandGeneratePackage();
            c.sendCommand(cmd);
            c.receive();
            c.finishConnection();
            this.commManager.waitUntilTracingPackageGenerated();
            LOGGER.debug("Tracing Package generated");
            return true;
        }
        LOGGER.debug("Worker " + this.getHost() + " not started. No tracing package generated");
        return false;
    }

    @Override
    public boolean generateWorkersDebugInfo() {
        if (this.started) {
            LOGGER.debug("Sending command to generate worker debug files for " + this.getHost());
            if (this.node == null) {
                LOGGER.error("Worker debug files generation has failed.");
            }
            Connection c = NIOAgent.getTransferManager().startConnection(this.node);
            CommandGenerateWorkerDebugFiles cmd = new CommandGenerateWorkerDebugFiles();
            c.sendCommand(cmd);
            c.receive();
            c.finishConnection();
            this.commManager.waitUntilWorkersDebugInfoGenerated();
            LOGGER.debug("Worker debug files generated");
            return true;
        }
        LOGGER.debug("Worker debug files not generated because worker was not started");
        return false;
    }

    public void submitTask(NIOJob job, List<String> obsolete) throws UnstartedNodeException {
        if (this.node == null) {
            throw new UnstartedNodeException();
        }
        NIOTask t = job.prepareJob();
        CommandNewTask cmd = new CommandNewTask(t, obsolete);
        Connection c = NIOAgent.getTransferManager().startConnection(this.node);
        c.sendCommand(cmd);
        c.finishConnection();
    }

    public void setStarted(boolean b) {
        this.started = b;
    }
}

