/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.resources;

import es.bsc.compss.types.COMPSsWorker;
import es.bsc.compss.types.CloudProvider;
import es.bsc.compss.types.resources.MethodResourceDescription;
import es.bsc.compss.types.resources.MethodWorker;
import es.bsc.compss.types.resources.Resource;
import es.bsc.compss.types.resources.ResourceDescription;
import es.bsc.compss.types.resources.configuration.MethodConfiguration;
import es.bsc.compss.types.resources.description.CloudImageDescription;
import es.bsc.compss.types.resources.description.CloudMethodResourceDescription;
import es.bsc.compss.types.resources.updates.PendingReduction;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public class CloudMethodWorker
extends MethodWorker {
    private final LinkedList<PendingReduction<MethodResourceDescription>> pendingReductions;
    private final CloudMethodResourceDescription toRemove;
    private final CloudProvider provider;

    public CloudMethodWorker(String name, CloudProvider provider, CloudMethodResourceDescription description, COMPSsWorker worker, int limitOfTasks, int limitGPUTasks, int limitFPGATasks, int limitOTHERTasks, Map<String, String> sharedDisks) {
        super(name, description, worker, limitOfTasks, limitGPUTasks, limitFPGATasks, limitOTHERTasks, sharedDisks);
        this.provider = provider;
        this.toRemove = new CloudMethodResourceDescription();
        this.pendingReductions = new LinkedList();
    }

    public CloudMethodWorker(String name, CloudProvider provider, CloudMethodResourceDescription description, MethodConfiguration config, Map<String, String> sharedDisks) {
        super(name, description, config, sharedDisks);
        this.provider = provider;
        if (this.description != null) {
            ((CloudMethodResourceDescription)this.description).setName(name);
        }
        this.toRemove = new CloudMethodResourceDescription();
        this.pendingReductions = new LinkedList();
    }

    public CloudMethodWorker(CloudMethodWorker cmw) {
        super(cmw);
        this.provider = cmw.provider;
        this.toRemove = cmw.toRemove.copy();
        this.pendingReductions = cmw.pendingReductions;
    }

    public CloudProvider getProvider() {
        return this.provider;
    }

    @Override
    public Resource.Type getType() {
        return Resource.Type.WORKER;
    }

    @Override
    public CloudMethodResourceDescription getDescription() {
        return (CloudMethodResourceDescription)super.getDescription();
    }

    @Override
    public String getMonitoringData(String prefix) {
        StringBuilder sb = new StringBuilder();
        sb.append(prefix).append(super.getMonitoringData(prefix));
        String providerName = this.provider.getName();
        if (providerName == null) {
            providerName = "";
        }
        sb.append(prefix).append("<Provider>").append(providerName).append("</Provider>").append("\n");
        CloudImageDescription image = ((CloudMethodResourceDescription)this.description).getImage();
        String imageName = "";
        if (image != null) {
            imageName = image.getImageName();
        }
        sb.append(prefix).append("<Image>").append(imageName).append("</Image>").append("\n");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void increaseFeatures(CloudMethodResourceDescription increment) {
        MethodResourceDescription methodResourceDescription = this.available;
        synchronized (methodResourceDescription) {
            this.available.increase(increment);
        }
        methodResourceDescription = (MethodResourceDescription)this.description;
        synchronized (methodResourceDescription) {
            ((CloudMethodResourceDescription)this.description).increase(increment);
        }
        this.updatedFeatures();
    }

    @Override
    public MethodResourceDescription reserveResource(MethodResourceDescription consumption) {
        if (!this.hasAvailable(consumption)) {
            return null;
        }
        return super.reserveResource(consumption);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void releaseResource(MethodResourceDescription consumption) {
        LOGGER.debug("Checking cloud resources to release...");
        MethodResourceDescription methodResourceDescription = this.available;
        synchronized (methodResourceDescription) {
            super.releaseResource(consumption);
            LinkedList<PendingReduction<MethodResourceDescription>> linkedList = this.pendingReductions;
            synchronized (linkedList) {
                if (!this.pendingReductions.isEmpty()) {
                    PendingReduction pRed;
                    Iterator prIt = this.pendingReductions.iterator();
                    while (prIt.hasNext() && this.available.containsDynamic((MethodResourceDescription)(pRed = (PendingReduction)prIt.next()).getModification())) {
                        this.available.reduce((ResourceDescription)pRed.getModification());
                        CloudMethodResourceDescription cloudMethodResourceDescription = this.toRemove;
                        synchronized (cloudMethodResourceDescription) {
                            this.toRemove.reduce((ResourceDescription)pRed.getModification());
                        }
                        LOGGER.debug("Releasing cloud resource " + this.getName());
                        pRed.notifyCompletion();
                        prIt.remove();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void applyReduction(PendingReduction<MethodResourceDescription> pRed) {
        CloudMethodResourceDescription reduction = (CloudMethodResourceDescription)pRed.getModification();
        MethodResourceDescription methodResourceDescription = (MethodResourceDescription)this.description;
        synchronized (methodResourceDescription) {
            ((CloudMethodResourceDescription)this.description).reduce(reduction);
        }
        methodResourceDescription = this.available;
        synchronized (methodResourceDescription) {
            if (!this.hasAvailable(reduction) && this.getUsedCPUTaskCount() > 0) {
                LOGGER.debug("Resource in use. Adding pending reduction");
                Serializable serializable = this.toRemove;
                synchronized (serializable) {
                    this.toRemove.increase(reduction);
                }
                serializable = this.pendingReductions;
                synchronized (serializable) {
                    this.pendingReductions.add(pRed);
                }
            }
            this.available.reduce(reduction);
            pRed.notifyCompletion();
        }
        this.updatedFeatures();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasAvailable(MethodResourceDescription consumption) {
        MethodResourceDescription methodResourceDescription = this.available;
        synchronized (methodResourceDescription) {
            CloudMethodResourceDescription cloudMethodResourceDescription = this.toRemove;
            synchronized (cloudMethodResourceDescription) {
                consumption.increaseDynamic(this.toRemove);
                boolean fits = super.hasAvailable(consumption);
                consumption.reduceDynamic(this.toRemove);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Cloud Method Worker received:");
                    LOGGER.debug("With result: " + fits);
                }
                return fits;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldBeStopped() {
        MethodResourceDescription methodResourceDescription = this.available;
        synchronized (methodResourceDescription) {
            CloudMethodResourceDescription cloudMethodResourceDescription = this.toRemove;
            synchronized (cloudMethodResourceDescription) {
                return this.available.getTotalCPUComputingUnits() == 0 && this.toRemove.getTotalCPUComputingUnits() == 0;
            }
        }
    }

    @Override
    public CloudMethodWorker getSchedulingCopy() {
        return new CloudMethodWorker(this);
    }
}

