/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.domain.internal;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Ordering;
import java.net.URI;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.jclouds.compute.domain.ComputeMetadata;
import org.jclouds.compute.domain.ComputeType;
import org.jclouds.domain.Location;
import org.jclouds.domain.ResourceMetadata;
import org.jclouds.domain.internal.ResourceMetadataImpl;

public class ComputeMetadataImpl
extends ResourceMetadataImpl<ComputeType>
implements ComputeMetadata {
    private final String id;
    private final ComputeType type;
    protected final Set<String> tags;

    public ComputeMetadataImpl(ComputeType type, String providerId, String name, String id, Location location, URI uri, Map<String, String> userMetadata, Set<String> tags) {
        super(providerId, name, location, uri, userMetadata);
        this.id = Preconditions.checkNotNull(id, "id");
        this.type = Preconditions.checkNotNull(type, "type");
        this.tags = ImmutableSet.copyOf((Collection)Preconditions.checkNotNull(tags, "tags"));
    }

    @Override
    public ComputeType getType() {
        return this.type;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Set<String> getTags() {
        return this.tags;
    }

    @Override
    public int compareTo(ResourceMetadata<ComputeType> that) {
        if (that instanceof ComputeMetadata) {
            ComputeMetadata thatMetadata = (ComputeMetadata)ComputeMetadata.class.cast(that);
            return ComparisonChain.start().compare((Comparable<?>)((Object)this.getId()), (Comparable<?>)((Object)thatMetadata.getId())).compare((Comparable<?>)((Object)this.getType()), (Comparable<?>)((Object)thatMetadata.getType())).compare(this.getName(), that.getName(), Ordering.natural().nullsLast()).result();
        }
        return super.compareTo(that);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComputeMetadataImpl that = (ComputeMetadataImpl)ComputeMetadataImpl.class.cast(o);
        return super.equals(that) && Objects.equal(this.id, that.id);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(super.hashCode(), this.id);
    }

    protected Objects.ToStringHelper computeToStringPrefix() {
        return Objects.toStringHelper("").omitNullValues().add("id", this.getId()).add("providerId", this.getProviderId()).add("uri", this.getUri()).add("name", this.getName()).add("uri", this.getUri()).add("location", this.getLocation());
    }

    protected Objects.ToStringHelper addComputeToStringSuffix(Objects.ToStringHelper helper) {
        if (!this.getTags().isEmpty()) {
            helper.add("tags", this.getTags());
        }
        if (!this.getUserMetadata().isEmpty()) {
            helper.add("userMetadata", this.getUserMetadata());
        }
        return helper;
    }

    @Override
    protected Objects.ToStringHelper string() {
        return this.addComputeToStringSuffix(this.computeToStringPrefix());
    }
}

