/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.compute.strategy;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Atomics;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.aws.util.AWSUtils;
import org.jclouds.compute.config.CustomizationResponse;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.functions.DefaultCredentialsFromImageOrOverridingCredentials;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.compute.strategy.CreateNodesInGroupThenAddToSet;
import org.jclouds.compute.util.ComputeUtils;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.ec2.EC2Api;
import org.jclouds.ec2.compute.domain.RegionAndName;
import org.jclouds.ec2.compute.functions.PresentInstances;
import org.jclouds.ec2.compute.options.EC2TemplateOptions;
import org.jclouds.ec2.compute.strategy.CreateKeyPairAndSecurityGroupsAsNeededAndReturnRunOptions;
import org.jclouds.ec2.compute.util.EC2ComputeUtils;
import org.jclouds.ec2.domain.RunningInstance;
import org.jclouds.ec2.options.RunInstancesOptions;
import org.jclouds.logging.Logger;

@Singleton
public class EC2CreateNodesInGroupThenAddToSet
implements CreateNodesInGroupThenAddToSet {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    @Inject
    @Named(value="jclouds.ec2.auto-allocate-elastic-ips")
    @VisibleForTesting
    boolean autoAllocateElasticIps = false;
    @VisibleForTesting
    final EC2Api client;
    @VisibleForTesting
    final Predicate<AtomicReference<NodeMetadata>> nodeRunning;
    @VisibleForTesting
    final LoadingCache<RegionAndName, String> elasticIpCache;
    @VisibleForTesting
    final CreateKeyPairAndSecurityGroupsAsNeededAndReturnRunOptions createKeyPairAndSecurityGroupsAsNeededAndReturncustomize;
    @VisibleForTesting
    final Function<RunningInstance, NodeMetadata> runningInstanceToNodeMetadata;
    @VisibleForTesting
    final ComputeUtils utils;
    final PresentInstances presentInstances;
    final LoadingCache<RunningInstance, Optional<LoginCredentials>> instanceToCredentials;
    final Map<String, Credentials> credentialStore;
    public static final Function<RunningInstance, RegionAndName> instanceToRegionAndName = new Function<RunningInstance, RegionAndName>(){

        @Override
        public RegionAndName apply(RunningInstance from) {
            return new RegionAndName(from.getRegion(), from.getId());
        }
    };

    @Inject
    protected EC2CreateNodesInGroupThenAddToSet(EC2Api client, @Named(value="ELASTICIP") LoadingCache<RegionAndName, String> elasticIpCache, @Named(value="jclouds.compute.timeout.node-running") Predicate<AtomicReference<NodeMetadata>> nodeRunning, CreateKeyPairAndSecurityGroupsAsNeededAndReturnRunOptions createKeyPairAndSecurityGroupsAsNeededAndReturncustomize, PresentInstances presentInstances, Function<RunningInstance, NodeMetadata> runningInstanceToNodeMetadata, LoadingCache<RunningInstance, Optional<LoginCredentials>> instanceToCredentials, Map<String, Credentials> credentialStore, ComputeUtils utils) {
        this.client = Preconditions.checkNotNull(client, "client");
        this.elasticIpCache = Preconditions.checkNotNull(elasticIpCache, "elasticIpCache");
        this.nodeRunning = Preconditions.checkNotNull(nodeRunning, "nodeRunning");
        this.presentInstances = Preconditions.checkNotNull(presentInstances, "presentInstances");
        this.createKeyPairAndSecurityGroupsAsNeededAndReturncustomize = Preconditions.checkNotNull(createKeyPairAndSecurityGroupsAsNeededAndReturncustomize, "createKeyPairAndSecurityGroupsAsNeededAndReturncustomize");
        this.runningInstanceToNodeMetadata = Preconditions.checkNotNull(runningInstanceToNodeMetadata, "runningInstanceToNodeMetadata");
        this.instanceToCredentials = Preconditions.checkNotNull(instanceToCredentials, "instanceToCredentials");
        this.credentialStore = Preconditions.checkNotNull(credentialStore, "credentialStore");
        this.utils = Preconditions.checkNotNull(utils, "utils");
    }

    @Override
    public Map<?, ListenableFuture<Void>> execute(String group, int count, Template template, Set<NodeMetadata> goodNodes, Map<NodeMetadata, Exception> badNodes, Multimap<NodeMetadata, CustomizationResponse> customizationResponses) {
        Template mutableTemplate = template.clone();
        Set<RunningInstance> started = this.runInstancesAndWarnOnInvisible(group, count, mutableTemplate);
        if (started.isEmpty()) {
            this.logger.warn("<< unable to start instances(%s)", mutableTemplate);
            return ImmutableMap.of();
        }
        this.populateCredentials(started, template.getOptions());
        if (this.autoAllocateElasticIps) {
            this.blockUntilRunningAndAssignElasticIpsToInstancesOrPutIntoBadMap(started, badNodes);
        }
        return this.utils.customizeNodesAndAddToGoodMapOrPutExceptionIntoBadMap(mutableTemplate.getOptions(), Iterables.transform(started, this.runningInstanceToNodeMetadata), goodNodes, badNodes, customizationResponses);
    }

    private Set<RunningInstance> runInstancesAndWarnOnInvisible(String group, int count, Template mutableTemplate) {
        Set<RunningInstance> started = this.createKeyPairAndSecurityGroupsAsNeededThenRunInstances(group, count, mutableTemplate);
        ImmutableSet<RegionAndName> startedIds = ImmutableSet.copyOf(Iterables.transform(started, instanceToRegionAndName));
        if (startedIds.isEmpty()) {
            return ImmutableSet.copyOf(started);
        }
        this.logger.debug("<< started instances(%s)", startedIds);
        Set<RunningInstance> visible = this.presentInstances.apply((Set<RegionAndName>)startedIds);
        ImmutableSet<RegionAndName> visibleIds = ImmutableSet.copyOf(Iterables.transform(visible, instanceToRegionAndName));
        this.logger.trace("<< visible instances(%s)", visibleIds);
        Sets.SetView<RegionAndName> invisibleIds = Sets.difference(startedIds, visibleIds);
        if (!invisibleIds.isEmpty()) {
            this.logger.warn("<< not api visible instances(%s)", invisibleIds);
        }
        return started;
    }

    private void populateCredentials(Set<RunningInstance> input, TemplateOptions options) {
        RunningInstance runningInstance;
        LoginCredentials credentials = null;
        Iterator<Object> i$ = input.iterator();
        while (i$.hasNext() && (credentials = this.instanceToCredentials.getUnchecked(runningInstance = i$.next()).orNull()) == null) {
        }
        if ((credentials = DefaultCredentialsFromImageOrOverridingCredentials.overrideDefaultCredentialsWithOptionsIfPresent(credentials, options)) != null) {
            for (RegionAndName regionAndName : Iterables.transform(input, instanceToRegionAndName)) {
                this.credentialStore.put("node#" + regionAndName.slashEncode(), credentials);
            }
        }
    }

    private void blockUntilRunningAndAssignElasticIpsToInstancesOrPutIntoBadMap(Set<RunningInstance> input, Map<NodeMetadata, Exception> badNodes) {
        ImmutableMap<RegionAndName, RunningInstance> instancesById = Maps.uniqueIndex(input, instanceToRegionAndName);
        for (Map.Entry entry : instancesById.entrySet()) {
            RegionAndName id = (RegionAndName)entry.getKey();
            RunningInstance instance = (RunningInstance)entry.getValue();
            try {
                this.logger.debug("<< allocating elastic IP instance(%s)", id);
                String ip = this.client.getElasticIPAddressApi().get().allocateAddressInRegion(id.getRegion());
                this.logger.debug(">> awaiting status running instance(%s)", id);
                AtomicReference<NodeMetadata> node = Atomics.newReference(this.runningInstanceToNodeMetadata.apply(instance));
                this.nodeRunning.apply(node);
                this.logger.trace("<< running instance(%s)", id);
                this.logger.debug(">> associating elastic IP %s to instance %s", ip, id);
                this.client.getElasticIPAddressApi().get().associateAddressInRegion(id.getRegion(), ip, id.getName());
                this.logger.trace("<< associated elastic IP %s to instance %s", ip, id);
                this.elasticIpCache.put(id, ip);
            }
            catch (RuntimeException e) {
                badNodes.put(this.runningInstanceToNodeMetadata.apply((RunningInstance)instancesById.get(id)), e);
            }
        }
    }

    private Set<RunningInstance> createKeyPairAndSecurityGroupsAsNeededThenRunInstances(String group, int count, Template template) {
        String region = AWSUtils.getRegionFromLocationOrNull(template.getLocation());
        String zone = EC2ComputeUtils.getZoneFromLocationOrNull(template.getLocation());
        RunInstancesOptions instanceOptions = this.createKeyPairAndSecurityGroupsAsNeededAndReturncustomize.execute(region, group, template);
        return this.createNodesInRegionAndZone(region, zone, group, count, template, instanceOptions);
    }

    protected Set<RunningInstance> createNodesInRegionAndZone(String region, String zone, String group, int count, Template template, RunInstancesOptions instanceOptions) {
        int countToProvision;
        int countStarted = 0;
        int tries = 0;
        ImmutableSet<RunningInstance> started = ImmutableSet.of();
        int maxCount = ((EC2TemplateOptions)EC2TemplateOptions.class.cast(template.getOptions())).getMaxCount();
        if (maxCount == 0) {
            maxCount = count;
            countToProvision = 1;
        } else {
            countToProvision = count;
        }
        while (countStarted < count && tries++ < count) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(">> running %d instance region(%s) zone(%s) ami(%s) params(%s)", count - countStarted, region, zone, template.getImage().getProviderId(), instanceOptions.buildFormParameters());
            }
            if ((countStarted = Iterables.size(started = ImmutableSet.copyOf(Iterables.concat(started, this.client.getInstanceApi().get().runInstancesInRegion(region, zone, template.getImage().getProviderId(), countToProvision, maxCount - countStarted, instanceOptions))))) >= count) continue;
            this.logger.debug(">> not enough instances (%d/%d) started, attempting again", countStarted, count);
        }
        return started;
    }
}

