/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.softlayer.domain.VirtualDiskImage;
import org.jclouds.softlayer.domain.VirtualGuest;

public class VirtualGuestBlockDevice {
    private final int id;
    private final String uuid;
    private final int statusId;
    private final String mountType;
    private final String mountMode;
    private final int bootableFlag;
    private final String device;
    private final VirtualDiskImage diskImage;
    private final VirtualGuest guest;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return VirtualGuestBlockDevice.builder().fromVirtualGuestBlockDevice(this);
    }

    @ConstructorProperties(value={"id", "uuid", "statusId", "mountType", "mountMode", "bootableFlag", "device", "diskImage", "guest"})
    protected VirtualGuestBlockDevice(int id, @Nullable String uuid, int statusId, @Nullable String mountType, @Nullable String mountMode, int bootableFlag, String device, @Nullable VirtualDiskImage diskImage, @Nullable VirtualGuest guest) {
        this.id = id;
        this.uuid = uuid;
        this.statusId = statusId;
        this.mountType = mountType;
        this.mountMode = mountMode;
        this.bootableFlag = bootableFlag;
        this.device = Preconditions.checkNotNull(device, "device");
        this.diskImage = diskImage;
        this.guest = guest;
    }

    public int getId() {
        return this.id;
    }

    public String getUuid() {
        return this.uuid;
    }

    public int getStatusId() {
        return this.statusId;
    }

    public String getMountType() {
        return this.mountType;
    }

    public String getMountMode() {
        return this.mountMode;
    }

    public int getBootableFlag() {
        return this.bootableFlag;
    }

    public String getDevice() {
        return this.device;
    }

    public VirtualDiskImage getVirtualDiskImage() {
        return this.diskImage;
    }

    public VirtualGuest getVirtualGuest() {
        return this.guest;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VirtualGuestBlockDevice that = (VirtualGuestBlockDevice)o;
        return Objects.equal(this.id, that.id) && Objects.equal(this.uuid, that.uuid) && Objects.equal(this.statusId, that.statusId) && Objects.equal(this.mountType, that.mountType) && Objects.equal(this.mountMode, that.mountMode) && Objects.equal(this.bootableFlag, that.bootableFlag) && Objects.equal(this.device, that.device) && Objects.equal(this.diskImage, that.diskImage) && Objects.equal(this.guest, that.guest);
    }

    public int hashCode() {
        return Objects.hashCode(this.id, this.uuid, this.statusId, this.mountType, this.mountMode, this.bootableFlag, this.device, this.diskImage, this.guest);
    }

    public String toString() {
        return Objects.toStringHelper(this).add("id", this.id).add("uuid", this.uuid).add("statusId", this.statusId).add("mountType", this.mountType).add("mountMode", this.mountMode).add("bootableFlag", this.bootableFlag).add("device", this.device).add("diskImage", this.diskImage).add("guest", this.guest).toString();
    }

    public static class Builder {
        protected int id;
        protected String uuid;
        protected int statusId;
        protected String mountType;
        protected String mountMode;
        protected int bootableFlag;
        protected String device;
        protected VirtualDiskImage diskImage;
        protected VirtualGuest guest;

        public Builder id(int id) {
            this.id = id;
            return this;
        }

        public Builder uuid(String uuid) {
            this.uuid = uuid;
            return this;
        }

        public Builder statusId(int statusId) {
            this.statusId = statusId;
            return this;
        }

        public Builder mountType(String mountType) {
            this.mountType = mountType;
            return this;
        }

        public Builder mountMode(String mountMode) {
            this.mountMode = mountMode;
            return this;
        }

        public Builder bootableFlag(int bootableFlag) {
            this.bootableFlag = bootableFlag;
            return this;
        }

        public Builder device(String device) {
            this.device = device;
            return this;
        }

        public Builder diskImage(VirtualDiskImage diskImage) {
            this.diskImage = diskImage;
            return this;
        }

        public Builder guest(VirtualGuest guest) {
            this.guest = guest;
            return this;
        }

        public VirtualGuestBlockDevice build() {
            return new VirtualGuestBlockDevice(this.id, this.uuid, this.statusId, this.mountType, this.mountMode, this.bootableFlag, this.device, this.diskImage, this.guest);
        }

        public Builder fromVirtualGuestBlockDevice(VirtualGuestBlockDevice in) {
            return this.id(in.getId()).uuid(in.getUuid()).statusId(in.getStatusId()).mountMode(in.getMountMode()).mountType(in.getMountType()).bootableFlag(in.getBootableFlag()).device(in.getDevice()).diskImage(in.getVirtualDiskImage()).guest(in.getVirtualGuest());
        }
    }
}

