/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.nio.worker.executors.util;

import es.bsc.compss.exceptions.InvokeExecutionException;
import es.bsc.compss.nio.NIOTask;
import es.bsc.compss.nio.exceptions.JobExecutionException;
import es.bsc.compss.nio.worker.NIOWorker;
import es.bsc.compss.nio.worker.executors.util.Invoker;
import es.bsc.compss.types.implementations.DecafImplementation;
import es.bsc.compss.worker.invokers.GenericInvoker;
import java.io.File;

public class DecafInvoker
extends Invoker {
    private static final String ERROR_DECAF_RUNNER = "ERROR: Invalid mpiRunner";
    private static final String ERROR_DECAF_BINARY = "ERROR: Invalid wfScript";
    private static final String ERROR_TARGET_PARAM = "ERROR: MPI Execution doesn't support target parameters";
    private final String mpiRunner;
    private String dfScript;
    private String dfExecutor;
    private String dfLib;

    public DecafInvoker(NIOWorker nw, NIOTask nt, File taskSandboxWorkingDir, int[] assignedCoreUnits) throws JobExecutionException {
        super(nw, nt, taskSandboxWorkingDir, assignedCoreUnits);
        DecafImplementation decafImpl = null;
        try {
            decafImpl = (DecafImplementation)this.impl;
        }
        catch (Exception e) {
            throw new JobExecutionException("Incorrect method definition for task of type " + (Object)((Object)this.methodType), e);
        }
        this.mpiRunner = decafImpl.getMpiRunner();
        this.dfScript = decafImpl.getDfScript();
        this.dfExecutor = decafImpl.getDfExecutor();
        this.dfLib = decafImpl.getDfLib();
    }

    @Override
    public Object invokeMethod() throws JobExecutionException {
        this.checkArguments();
        return this.invokeMPIMethod();
    }

    private void checkArguments() throws JobExecutionException {
        if (this.mpiRunner == null || this.mpiRunner.isEmpty()) {
            throw new JobExecutionException(ERROR_DECAF_RUNNER);
        }
        if (this.dfScript == null || this.dfScript.isEmpty()) {
            throw new JobExecutionException(ERROR_DECAF_BINARY);
        }
        if (!this.dfScript.startsWith(File.separator)) {
            this.dfScript = this.nw.getAppDir() + File.separator + this.dfScript;
        }
        if (this.dfExecutor == null || this.dfExecutor.isEmpty() || this.dfExecutor.equals("[unassigned]")) {
            this.dfExecutor = "executor.sh";
        }
        if (!this.dfExecutor.startsWith(File.separator) && !this.dfExecutor.startsWith("./")) {
            this.dfExecutor = "./" + this.dfExecutor;
        }
        if (this.dfLib == null || this.dfLib.isEmpty()) {
            this.dfLib = "null";
        }
        if (this.target.getValue() != null) {
            throw new JobExecutionException(ERROR_TARGET_PARAM);
        }
    }

    private Object invokeMPIMethod() throws JobExecutionException {
        LOGGER.info("Invoked " + this.dfScript + " in " + this.nw.getHostName());
        try {
            return GenericInvoker.invokeDecafMethod(this.nw.getInstallDir() + DecafImplementation.SCRIPT_PATH, this.dfScript, this.dfExecutor, this.dfLib, this.mpiRunner, this.values, this.streams, this.prefixes, this.taskSandboxWorkingDir);
        }
        catch (InvokeExecutionException iee) {
            throw new JobExecutionException(iee);
        }
    }
}

