/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.nio.worker.executors.util;

import es.bsc.compss.nio.NIOTask;
import es.bsc.compss.nio.NIOTracer;
import es.bsc.compss.nio.exceptions.JobExecutionException;
import es.bsc.compss.nio.worker.NIOWorker;
import es.bsc.compss.nio.worker.executors.util.Invoker;
import es.bsc.compss.types.implementations.MethodImplementation;
import es.bsc.compss.util.Tracer;
import java.io.File;
import java.lang.reflect.Method;
import java.util.concurrent.Semaphore;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.NotFoundException;
import javassist.bytecode.Descriptor;
import storage.CallbackEvent;
import storage.CallbackHandler;
import storage.StorageException;
import storage.StorageItf;
import storage.StubItf;

public class JavaInvoker
extends Invoker {
    private static final String ERROR_CLASS_REFLECTION = "Cannot get class by reflection";
    private static final String ERROR_METHOD_REFLECTION = "Cannot get method by reflection";
    private static final String ERROR_CLASS_NOT_FOUND = "ERROR: Target object class not found";
    private static final String ERROR_EXTERNAL_NO_PSCO = "ERROR: External ExecuteTask can only be used with target PSCOs";
    private static final String ERROR_STORAGE_CALL = "ERROR: External executeTask call failed";
    private static final String ERROR_CALLBACK_INTERRUPTED = "ERROR: External callback interrupted";
    private static final String ERROR_EXTERNAL_EXECUTION = "ERROR: External Task Execution failed";
    private static final String WARN_RET_VALUE_EXCEPTION = "WARN: Exception on externalExecution return value";
    private final String className;
    private final String methodName;
    private final Method method;

    public JavaInvoker(NIOWorker nw, NIOTask nt, File taskSandboxWorkingDir, int[] assignedCoreUnits) throws JobExecutionException {
        super(nw, nt, taskSandboxWorkingDir, assignedCoreUnits);
        MethodImplementation methodImpl = null;
        try {
            methodImpl = (MethodImplementation)this.impl;
        }
        catch (Exception e) {
            throw new JobExecutionException("Incorrect method definition for task of type " + (Object)((Object)this.methodType), e);
        }
        this.className = methodImpl.getDeclaringClass();
        this.methodName = methodImpl.getAlternativeMethodName();
        this.method = this.getMethod();
    }

    @Override
    public Object invokeMethod() throws JobExecutionException {
        return this.invokeJavaMethod();
    }

    private Method getMethod() throws JobExecutionException {
        Class<?> methodClass = null;
        Method method = null;
        try {
            methodClass = Class.forName(this.className);
        }
        catch (Exception e) {
            throw new JobExecutionException(ERROR_CLASS_REFLECTION, e);
        }
        try {
            method = methodClass.getMethod(this.methodName, this.types);
        }
        catch (Exception e) {
            throw new JobExecutionException(ERROR_METHOD_REFLECTION, e);
        }
        return method;
    }

    private Object invokeJavaMethod() throws JobExecutionException {
        Object retValue = null;
        retValue = NIOWorker.getExecutionType().equals("compss") ? this.internalExecution() : this.externalExecution();
        return retValue;
    }

    private Object internalExecution() throws JobExecutionException {
        Object retValue = null;
        if (NIOTracer.isActivated()) {
            NIOTracer.emitEvent(Tracer.Event.STORAGE_INVOKE.getId(), Tracer.Event.STORAGE_INVOKE.getType());
        }
        try {
            LOGGER.info("Invoked " + this.method.getName() + " of " + this.target + " in " + this.nw.getHostName());
            retValue = this.method.invoke(this.target.getValue(), this.values);
        }
        catch (Exception e) {
            throw new JobExecutionException("ERROR: Exception executing task (user code)", e);
        }
        finally {
            if (NIOTracer.isActivated()) {
                NIOTracer.emitEvent(0L, Tracer.Event.STORAGE_INVOKE.getType());
            }
        }
        return retValue;
    }

    private Object externalExecution() throws JobExecutionException {
        String descriptor;
        int n = this.method.getParameterAnnotations().length;
        ClassPool pool = ClassPool.getDefault();
        Class<?>[] cParams = this.method.getParameterTypes();
        CtClass[] ctParams = new CtClass[n];
        for (int i = 0; i < n; ++i) {
            try {
                ctParams[i] = pool.getCtClass(cParams[i].getName());
                continue;
            }
            catch (NotFoundException e) {
                throw new JobExecutionException("ERROR: Target object class not found " + cParams[i].getName(), e);
            }
        }
        try {
            descriptor = this.method.getName() + Descriptor.ofMethod(pool.getCtClass(this.method.getReturnType().getName()), ctParams);
        }
        catch (NotFoundException e) {
            throw new JobExecutionException("ERROR: Target object class not found " + this.method.getReturnType().getName(), e);
        }
        String id = null;
        try {
            id = ((StubItf)this.target.getValue()).getID();
        }
        catch (Exception e) {
            throw new JobExecutionException(ERROR_EXTERNAL_NO_PSCO, e);
        }
        if (id == null) {
            throw new JobExecutionException(ERROR_EXTERNAL_NO_PSCO);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.info("External ExecuteTask " + this.method.getName() + " with target PSCO Id " + id + " in " + this.nw.getHostName());
        } else {
            LOGGER.info("External ExecuteTask " + this.method.getName());
        }
        if (NIOTracer.isActivated()) {
            NIOTracer.emitEvent(Tracer.Event.STORAGE_EXECUTETASK.getId(), Tracer.Event.STORAGE_EXECUTETASK.getType());
        }
        PSCOCallbackHandler callback = new PSCOCallbackHandler();
        try {
            String call_result = StorageItf.executeTask(id, descriptor, this.values, this.nw.getHostName(), callback);
            LOGGER.debug(call_result);
            callback.waitForCompletion();
        }
        catch (StorageException e) {
            throw new JobExecutionException(ERROR_STORAGE_CALL, e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new JobExecutionException(ERROR_CALLBACK_INTERRUPTED, e);
        }
        finally {
            if (NIOTracer.isActivated()) {
                NIOTracer.emitEvent(0L, Tracer.Event.STORAGE_EXECUTETASK.getType());
            }
        }
        CallbackEvent.EventType callStatus = callback.getStatus();
        if (!callStatus.equals((Object)CallbackEvent.EventType.SUCCESS)) {
            throw new JobExecutionException(ERROR_EXTERNAL_EXECUTION);
        }
        Object retValue = null;
        if (this.method.getReturnType().getName().compareTo(Void.TYPE.getName()) != 0) {
            try {
                retValue = callback.getResult();
            }
            catch (StorageException e) {
                LOGGER.warn(WARN_RET_VALUE_EXCEPTION, (Throwable)e);
                retValue = null;
            }
        }
        return retValue;
    }

    private class PSCOCallbackHandler
    extends CallbackHandler {
        private CallbackEvent event;
        private Semaphore sem = new Semaphore(0);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void eventListener(CallbackEvent e) {
            this.event = e;
            Invoker.LOGGER.debug("Received event task finished with callback id " + this.event.getRequestID());
            PSCOCallbackHandler pSCOCallbackHandler = this;
            synchronized (pSCOCallbackHandler) {
                this.notifyAll();
            }
            this.sem.release();
        }

        public void waitForCompletion() throws InterruptedException {
            this.sem.acquire();
        }

        public CallbackEvent.EventType getStatus() {
            return this.event.getType();
        }

        public Object getResult() throws StorageException {
            return StorageItf.getResult(this.event);
        }
    }
}

