/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.nio.worker.util;

import es.bsc.compss.COMPSsConstants;
import es.bsc.compss.nio.worker.NIOWorker;
import es.bsc.compss.nio.worker.exceptions.InitializationException;
import es.bsc.compss.nio.worker.executors.CExecutor;
import es.bsc.compss.nio.worker.util.ExternalThreadPool;
import es.bsc.compss.util.ErrorManager;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CThreadPool
extends ExternalThreadPool {
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Worker.ThreadPool");
    private static final String C_PIPER = "c_piper.sh";
    private static final String PERSISTENT_WORKER_C = "/worker/persistent_worker_c";
    private static final String LOG_PREFIX = "[CThreadPool] ";
    public static final int MAX_RETRIES = 3;

    public CThreadPool(NIOWorker nw, int size) {
        super(nw, size);
    }

    @Override
    public void startThreads() throws InitializationException {
        LOGGER.info("[CThreadPool] Start threads for C-binding");
        int i = 0;
        for (Thread t : this.workerThreads) {
            CExecutor executor = new CExecutor(this.nw, this, this.queue, this.writePipeFiles[i], this.taskResultReader[i]);
            t = new Thread(executor);
            t.setName("JobsThreadPool pool thread # " + i);
            t.start();
            ++i;
        }
        this.sem.acquireUninterruptibly(this.size);
        LOGGER.debug("[CThreadPool] Finished C ThreadPool");
    }

    @Override
    public String getLaunchCommand() {
        int i;
        StringBuilder cmd = new StringBuilder();
        cmd.append((Object)COMPSsConstants.Lang.C).append(" ");
        if (!NIOWorker.isPersistentCEnabled()) {
            cmd.append(this.installDir).append(ExternalThreadPool.PIPER_SCRIPT_RELATIVE_PATH).append(C_PIPER).append(" ");
        } else if (this.nw.getAppDir() != null && !this.nw.getAppDir().isEmpty()) {
            String nx_args = "--enable-block";
            String compss_nx_args = System.getenv("COMPSS_NX_ARGS");
            if (compss_nx_args != null) {
                nx_args = nx_args.concat(" " + compss_nx_args);
            }
            if (LOGGER.isDebugEnabled()) {
                nx_args = nx_args.concat(" --summary --verbose");
            }
            cmd.append("NX_ARGS='" + nx_args + "' ").append(this.nw.getAppDir()).append(PERSISTENT_WORKER_C).append(" ");
            cmd.append(this.writeDataPipeFile).append(" ").append(this.readDataPipeFile).append(" ");
        } else {
            ErrorManager.warn("Appdir is not defined. It is mandatory for c/c++ binding");
            return null;
        }
        cmd.append(this.writePipeFiles.length).append(" ");
        for (i = 0; i < this.writePipeFiles.length; ++i) {
            cmd.append(this.writePipeFiles[i]).append(" ");
        }
        cmd.append(this.readPipeFiles.length).append(" ");
        for (i = 0; i < this.readPipeFiles.length; ++i) {
            cmd.append(this.readPipeFiles[i]).append(" ");
        }
        return cmd.toString();
    }

    @Override
    public Map<String, String> getEnvironment(NIOWorker nw) {
        return CExecutor.getEnvironment(nw);
    }

    @Override
    public void removeExternalData(String dataID) {
        String cmd = "remove " + dataID + "\n";
        boolean done = false;
        int retries = 0;
        while (!done && retries < 3) {
            LOGGER.debug("[CThreadPool] Trying to remove data " + dataID);
            try {
                FileOutputStream output = new FileOutputStream(this.writeDataPipeFile, true);
                Throwable throwable = null;
                try {
                    output.write(cmd.getBytes());
                    output.flush();
                    output.close();
                    done = true;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (output == null) continue;
                    if (throwable != null) {
                        try {
                            output.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    output.close();
                }
            }
            catch (Exception e) {
                LOGGER.warn("[CThreadPool] Error on writing on pipe " + this.writeDataPipeFile + ". Retrying " + retries + "/" + 3);
                ++retries;
            }
        }
        if (!done) {
            LOGGER.warn("ERROR: Data " + dataID + " has not been removed because cannot write in pipe");
        }
    }

    @Override
    protected void specificStop() {
        if (NIOWorker.isPersistentCEnabled()) {
            LOGGER.debug("[CThreadPool]  Sending Quit to data pipe");
            try (FileOutputStream output = new FileOutputStream(this.writeDataPipeFile, true);){
                String quitCMD = "quit\n";
                output.write(quitCMD.getBytes());
                output.flush();
                output.close();
            }
            catch (Exception e) {
                ErrorManager.error("[CThreadPool] Error on writing on pipe " + this.writeDataPipeFile, e);
            }
        }
        super.specificStop();
    }

    @Override
    public boolean serializeExternalData(String dataId, String path) {
        Throwable throwable;
        LOGGER.debug("[CThreadPool] Request to serialize " + dataId + " at " + path);
        String cmd = "serialize " + dataId + " " + path + "\n";
        boolean done = false;
        int retries = 0;
        while (!done && retries < 3) {
            try {
                FileOutputStream output = new FileOutputStream(this.writeDataPipeFile, true);
                throwable = null;
                try {
                    output.write(cmd.getBytes());
                    output.flush();
                    output.close();
                    done = true;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (output == null) continue;
                    if (throwable != null) {
                        try {
                            output.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    output.close();
                }
            }
            catch (Exception e) {
                LOGGER.warn("[CThreadPool] Error on writing on pipe " + this.writeDataPipeFile + ". Retrying " + retries + "/" + 3);
                ++retries;
            }
        }
        if (done) {
            try {
                throwable = null;
                try (FileInputStream input = new FileInputStream(this.readDataPipeFile);){
                    LOGGER.debug("[CThreadPool] Waiting for serialization results");
                    input.read();
                    input.close();
                    done = true;
                    LOGGER.debug("[CThreadPool] Data " + dataId + "serialized at " + path);
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
            }
            catch (Exception e) {
                LOGGER.warn("[CThreadPool] Error on writing on pipe " + this.writeDataPipeFile + ". Retrying " + retries + "/" + 3);
                done = false;
            }
        }
        if (!done) {
            LOGGER.warn("ERROR: Data " + dataId + " has not been serialized because cannot write in pipe");
            return false;
        }
        return true;
    }
}

