/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.nio.worker.util;

import es.bsc.compss.types.annotations.parameter.DataType;
import java.util.LinkedList;
import java.util.List;

public class ExternalTaskStatus {
    private final Integer exitValue;
    private final List<DataType> updatedParameterTypes;
    private final List<String> updatedParameterValues;

    public ExternalTaskStatus(Integer exitValue) {
        this.exitValue = exitValue;
        this.updatedParameterTypes = new LinkedList<DataType>();
        this.updatedParameterValues = new LinkedList<String>();
    }

    public Integer getExitValue() {
        return this.exitValue;
    }

    public int getNumParameters() {
        return this.updatedParameterValues.size();
    }

    public List<DataType> getParameterTypes() {
        return this.updatedParameterTypes;
    }

    public List<String> getParameterValues() {
        return this.updatedParameterValues;
    }

    public DataType getParameterType(int i) {
        if (i >= 0 && i < this.updatedParameterTypes.size()) {
            return this.updatedParameterTypes.get(i);
        }
        return null;
    }

    public String getParameterValue(int i) {
        if (i >= 0 && i < this.updatedParameterValues.size()) {
            return this.updatedParameterValues.get(i);
        }
        return null;
    }

    public void addParameter(DataType type, String value) {
        this.updatedParameterTypes.add(type);
        this.updatedParameterValues.add(value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ExternalTaskStatus [ ");
        sb.append("ExitValue = ").append(this.exitValue).append(", ");
        sb.append("NumParameters = ").append(this.getNumParameters()).append(", ");
        sb.append("ParameterTypes = [");
        for (DataType type : this.updatedParameterTypes) {
            sb.append(type.ordinal()).append(" ");
        }
        sb.append("], ");
        sb.append("ParameterValues = [");
        for (String value : this.updatedParameterValues) {
            sb.append(value).append(" ");
        }
        sb.append("]");
        sb.append(" ]");
        return sb.toString();
    }
}

