/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.implementations;

import es.bsc.compss.types.resources.WorkerResourceDescription;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public abstract class Implementation
implements Externalizable {
    protected Integer coreId;
    protected Integer implementationId;
    protected WorkerResourceDescription requirements;

    public Implementation() {
    }

    public Implementation(Integer coreId, Integer implementationId, WorkerResourceDescription annot) {
        this.coreId = coreId;
        this.implementationId = implementationId;
        this.requirements = annot;
    }

    public Integer getCoreId() {
        return this.coreId;
    }

    public Integer getImplementationId() {
        return this.implementationId;
    }

    public WorkerResourceDescription getRequirements() {
        return this.requirements;
    }

    public abstract TaskType getTaskType();

    public String toString() {
        StringBuilder sb = new StringBuilder("Implementation ").append(this.implementationId);
        sb.append(" for core ").append(this.coreId);
        sb.append(":");
        return sb.toString();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.coreId = (Integer)in.readObject();
        this.implementationId = (Integer)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.coreId);
        out.writeObject(this.implementationId);
    }

    public static enum TaskType {
        METHOD,
        SERVICE;

    }
}

