/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.functions;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.cache.CacheLoader;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.aws.AWSResponseException;
import org.jclouds.aws.ec2.AWSEC2Api;
import org.jclouds.aws.ec2.domain.PlacementGroup;
import org.jclouds.ec2.compute.domain.RegionAndName;
import org.jclouds.logging.Logger;

@Singleton
public class CreatePlacementGroupIfNeeded
extends CacheLoader<RegionAndName, String> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    protected final AWSEC2Api ec2Api;
    protected final Predicate<PlacementGroup> placementGroupAvailable;

    @Inject
    public CreatePlacementGroupIfNeeded(AWSEC2Api ec2Api, @Named(value="AVAILABLE") Predicate<PlacementGroup> placementGroupAvailable) {
        this.ec2Api = ec2Api;
        this.placementGroupAvailable = placementGroupAvailable;
    }

    @Override
    public String load(RegionAndName from) {
        this.createPlacementGroupInRegion(from.getRegion(), from.getName());
        return from.getName();
    }

    private void createPlacementGroupInRegion(String region, String name) {
        Preconditions.checkNotNull(region, "region");
        Preconditions.checkNotNull(name, "name");
        this.logger.debug(">> creating placementGroup region(%s) name(%s)", region, name);
        try {
            this.ec2Api.getPlacementGroupApi().get().createPlacementGroupInRegion(region, name);
            this.logger.debug("<< created placementGroup(%s)", name);
            Preconditions.checkState(this.placementGroupAvailable.apply(new PlacementGroup(region, name, "cluster", PlacementGroup.State.PENDING)), String.format("placementGroup region(%s) name(%s) failed to become available", region, name));
        }
        catch (AWSResponseException e) {
            if (e.getError().getCode().equals("InvalidPlacementGroup.Duplicate")) {
                this.logger.debug("<< reused placementGroup(%s)", name);
            }
            throw e;
        }
    }
}

