from distutils.core import setup, Extension
#from setuptools import setup, Extension
from distutils.command.install_lib import install_lib
from distutils import log
import os

compssmodule = Extension('compss',
        include_dirs = [
            '../bindings-common/src',
		    '../bindings-common/include'
		],
        library_dirs = [
		    '../bindings-common/lib'
		],
        libraries = ['bindings_common'],
        extra_compile_args = ['-fPIC'],
        sources = ['src/ext/compssmodule.c'])

thread_affinity = Extension('thread_affinity',
	include_dirs = ['src/ext'],
	sources = ['src/ext/thread_affinity.cc']
)

setup (name='pycompss',
	version='2.2.rc1710',
	description='Python Binding for COMP Superscalar Runtime',
	long_description=open('README.txt').read(),
	author='COMPSs Team',
	author_email='support-compss@bsc.es',
	url='http://compss.bsc.es',
	license='Apache 2.0',
    package_dir={'pycompss':'src/pycompss'},
	packages=['', 'pycompss', 'pycompss.api', 'pycompss.runtime', 'pycompss.worker', 'pycompss.util', 'pycompss.util.serialization', 'pycompss.api.dummy', 'pycompss.functions', 'pycompss.matlib', 'pycompss.matlib.algebra', 'pycompss.matlib.classification', 'pycompss.matlib.clustering'],
	package_data={'' : ['log/logging.json', 'log/logging.json.debug', 'log/logging.json.off', 'bin/worker_python.sh']},
	ext_modules=[compssmodule, thread_affinity])

    # Only available with setuptools
	#entry_points={'console_scripts':['pycompss = pycompss.__main__:main']})
