/*
 * Decompiled with CFR 0.152.
 */
package com.trilead.ssh2.auth;

import com.google.code.juds.UnixDomainSocketClient;
import com.trilead.ssh2.auth.NoAgentException;
import com.trilead.ssh2.packets.PacketAgentIdentitiesAnswer;
import com.trilead.ssh2.packets.PacketAgentRequestIdentities;
import com.trilead.ssh2.packets.PacketAgentSignRequest;
import com.trilead.ssh2.packets.PacketAgentSignResponse;
import com.trilead.ssh2.packets.TypesWriter;
import com.trilead.ssh2.signature.DSAPublicKey;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class SshAgentClient {
    private final UnixDomainSocketClient socket;
    private final DataInputStream in;
    private final DataOutputStream out;
    private final byte[][] blobs;
    private final Object[] keys;

    public SshAgentClient() throws NoAgentException {
        PacketAgentIdentitiesAnswer answer;
        String socketName = System.getenv("SSH_AUTH_SOCK");
        if (socketName == null) {
            throw new NoAgentException("No environment variable SSH_AUTH_SOCK");
        }
        try {
            this.socket = new UnixDomainSocketClient(socketName, 1);
        }
        catch (Throwable e) {
            throw new NoAgentException("Connect to " + socketName + " failed", e);
        }
        this.in = new DataInputStream(this.socket.getInputStream());
        this.out = new DataOutputStream(this.socket.getOutputStream());
        PacketAgentRequestIdentities request = new PacketAgentRequestIdentities();
        byte[] payload = request.getPayload();
        try {
            this.out.writeInt(payload.length);
            this.out.write(payload);
            this.out.flush();
        }
        catch (IOException e) {
            try {
                this.socket.close();
            }
            catch (Throwable e1) {
                // empty catch block
            }
            throw new NoAgentException("Write failed", e);
        }
        try {
            int len = this.in.readInt();
            payload = new byte[len];
            this.in.readFully(payload);
            answer = new PacketAgentIdentitiesAnswer(payload, 0, payload.length);
        }
        catch (IOException e) {
            try {
                this.socket.close();
            }
            catch (Throwable e1) {
                // empty catch block
            }
            throw new NoAgentException("Read failed", e);
        }
        this.blobs = answer.getBlobs();
        this.keys = answer.getKeys();
    }

    public byte[] getBlob(int keyId) {
        TypesWriter tw = new TypesWriter();
        if (this.keys[keyId] instanceof DSAPublicKey) {
            tw.writeString("ssh-dss");
        } else {
            tw.writeString("ssh-rsa");
        }
        tw.writeString(this.blobs[keyId], 0, this.blobs[keyId].length);
        return tw.getBytes();
    }

    public String getType(int keyId) {
        if (this.keys[keyId] instanceof DSAPublicKey) {
            return "ssh-dss";
        }
        return "ssh-rsa";
    }

    public int getNumKeys() {
        return this.blobs.length;
    }

    public byte[] generateSignature(byte[] msg, int keyId) throws IOException {
        PacketAgentSignRequest request = new PacketAgentSignRequest(msg, this.blobs[keyId]);
        byte[] payload = request.getPayload();
        this.out.writeInt(payload.length);
        this.out.write(payload);
        this.out.flush();
        int len = this.in.readInt();
        payload = new byte[len];
        this.in.readFully(payload);
        PacketAgentSignResponse answer = new PacketAgentSignResponse(payload, 0, payload.length);
        return answer.getContents();
    }

    public String getKey(int i) {
        return this.keys[i].toString();
    }

    public void close() {
        try {
            this.socket.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

