/*
 * Decompiled with CFR 0.152.
 */
package org.gridlab.gat.io.cpi.sftpTrilead;

import java.io.File;
import org.gridlab.gat.CouldNotInitializeCredentialException;
import org.gridlab.gat.CredentialExpiredException;
import org.gridlab.gat.GATContext;
import org.gridlab.gat.InvalidUsernameOrPasswordException;
import org.gridlab.gat.URI;
import org.gridlab.gat.io.cpi.sftpTrilead.SftpTrileadSecurityUtils;
import org.gridlab.gat.io.cpi.sftpTrilead.SftpTrileadUserInfo;
import org.gridlab.gat.security.CertificateSecurityContext;
import org.gridlab.gat.security.CredentialSecurityContext;
import org.gridlab.gat.security.PasswordSecurityContext;
import org.gridlab.gat.security.SecurityContext;
import org.gridlab.gat.security.cpi.SecurityContextCreator;
import org.gridlab.gat.security.cpi.SecurityContextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SftpTrileadContextCreator
implements SecurityContextCreator {
    protected static Logger logger = LoggerFactory.getLogger(SftpTrileadContextCreator.class);

    SftpTrileadContextCreator() {
    }

    public SecurityContext createDefaultSecurityContext(GATContext gatContext, URI location) throws CouldNotInitializeCredentialException, CredentialExpiredException, InvalidUsernameOrPasswordException {
        SftpTrileadUserInfo cred = SftpTrileadSecurityUtils.getDefaultUserInfo(gatContext, location);
        CredentialSecurityContext c = new CredentialSecurityContext();
        c.putDataObject("sftpTrilead", (Object)cred);
        return c;
    }

    public Object createUserData(GATContext gatContext, URI location, SecurityContext inContext) throws CouldNotInitializeCredentialException, CredentialExpiredException, InvalidUsernameOrPasswordException {
        SftpTrileadUserInfo info = new SftpTrileadUserInfo();
        if (inContext instanceof CredentialSecurityContext) {
            return inContext.getDataObject("sshtrilead");
        }
        if (inContext instanceof CertificateSecurityContext) {
            CertificateSecurityContext c = (CertificateSecurityContext)inContext;
            info.username = c.getUsername() != null ? c.getUsername() : SecurityContextUtils.getUser((GATContext)gatContext, (SecurityContext)inContext, (URI)location);
            if (c.getPassword() != null) {
                info.password = c.getPassword();
            }
            info.privateKey = c.getKeyfile() != null && c.getKeyfile().isCompatible("file") && c.getKeyfile().refersToLocalHost() ? new File(c.getKeyfile().getPath()) : SftpTrileadSecurityUtils.getDefaultPrivateKey();
            return info;
        }
        if (inContext instanceof PasswordSecurityContext) {
            PasswordSecurityContext c = (PasswordSecurityContext)inContext;
            info.username = c.getUsername() != null ? c.getUsername() : SecurityContextUtils.getUser((GATContext)gatContext, (SecurityContext)inContext, (URI)location);
            if (c.getPassword() != null) {
                info.password = c.getPassword();
            }
            return info;
        }
        return null;
    }
}

