/*
 * Decompiled with CFR 0.152.
 */
package org.gridlab.gat.resources.cpi;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gridlab.gat.GAT;
import org.gridlab.gat.GATContext;
import org.gridlab.gat.GATInvocationException;
import org.gridlab.gat.URI;
import org.gridlab.gat.io.File;
import org.gridlab.gat.resources.JobDescription;
import org.gridlab.gat.resources.SoftwareDescription;
import org.gridlab.gat.resources.cpi.PostStagedFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostStagedFileSet {
    protected static Logger logger = LoggerFactory.getLogger(PostStagedFileSet.class);
    private GATContext gatContext;
    private JobDescription description;
    private String authority;
    private String sandbox;
    private boolean postStageStdout;
    private boolean postStageStderr;
    private PostStagedFile[] files = new PostStagedFile[0];

    public PostStagedFileSet() {
    }

    public PostStagedFileSet(GATContext gatContext, JobDescription description, String authority, String sandbox, boolean postStageStdout, boolean postStageStderr) throws GATInvocationException {
        this.gatContext = gatContext;
        this.description = description;
        this.authority = authority;
        this.sandbox = sandbox;
        this.postStageStdout = postStageStdout;
        this.postStageStderr = postStageStderr;
        this.resolve();
        if (logger.isInfoEnabled()) {
            logger.info(this.toString());
        }
    }

    public PostStagedFileSet(GATContext gatContext, List<File> files, String authority, String sandbox) throws GATInvocationException {
        this.gatContext = gatContext;
        this.authority = authority;
        this.sandbox = sandbox;
        this.resolveFiles(files);
    }

    private void resolve() throws GATInvocationException {
        SoftwareDescription sd = this.description.getSoftwareDescription();
        if (sd == null) {
            throw new GATInvocationException("The job description does not contain a software description");
        }
        Map post = sd.getPostStaged();
        ArrayList<PostStagedFile> tmp = new ArrayList<PostStagedFile>();
        if (post != null) {
            Set keys = post.keySet();
            for (File srcFile : keys) {
                File destFile = (File)post.get(srcFile);
                tmp.add(new PostStagedFile(this.gatContext, srcFile, destFile, this.authority, this.sandbox, false, false));
            }
        }
        File resolvedStdout = null;
        if (sd.getStdout() != null) {
            try {
                resolvedStdout = GAT.createFile((GATContext)sd.getStdout().getFileInterface().getGATContext(), (URI)new URI("any:///" + sd.getStdout().getName()));
            }
            catch (Exception e) {
                throw new GATInvocationException("postStagedFileSet", (Throwable)e);
            }
        }
        if (resolvedStdout != null) {
            tmp.add(new PostStagedFile(this.gatContext, resolvedStdout, sd.getStdout(), this.authority, this.sandbox, true, false));
        }
        File resolvedStderr = null;
        if (sd.getStderr() != null) {
            try {
                resolvedStderr = GAT.createFile((GATContext)sd.getStderr().getFileInterface().getGATContext(), (URI)new URI("any:///" + sd.getStderr().getName()));
            }
            catch (Exception e) {
                throw new GATInvocationException("postStagedFileSet", (Throwable)e);
            }
        }
        if (resolvedStderr != null) {
            tmp.add(new PostStagedFile(this.gatContext, resolvedStderr, sd.getStderr(), this.authority, this.sandbox, false, true));
        }
        this.files = tmp.toArray(new PostStagedFile[0]);
    }

    private void resolveFiles(List<File> f) throws GATInvocationException {
        if (f == null) {
            return;
        }
        int startPos = 0;
        if (this.files == null) {
            this.files = new PostStagedFile[f.size()];
        } else {
            PostStagedFile[] tmp = new PostStagedFile[this.files.length + f.size()];
            for (int i = 0; i < this.files.length; ++i) {
                tmp[i] = this.files[i];
            }
            startPos = this.files.length;
            this.files = tmp;
        }
        for (int i = 0; i < f.size(); ++i) {
            File srcFile = f.get(i);
            this.files[startPos + i] = new PostStagedFile(this.gatContext, srcFile, null, this.authority, this.sandbox, false, false);
        }
    }

    protected void poststage() throws GATInvocationException {
        GATInvocationException exceptions = new GATInvocationException();
        for (int i = 0; i < this.files.length; ++i) {
            try {
                if (this.files[i].isStdout() && !this.postStageStdout || this.files[i].isStderr() && !this.postStageStderr) continue;
                this.files[i].poststage();
                continue;
            }
            catch (Throwable e) {
                exceptions.add("resource broker cpi", e);
            }
        }
        if (exceptions.getNrChildren() != 0) {
            throw exceptions;
        }
    }

    public void delete() throws GATInvocationException {
        GATInvocationException e = new GATInvocationException();
        for (int i = 0; i < this.files.length; ++i) {
            try {
                this.files[i].delete();
                continue;
            }
            catch (Exception x) {
                e.add("resource broker", (Throwable)x);
            }
        }
        if (e.getNrChildren() != 0) {
            throw e;
        }
    }

    public void wipe() throws GATInvocationException {
        GATInvocationException e = new GATInvocationException();
        for (int i = 0; i < this.files.length; ++i) {
            try {
                this.files[i].wipe();
                continue;
            }
            catch (Exception x) {
                e.add("resource broker", (Throwable)x);
            }
        }
        if (e.getNrChildren() != 0) {
            throw e;
        }
    }

    PostStagedFile getStdout() {
        for (int i = 0; i < this.files.length; ++i) {
            if (!this.files[i].isStdout()) continue;
            return this.files[i];
        }
        return null;
    }

    PostStagedFile getStderr() {
        for (int i = 0; i < this.files.length; ++i) {
            if (!this.files[i].isStderr()) continue;
            return this.files[i];
        }
        return null;
    }

    public int size() {
        return this.files.length;
    }

    public PostStagedFile getFile(int i) {
        return this.files[i];
    }

    public String toString() {
        String res = "";
        res = res + "PostStagedFileSet:\n";
        for (int i = 0; i < this.files.length; ++i) {
            res = res + this.files[i] + "\n";
        }
        return res;
    }

    public PostStagedFile[] getFiles() {
        return this.files;
    }

    public void setFiles(PostStagedFile[] files) {
        this.files = files;
    }

    public boolean isPostStageStderr() {
        return this.postStageStderr;
    }

    public void setPostStageStderr(boolean postStageStderr) {
        this.postStageStderr = postStageStderr;
    }

    public boolean isPostStageStdout() {
        return this.postStageStdout;
    }

    public void setPostStageStdout(boolean postStageStdout) {
        this.postStageStdout = postStageStdout;
    }

    void setGatContext(GATContext gatContext) {
        this.gatContext = gatContext;
        for (PostStagedFile file : this.files) {
            file.setGatContext(gatContext);
        }
    }
}

