/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.mapping.loader;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import org.exolab.castor.mapping.ClassDescriptor;
import org.exolab.castor.mapping.CollectionHandler;
import org.exolab.castor.mapping.ExtendedFieldHandler;
import org.exolab.castor.mapping.FieldDescriptor;
import org.exolab.castor.mapping.FieldHandler;
import org.exolab.castor.mapping.GeneralizedFieldHandler;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.mapping.handlers.EnumFieldHandler;
import org.exolab.castor.mapping.handlers.TransientFieldHandler;
import org.exolab.castor.mapping.loader.AbstractFieldDescriptor;
import org.exolab.castor.mapping.loader.AbstractMappingLoader2;
import org.exolab.castor.mapping.loader.CollectionHandlers;
import org.exolab.castor.mapping.loader.FieldDescriptorImpl;
import org.exolab.castor.mapping.loader.FieldHandlerFriend;
import org.exolab.castor.mapping.loader.FieldHandlerImpl;
import org.exolab.castor.mapping.loader.TypeInfo;
import org.exolab.castor.mapping.loader.Types;
import org.exolab.castor.mapping.xml.ClassChoice;
import org.exolab.castor.mapping.xml.ClassMapping;
import org.exolab.castor.mapping.xml.FieldMapping;
import org.exolab.castor.mapping.xml.MappingRoot;

public abstract class AbstractMappingLoader
extends AbstractMappingLoader2 {
    private static final String ADD_METHOD_PREFIX = "add";
    private static final String ENUM_METHOD_PREFIX = "enum";
    private static final String ITER_METHOD_PREFIX = "iterate";
    private static final String GET_METHOD_PREFIX = "get";
    private static final String IS_METHOD_PREFIX = "is";
    private static final String SET_METHOD_PREFIX = "set";
    private static final String CREATE_METHOD_PREFIX = "create";
    private static final String HAS_METHOD_PREFIX = "has";
    private static final String DELETE_METHOD_PREFIX = "delete";
    protected static final Class[] EMPTY_ARGS = new Class[0];
    protected static final Class[] STRING_ARG = new Class[]{class$java$lang$String == null ? (class$java$lang$String = AbstractMappingLoader.class$("java.lang.String")) : class$java$lang$String};
    protected static final String VALUE_OF = "valueOf";
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$exolab$castor$mapping$FieldHandler;
    static /* synthetic */ Class array$Ljava$lang$Object;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$util$Enumeration;
    static /* synthetic */ Class class$java$util$Iterator;
    static /* synthetic */ Class class$java$io$Serializable;
    static /* synthetic */ Class class$org$exolab$castor$mapping$MapItem;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Number;

    protected AbstractMappingLoader(ClassLoader loader) {
        super(loader);
    }

    public final String getSourceType() {
        return "CastorXmlMapping";
    }

    public abstract void loadMapping(MappingRoot var1, Object var2) throws MappingException;

    protected final void createClassDescriptors(MappingRoot mapping) throws MappingException {
        Enumeration enumeration = mapping.enumerateClassMapping();
        ArrayList<ClassMapping> retryList = new ArrayList<ClassMapping>();
        while (enumeration.hasMoreElements()) {
            ClassMapping clsMap = (ClassMapping)enumeration.nextElement();
            try {
                ClassDescriptor clsDesc = this.createClassDescriptor(clsMap);
                if (clsDesc == null) continue;
                this.addDescriptor(clsDesc);
            }
            catch (MappingException mx) {
                retryList.add(clsMap);
            }
        }
        Iterator i = retryList.iterator();
        while (i.hasNext()) {
            ClassMapping clsMap = (ClassMapping)i.next();
            ClassDescriptor clsDesc = this.createClassDescriptor(clsMap);
            if (clsDesc == null) continue;
            this.addDescriptor(clsDesc);
        }
        i = this.descriptorIterator();
        while (i.hasNext()) {
            this.resolveRelations((ClassDescriptor)i.next());
        }
    }

    protected abstract ClassDescriptor createClassDescriptor(ClassMapping var1) throws MappingException;

    protected final ClassDescriptor getExtended(ClassMapping clsMap, Class javaClass) throws MappingException {
        if (clsMap.getExtends() == null) {
            return null;
        }
        ClassMapping mapping = (ClassMapping)clsMap.getExtends();
        Class type = this.resolveType(mapping.getName());
        ClassDescriptor result = this.getDescriptor(type.getName());
        if (result == null) {
            throw new MappingException("mapping.extendsMissing", mapping, javaClass.getName());
        }
        if (!result.getJavaClass().isAssignableFrom(javaClass)) {
            throw new MappingException("mapping.classDoesNotExtend", javaClass.getName(), result.getJavaClass().getName());
        }
        return result;
    }

    protected final ClassDescriptor getDepended(ClassMapping clsMap, Class javaClass) throws MappingException {
        if (clsMap.getDepends() == null) {
            return null;
        }
        ClassMapping mapping = (ClassMapping)clsMap.getDepends();
        Class type = this.resolveType(mapping.getName());
        ClassDescriptor result = this.getDescriptor(type.getName());
        if (result == null) {
            throw new MappingException("Depends not found: " + mapping + " " + javaClass.getName());
        }
        return result;
    }

    protected final void checkFieldNameDuplicates(FieldDescriptor[] fields, Class cls) throws MappingException {
        for (int i = 0; i < fields.length - 1; ++i) {
            String fieldName = fields[i].getFieldName();
            for (int j = i + 1; j < fields.length; ++j) {
                if (!fieldName.equals(fields[j].getFieldName())) continue;
                throw new MappingException("The field " + fieldName + " appears twice in the descriptor for " + cls.getName());
            }
        }
    }

    protected abstract void resolveRelations(ClassDescriptor var1);

    protected final Class resolveType(String typeName) throws MappingException {
        try {
            return Types.typeFromName(this.getClassLoader(), typeName);
        }
        catch (ClassNotFoundException ex) {
            throw new MappingException("mapping.classNotFound", typeName);
        }
    }

    protected final AbstractFieldDescriptor[] createFieldDescriptors(ClassMapping clsMap, Class javaClass) throws MappingException {
        FieldMapping[] fldMap = null;
        if (clsMap.getClassChoice() != null) {
            fldMap = clsMap.getClassChoice().getFieldMapping();
        }
        if (fldMap == null || fldMap.length == 0) {
            return new AbstractFieldDescriptor[0];
        }
        AbstractFieldDescriptor[] fields = new AbstractFieldDescriptor[fldMap.length];
        for (int i = 0; i < fldMap.length; ++i) {
            fields[i] = this.createFieldDesc(javaClass, fldMap[i]);
            fields[i].setIdentity(fldMap[i].getIdentity());
        }
        return fields;
    }

    protected final ClassMapping getOrigin(ClassMapping clsMap) {
        ClassMapping result = clsMap;
        while (result.getExtends() != null) {
            result = (ClassMapping)result.getExtends();
        }
        return result;
    }

    protected final FieldDescriptor[] divideFieldDescriptors(FieldDescriptor[] fields, String[] ids, FieldDescriptor[] identities) {
        ArrayList<FieldDescriptor> fieldList = new ArrayList<FieldDescriptor>(fields.length);
        for (int i = 0; i < fields.length; ++i) {
            FieldDescriptor field = fields[i];
            int index = this.getIdColumnIndex(field, ids);
            if (index == -1) {
                fieldList.add(field);
                continue;
            }
            if (field instanceof FieldDescriptorImpl) {
                ((FieldDescriptorImpl)field).setRequired(true);
            }
            if (field.getHandler() instanceof FieldHandlerImpl) {
                ((FieldHandlerImpl)field.getHandler()).setRequired(true);
            }
            identities[index] = field;
        }
        FieldDescriptor[] result = new FieldDescriptor[fieldList.size()];
        return fieldList.toArray(result);
    }

    protected int getIdColumnIndex(FieldDescriptor field, String[] ids) {
        for (int i = 0; i < ids.length; ++i) {
            if (!field.getFieldName().equals(ids[i])) continue;
            return i;
        }
        return -1;
    }

    protected AbstractFieldDescriptor createFieldDesc(Class javaClass, FieldMapping fieldMap) throws MappingException {
        boolean generalized;
        String fieldName = fieldMap.getName();
        Class fieldType = null;
        if (fieldMap.getType() != null) {
            fieldType = this.resolveType(fieldMap.getType());
        }
        CollectionHandler colHandler = null;
        if (fieldMap.getCollection() != null) {
            String colTypeName = fieldMap.getCollection().toString();
            Class colType = CollectionHandlers.getCollectionType(colTypeName);
            colHandler = CollectionHandlers.getHandler(colType);
        }
        TypeInfo typeInfo = this.getTypeInfo(fieldType, colHandler, fieldMap);
        FieldHandlerFriend exfHandler = null;
        FieldHandler handler = null;
        if (fieldMap.getHandler() != null) {
            Class handlerClass = null;
            if (!(class$org$exolab$castor$mapping$FieldHandler == null ? (class$org$exolab$castor$mapping$FieldHandler = AbstractMappingLoader.class$("org.exolab.castor.mapping.FieldHandler")) : class$org$exolab$castor$mapping$FieldHandler).isAssignableFrom(handlerClass = this.resolveType(fieldMap.getHandler()))) {
                String err = "The class '" + fieldMap.getHandler() + "' must implement " + (class$org$exolab$castor$mapping$FieldHandler == null ? (class$org$exolab$castor$mapping$FieldHandler = AbstractMappingLoader.class$("org.exolab.castor.mapping.FieldHandler")) : class$org$exolab$castor$mapping$FieldHandler).getName();
                throw new MappingException(err);
            }
            try {
                Constructor constructor = handlerClass.getConstructor(new Class[0]);
                handler = (FieldHandler)constructor.newInstance(new Object[0]);
            }
            catch (Exception ex) {
                String err = "The class '" + handlerClass.getName() + "' must have a default public constructor.";
                throw new MappingException(err);
            }
            if (handler instanceof ExtendedFieldHandler) {
                exfHandler = (ExtendedFieldHandler)handler;
            }
            colHandler = typeInfo.getCollectionHandler();
            typeInfo.setCollectionHandler(null);
            handler = new FieldHandlerImpl(handler, typeInfo);
            typeInfo.setCollectionHandler(colHandler);
        }
        if (generalized = exfHandler instanceof GeneralizedFieldHandler) {
            fieldType = ((GeneralizedFieldHandler)exfHandler).getFieldType();
        }
        if (generalized || handler == null) {
            FieldHandler custom = handler;
            TypeInfoReference typeInfoRef = new TypeInfoReference();
            typeInfoRef.typeInfo = typeInfo;
            handler = this.createFieldHandler(javaClass, fieldType, fieldMap, typeInfoRef);
            if (custom != null) {
                ((GeneralizedFieldHandler)exfHandler).setFieldHandler(handler);
                handler = custom;
            } else {
                Method method;
                boolean isTypeSafeEnum = false;
                if (fieldType != null && !AbstractMappingLoader.isPrimitive(fieldType) && !this.hasPublicDefaultConstructor(fieldType) && (method = this.getStaticValueOfMethod(fieldType)) != null) {
                    handler = new EnumFieldHandler(fieldType, handler, method);
                    typeInfo.setImmutable(true);
                    isTypeSafeEnum = true;
                }
                if (!isTypeSafeEnum) {
                    typeInfo = typeInfoRef.typeInfo;
                }
            }
        }
        FieldDescriptorImpl fieldDesc = new FieldDescriptorImpl(fieldName, typeInfo, handler, fieldMap.getTransient());
        fieldDesc.setRequired(fieldMap.getRequired());
        if (exfHandler != null) {
            exfHandler.setFieldDescriptor(fieldDesc);
        }
        return fieldDesc;
    }

    private boolean hasPublicDefaultConstructor(Class type) {
        try {
            Constructor cons = type.getConstructor(EMPTY_ARGS);
            return Modifier.isPublic(cons.getModifiers());
        }
        catch (NoSuchMethodException ex) {
            return false;
        }
    }

    private Method getStaticValueOfMethod(Class type) {
        try {
            Method method = type.getMethod(VALUE_OF, STRING_ARG);
            Class<?> returnType = method.getReturnType();
            if (returnType == null) {
                return null;
            }
            if (!type.isAssignableFrom(returnType)) {
                return null;
            }
            if (!Modifier.isStatic(method.getModifiers())) {
                return null;
            }
            return method;
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
    }

    protected final FieldHandler createFieldHandler(Class javaClass, Class fldType, FieldMapping fldMap, TypeInfoReference typeInfoRef) throws MappingException {
        Method method;
        if (fldMap.getTransient()) {
            return new TransientFieldHandler();
        }
        Class colType = null;
        CollectionHandler colHandler = null;
        boolean colRequireGetSet = true;
        String fieldName = fldMap.getName();
        if (fldMap.getCollection() != null) {
            String colTypeName = fldMap.getCollection().toString();
            colType = CollectionHandlers.getCollectionType(colTypeName);
            colHandler = CollectionHandlers.getHandler(colType);
            colRequireGetSet = CollectionHandlers.isGetSetCollection(colType);
            if (colType == (array$Ljava$lang$Object == null ? (array$Ljava$lang$Object = AbstractMappingLoader.class$("[Ljava.lang.Object;")) : array$Ljava$lang$Object)) {
                if (fldType == null) {
                    String msg = "'type' is a required attribute for field that are array collections: " + fieldName;
                    throw new MappingException(msg);
                }
                Object obj = Array.newInstance(fldType, 0);
                colType = obj.getClass();
            }
        }
        FieldHandlerImpl handler = null;
        if (fldMap.getDirect()) {
            Field field = this.findField(javaClass, fieldName, colType == null ? fldType : colType);
            if (field == null) {
                throw new MappingException("mapping.fieldNotAccessible", fieldName, javaClass.getName());
            }
            if (fldType == null) {
                fldType = field.getType();
            }
            typeInfoRef.typeInfo = this.getTypeInfo(fldType, colHandler, fldMap);
            handler = new FieldHandlerImpl(field, typeInfoRef.typeInfo);
        } else if (fldMap.getGetMethod() == null && fldMap.getSetMethod() == null) {
            String methodName;
            if (fieldName == null) {
                throw new MappingException("mapping.missingFieldName", javaClass.getName());
            }
            ArrayList<Method> getSequence = new ArrayList<Method>();
            ArrayList<Method> setSequence = new ArrayList<Method>();
            Method getMethod = null;
            Method setMethod = null;
            try {
                int point;
                while ((point = fieldName.indexOf(46)) >= 0) {
                    String parentField = fieldName.substring(0, point);
                    String methodName2 = GET_METHOD_PREFIX + AbstractMappingLoader.capitalize(parentField);
                    Method method2 = javaClass.getMethod(methodName2, null);
                    if (AbstractMappingLoader.isAbstractOrStatic(method2)) {
                        throw new MappingException("mapping.accessorNotAccessible", methodName2, javaClass.getName());
                    }
                    getSequence.add(method2);
                    Class<?> nextClass = method2.getReturnType();
                    try {
                        methodName2 = SET_METHOD_PREFIX + AbstractMappingLoader.capitalize(parentField);
                        Class[] types = new Class[]{nextClass};
                        method2 = javaClass.getMethod(methodName2, types);
                        if (AbstractMappingLoader.isAbstractOrStatic(method2)) {
                            method2 = null;
                        }
                    }
                    catch (Exception ex) {
                        method2 = null;
                    }
                    setSequence.add(method2);
                    javaClass = nextClass;
                    fieldName = fieldName.substring(point + 1);
                }
                methodName = GET_METHOD_PREFIX + AbstractMappingLoader.capitalize(fieldName);
                Class returnType = colType == null ? fldType : colType;
                getMethod = AbstractMappingLoader.findAccessor(javaClass, methodName, returnType, true);
                if (getMethod == null && (fldType == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = AbstractMappingLoader.class$("java.lang.Boolean")) : class$java$lang$Boolean) || fldType == Boolean.TYPE)) {
                    methodName = IS_METHOD_PREFIX + AbstractMappingLoader.capitalize(fieldName);
                    getMethod = AbstractMappingLoader.findAccessor(javaClass, methodName, returnType, true);
                }
            }
            catch (MappingException ex) {
                throw ex;
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (getMethod == null) {
                String getAccessor = GET_METHOD_PREFIX + AbstractMappingLoader.capitalize(fieldName);
                String isAccessor = IS_METHOD_PREFIX + AbstractMappingLoader.capitalize(fieldName);
                throw new MappingException("mapping.accessorNotFound", getAccessor + "/" + isAccessor, colType == null ? fldType : colType, javaClass.getName());
            }
            if (fldType == null && colType == null) {
                fldType = getMethod.getReturnType();
            }
            if ((setMethod = AbstractMappingLoader.findAccessor(javaClass, methodName = SET_METHOD_PREFIX + AbstractMappingLoader.capitalize(fieldName), colType == null ? fldType : colType, false)) == null && colType != null && colRequireGetSet) {
                throw new MappingException("mapping.accessorNotFound", methodName, colType == null ? fldType : colType, javaClass.getName());
            }
            typeInfoRef.typeInfo = this.getTypeInfo(fldType, colHandler, fldMap);
            fieldName = fldMap.getName();
            if (fieldName == null) {
                fieldName = getMethod == null ? setMethod.getName() : getMethod.getName();
            }
            Method[] getArray = null;
            Method[] setArray = null;
            if (getSequence.size() > 0) {
                getArray = new Method[getSequence.size()];
                getArray = getSequence.toArray(getArray);
                setArray = new Method[setSequence.size()];
                setArray = setSequence.toArray(setArray);
            }
            handler = new FieldHandlerImpl(fieldName, getArray, setArray, getMethod, setMethod, typeInfoRef.typeInfo);
            if (setMethod != null && setMethod.getName().startsWith(ADD_METHOD_PREFIX)) {
                handler.setAddMethod(setMethod);
            }
        } else {
            Method getMethod = null;
            Method setMethod = null;
            if (fldMap.getGetMethod() != null) {
                Class rtype = fldType;
                if (colType != null) {
                    String methodName = fldMap.getGetMethod();
                    rtype = methodName.startsWith(ENUM_METHOD_PREFIX) ? (class$java$util$Enumeration == null ? (class$java$util$Enumeration = AbstractMappingLoader.class$("java.util.Enumeration")) : class$java$util$Enumeration) : (methodName.startsWith(ITER_METHOD_PREFIX) ? (class$java$util$Iterator == null ? (class$java$util$Iterator = AbstractMappingLoader.class$("java.util.Iterator")) : class$java$util$Iterator) : colType);
                }
                if ((getMethod = AbstractMappingLoader.findAccessor(javaClass, fldMap.getGetMethod(), rtype, true)) == null) {
                    throw new MappingException("mapping.accessorNotFound", fldMap.getGetMethod(), rtype, javaClass.getName());
                }
                if (fldType == null && colType == null) {
                    fldType = getMethod.getReturnType();
                }
            }
            if (fldMap.getSetMethod() != null) {
                String methodName = fldMap.getSetMethod();
                Class type = fldType;
                if (colType != null && !methodName.startsWith(ADD_METHOD_PREFIX)) {
                    type = colType;
                }
                if (methodName.startsWith("%")) {
                    int index = 0;
                    String temp = methodName.substring(1);
                    try {
                        index = Integer.parseInt(temp);
                    }
                    catch (NumberFormatException ex) {
                        throw new MappingException("mapping.invalidParameterIndex", temp);
                    }
                    if (index < 1 || index > 9) {
                        throw new MappingException("mapping.invalidParameterIndex", temp);
                    }
                } else {
                    setMethod = AbstractMappingLoader.findAccessor(javaClass, methodName, type, false);
                    if (setMethod == null) {
                        throw new MappingException("mapping.accessorNotFound", methodName, type, javaClass.getName());
                    }
                    if (fldType == null) {
                        fldType = setMethod.getParameterTypes()[0];
                    }
                }
            }
            typeInfoRef.typeInfo = this.getTypeInfo(fldType, colHandler, fldMap);
            fieldName = fldMap.getName();
            if (fieldName == null) {
                fieldName = getMethod == null ? setMethod.getName() : getMethod.getName();
            }
            handler = new FieldHandlerImpl(fieldName, null, null, getMethod, setMethod, typeInfoRef.typeInfo);
            if (setMethod != null && setMethod.getName().startsWith(ADD_METHOD_PREFIX)) {
                handler.setAddMethod(setMethod);
            }
        }
        String methodName = fldMap.getCreateMethod();
        if (methodName != null) {
            try {
                method = javaClass.getMethod(methodName, null);
                handler.setCreateMethod(method);
            }
            catch (Exception ex) {
                throw new MappingException("mapping.createMethodNotFound", methodName, javaClass.getName());
            }
        }
        if (fieldName != null && !Types.isSimpleType(fldType)) {
            try {
                methodName = CREATE_METHOD_PREFIX + AbstractMappingLoader.capitalize(fieldName);
                method = javaClass.getMethod(methodName, null);
                handler.setCreateMethod(method);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (fieldName != null) {
            try {
                Method hasMethod;
                methodName = fldMap.getHasMethod();
                if (methodName == null) {
                    methodName = HAS_METHOD_PREFIX + AbstractMappingLoader.capitalize(fieldName);
                }
                if (((hasMethod = javaClass.getMethod(methodName, null)).getModifiers() & 8) != 0) {
                    hasMethod = null;
                }
                Method deleteMethod = null;
                try {
                    methodName = DELETE_METHOD_PREFIX + AbstractMappingLoader.capitalize(fieldName);
                    deleteMethod = javaClass.getMethod(methodName, null);
                    if ((deleteMethod.getModifiers() & 8) != 0) {
                        deleteMethod = null;
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
                handler.setHasDeleteMethod(hasMethod, deleteMethod);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return handler;
    }

    private static boolean isAbstract(Class cls) {
        return (cls.getModifiers() & 0x400) != 0;
    }

    private static boolean isAbstractOrStatic(Method method) {
        return (method.getModifiers() & 0x400) != 0 || (method.getModifiers() & 8) != 0;
    }

    protected TypeInfo getTypeInfo(Class fieldType, CollectionHandler colHandler, FieldMapping fieldMap) throws MappingException {
        return new TypeInfo(Types.typeFromPrimitive(fieldType), null, null, null, fieldMap.getRequired(), null, colHandler, false);
    }

    private final Field findField(Class javaClass, String fieldName, Class fieldType) throws MappingException {
        try {
            Field field = javaClass.getField(fieldName);
            if (field.getModifiers() != 1 && field.getModifiers() != 65) {
                throw new MappingException("mapping.fieldNotAccessible", fieldName, javaClass.getName());
            }
            if (fieldType == null) {
                fieldType = Types.typeFromPrimitive(field.getType());
            } else {
                Class ft2;
                Class ft1 = Types.typeFromPrimitive(fieldType);
                if (ft1 != (ft2 = Types.typeFromPrimitive(field.getType())) && fieldType != (class$java$io$Serializable == null ? (class$java$io$Serializable = AbstractMappingLoader.class$("java.io.Serializable")) : class$java$io$Serializable)) {
                    throw new MappingException("mapping.fieldTypeMismatch", field, fieldType.getName());
                }
            }
            return field;
        }
        catch (NoSuchFieldException ex) {
            return null;
        }
        catch (SecurityException ex) {
            return null;
        }
    }

    /*
     * Exception decompiling
     */
    public static final Method findAccessor(Class javaClass, String methodName, Class fieldType, boolean getMethod) throws MappingException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IllegalStateException: Inconsistent graph @DISABLED, blocks:[0] lbl27 : ThrowStatement: throw new org.exolab.castor.mapping.MappingException((java.lang.String)"mapping.accessorReturnTypeMismatch", (java.lang.Object)method, (java.lang.Object)fieldType.getName());\u000a does not have a source @NONE, blocks:[0] lbl26 : Nop: NOP
         * 
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Cleaner$1.call(Cleaner.java:49)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Cleaner$1.call(Cleaner.java:22)
         *     at org.benf.cfr.reader.util.graph.GraphVisitorDFS.process(GraphVisitorDFS.java:68)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Cleaner.removeUnreachableCode(Cleaner.java:54)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:648)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static final String capitalize(String name) {
        char first = name.charAt(0);
        if (Character.isUpperCase(first)) {
            return name;
        }
        return Character.toUpperCase(first) + name.substring(1);
    }

    public static final String[] getIdentityColumnNames(String[] ids, ClassMapping clsMap) {
        String[] idNames = ids;
        if (ids == null || ids.length == 0) {
            ClassChoice classChoice = clsMap.getClassChoice();
            if (classChoice == null) {
                classChoice = new ClassChoice();
            }
            FieldMapping[] fieldMappings = classChoice.getFieldMapping();
            ArrayList<String> idNamesList = new ArrayList<String>();
            for (int i = 0; i < fieldMappings.length; ++i) {
                if (!fieldMappings[i].getIdentity()) continue;
                idNamesList.add(fieldMappings[i].getName());
            }
            if (idNamesList.size() > 0) {
                idNames = new String[idNamesList.size()];
                idNames = idNamesList.toArray(idNames);
            }
        }
        return idNames;
    }

    protected static final boolean isPrimitive(Class type) {
        if (type.isPrimitive()) {
            return true;
        }
        if (type == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = AbstractMappingLoader.class$("java.lang.Boolean")) : class$java$lang$Boolean) || type == (class$java$lang$Character == null ? (class$java$lang$Character = AbstractMappingLoader.class$("java.lang.Character")) : class$java$lang$Character)) {
            return true;
        }
        return type.getSuperclass() == (class$java$lang$Number == null ? (class$java$lang$Number = AbstractMappingLoader.class$("java.lang.Number")) : class$java$lang$Number);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class TypeInfoReference {
        public TypeInfo typeInfo = null;
    }
}

