/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.scheduler.multiobjective;

import es.bsc.compss.components.impl.ResourceScheduler;
import es.bsc.compss.scheduler.multiobjective.types.Gap;
import es.bsc.compss.scheduler.types.AllocatableAction;
import es.bsc.compss.scheduler.types.SchedulingInformation;
import es.bsc.compss.types.resources.WorkerResourceDescription;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

public class MOSchedulingInformation
extends SchedulingInformation {
    private final ReentrantLock l = new ReentrantLock();
    private boolean scheduled = false;
    private long lastUpdate;
    private long expectedStart = 0L;
    private long expectedEnd = 0L;
    private int openGaps = 0;
    private final List<Gap> resourcePredecessors = new LinkedList<Gap>();
    private List<AllocatableAction> resourceSuccessors = new LinkedList<AllocatableAction>();
    private boolean onOptimization = false;
    private boolean toReschedule = false;
    private final List<AllocatableAction> optimizingSuccessors;

    public <T extends WorkerResourceDescription> MOSchedulingInformation(ResourceScheduler<T> enforcedTargetResource) {
        super(enforcedTargetResource);
        this.lastUpdate = System.currentTimeMillis();
        this.optimizingSuccessors = new LinkedList<AllocatableAction>();
    }

    public void addPredecessor(Gap predecessor) {
        this.resourcePredecessors.add(predecessor);
    }

    public boolean hasPredecessors() {
        return !this.resourcePredecessors.isEmpty();
    }

    public final boolean isExecutable() {
        boolean b = true;
        this.lock();
        for (Gap g : this.resourcePredecessors) {
            b = b && g.getOrigin() == null;
        }
        this.unlock();
        return b;
    }

    public List<Gap> getPredecessors() {
        return this.resourcePredecessors;
    }

    public Gap removePredecessor(AllocatableAction successor) {
        Iterator<Gap> it = this.resourcePredecessors.iterator();
        Gap g = null;
        while (it.hasNext()) {
            g = it.next();
            if (g.getOrigin() != successor) continue;
            it.remove();
        }
        return g;
    }

    public void clearPredecessors() {
        this.resourcePredecessors.clear();
    }

    public void addSuccessor(AllocatableAction successor) {
        this.resourceSuccessors.add(successor);
    }

    public List<AllocatableAction> getSuccessors() {
        return this.resourceSuccessors;
    }

    public void removeSuccessor(AllocatableAction successor) {
        this.resourceSuccessors.remove(successor);
    }

    public void clearSuccessors() {
        this.resourceSuccessors.clear();
    }

    public List<AllocatableAction> replaceSuccessors(List<AllocatableAction> newSuccessors) {
        List<AllocatableAction> oldSuccessors = this.resourceSuccessors;
        this.resourceSuccessors = newSuccessors;
        return oldSuccessors;
    }

    public void setExpectedStart(long expectedStart) {
        this.expectedStart = expectedStart;
    }

    public long getExpectedStart() {
        return this.expectedStart;
    }

    public void setExpectedEnd(long expectedEnd) {
        this.expectedEnd = expectedEnd;
    }

    public long getExpectedEnd() {
        return this.expectedEnd;
    }

    public void setLastUpdate(long lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    public long getLastUpdate() {
        return this.lastUpdate;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("\tlastUpdate: " + this.lastUpdate + "\n" + "\texpectedStart: " + this.expectedStart + "\n" + "\texpectedEnd:" + this.expectedEnd + "\n");
        sb.append("\t").append("schedPredecessors: ");
        for (Gap g : this.getPredecessors()) {
            sb.append(" ").append(g.getOrigin());
        }
        sb.append("\n");
        sb.append("\t").append("schedSuccessors: ");
        for (AllocatableAction aa : this.getSuccessors()) {
            sb.append(" ").append(aa);
        }
        sb.append("\n");
        sb.append("\tOptimization Successors").append(this.optimizingSuccessors);
        return sb.toString();
    }

    public boolean tryToLock() {
        try {
            return this.l.tryLock(1L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ie) {
            return false;
        }
    }

    public void lock() {
        this.l.lock();
    }

    public void unlock() {
        this.l.unlock();
    }

    public void unlockCompletely() {
        while (this.l.getHoldCount() > 1) {
            this.l.unlock();
        }
    }

    public void scheduled() {
        this.scheduled = true;
    }

    public void unscheduled() {
        this.scheduled = false;
        this.resourcePredecessors.clear();
        this.resourceSuccessors.clear();
    }

    boolean isScheduled() {
        return this.scheduled;
    }

    public void setOnOptimization(boolean b) {
        this.onOptimization = b;
    }

    public boolean isOnOptimization() {
        return this.onOptimization;
    }

    public void setToReschedule(boolean b) {
        this.toReschedule = b;
    }

    public boolean isToReschedule() {
        return this.toReschedule;
    }

    public void optimizingSuccessor(AllocatableAction action) {
        this.optimizingSuccessors.add(action);
    }

    public List<AllocatableAction> getOptimizingSuccessors() {
        return this.optimizingSuccessors;
    }

    public void clearOptimizingSuccessors() {
        this.optimizingSuccessors.clear();
    }

    public void addGap() {
        ++this.openGaps;
    }

    public void removeGap() {
        --this.openGaps;
    }

    public void clearGaps() {
        this.openGaps = 0;
    }

    public boolean hasGaps() {
        return this.openGaps > 0;
    }

    public int getLockCount() {
        return this.l.getHoldCount();
    }

    public int getGapCount() {
        return this.openGaps;
    }
}

