/*
 * Decompiled with CFR 0.152.
 */
package org.gridlab.gat.io.cpi.local;

import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Map;
import org.gridlab.gat.AdaptorNotApplicableException;
import org.gridlab.gat.GAT;
import org.gridlab.gat.GATContext;
import org.gridlab.gat.GATInvocationException;
import org.gridlab.gat.GATObjectCreationException;
import org.gridlab.gat.MethodNotApplicableException;
import org.gridlab.gat.URI;
import org.gridlab.gat.io.File;
import org.gridlab.gat.io.cpi.FileCpi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalFileAdaptor
extends FileCpi {
    protected static Logger logger = LoggerFactory.getLogger(LocalFileAdaptor.class);
    private java.io.File f;

    public static Map<String, Boolean> getSupportedCapabilities() {
        Map capabilities = FileCpi.getSupportedCapabilities();
        capabilities.put("copy", true);
        capabilities.put("canRead", true);
        capabilities.put("canWrite", true);
        capabilities.put("createNewFile", true);
        capabilities.put("delete", true);
        capabilities.put("exists", true);
        capabilities.put("getAbsoluteFile", true);
        capabilities.put("getCanonicalFile", true);
        capabilities.put("getParent", true);
        capabilities.put("getParentFile", true);
        capabilities.put("isDirectory", true);
        capabilities.put("isFile", true);
        capabilities.put("isHidden", true);
        capabilities.put("lastModified", true);
        capabilities.put("length", true);
        capabilities.put("list", true);
        capabilities.put("listFiles", true);
        capabilities.put("mkdir", true);
        capabilities.put("mkdirs", true);
        capabilities.put("move", true);
        capabilities.put("renameTo", true);
        capabilities.put("setLastModified", true);
        capabilities.put("setReadOnly", true);
        return capabilities;
    }

    public static String getDescription() {
        return "The Local File Adaptor is a simple wrapper around the java.io.File object.";
    }

    public static String[] getSupportedSchemes() {
        return new String[]{"local", "file", ""};
    }

    public LocalFileAdaptor(GATContext gatContext, URI location) throws GATObjectCreationException {
        super(gatContext, location);
        if (!location.refersToLocalHost()) {
            throw new AdaptorNotApplicableException("Cannot use remote files with the local file adaptor, URI is: " + location);
        }
        this.f = this.getFile(location);
    }

    private java.io.File getFile(URI location) {
        java.io.File file;
        URI correctedURI = this.newcorrectURI(location);
        logger.debug("corrected uri '" + location + "' to '" + correctedURI + "'");
        if (correctedURI.getPath() == null || correctedURI.getPath().equals("")) {
            file = new java.io.File(".");
        } else {
            String path = correctedURI.getPath();
            if (java.io.File.separatorChar == '\\') {
                if (path.startsWith("/")) {
                    path = path.substring(1);
                }
                path = path.replace("/", "\\");
            }
            file = new java.io.File(path);
        }
        return file;
    }

    private URI newcorrectURI(URI in) {
        if (in.getScheme() == null) {
            try {
                in = in.setScheme("file");
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        if (in.getHost() != null && !in.hasAbsolutePath()) {
            try {
                in = in.setPath(in.getPath());
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return in;
    }

    protected static URI correctURI(URI in) {
        if (in.getScheme() == null) {
            try {
                return new URI("file:///" + in.getPath());
            }
            catch (URISyntaxException e) {
                throw new Error("internal error in LocalFile: " + e);
            }
        }
        return in;
    }

    protected void copyDir(java.io.File sourceFile, java.io.File destFile) throws GATInvocationException {
        String sourcePath = sourceFile.getPath();
        String destPath = destFile.getPath();
        if (logger.isDebugEnabled()) {
            logger.debug("copyDir '" + sourcePath + "' to '" + destPath + "'");
        }
        boolean existingDir = false;
        if (destFile.exists()) {
            if (!destFile.isDirectory()) {
                throw new GATInvocationException("cannot overwrite non-directory '" + destPath + "' with directory '" + sourcePath + "'!");
            }
            existingDir = true;
        }
        if (!(!existingDir || this.gatContext.getPreferences().containsKey("file.directory.copy") && ((String)this.gatContext.getPreferences().get("file.directory.copy")).equalsIgnoreCase("contents") || sourcePath.length() <= 0)) {
            int start = sourcePath.lastIndexOf(java.io.File.separator) + 1;
            String separator = "";
            if (!destPath.endsWith(java.io.File.separator)) {
                separator = java.io.File.separator;
            }
            destPath = destPath + separator + sourcePath.substring(start);
            destFile = new java.io.File(destPath);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("destPath = " + destPath);
        }
        if (this.gatContext.getPreferences().containsKey("file.create") && ((String)this.gatContext.getPreferences().get("file.create")).equalsIgnoreCase("true")) {
            destFile.mkdirs();
        } else {
            boolean mkdir = destFile.mkdir();
            if (logger.isDebugEnabled()) {
                logger.debug("mkdir: " + mkdir);
            }
        }
        java.io.File[] files = sourceFile.listFiles();
        if (files == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("copyDirectory: no files in src directory: " + sourcePath);
            }
            return;
        }
        for (java.io.File file : files) {
            if (logger.isDebugEnabled()) {
                logger.debug("copyDirectory: file to copy = " + file);
            }
            String newDestString = destPath;
            newDestString = newDestString + java.io.File.separator + file.getName();
            if (logger.isDebugEnabled()) {
                logger.debug("new dest: " + newDestString);
                logger.debug("src is file: " + file.isFile());
                logger.debug("src is dir: " + file.isDirectory());
            }
            java.io.File newDest = new java.io.File(newDestString);
            if (file.isFile()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("copyDir: copying " + file);
                }
                LocalFileAdaptor.copy(file, newDest);
                continue;
            }
            if (file.isDirectory()) {
                this.copyDir(file, newDest);
                continue;
            }
            throw new GATInvocationException("don't know how to handle file: " + file.getPath() + " (links are not supported).");
        }
    }

    public void copy(URI destination) throws GATInvocationException {
        java.io.File destinationParentFile;
        if (!destination.isCompatible("file") && !destination.isCompatible("local") || !destination.refersToLocalHost()) {
            throw new MethodNotApplicableException("LocalFile: cannot copy to remote destination");
        }
        destination = this.newcorrectURI(destination);
        String path = this.getPath();
        String destPath = destination.getPath();
        if (logger.isInfoEnabled()) {
            logger.info("local copy of " + path + " to " + destPath);
        }
        if (destPath.equals(path)) {
            if (logger.isInfoEnabled()) {
                logger.info("local copy, source is the same file as dest.");
            }
            return;
        }
        java.io.File destFile = this.getFile(destination);
        if (!this.exists()) {
            throw new GATInvocationException("the local source file does not exist, path = " + path);
        }
        if (this.isDirectory()) {
            if (logger.isDebugEnabled()) {
                logger.debug("local copy, it is a dir");
            }
            this.copyDir(this.f, destFile);
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("local copy, it is a file");
        }
        if (this.gatContext.getPreferences().containsKey("file.create") && ((String)this.gatContext.getPreferences().get("file.create")).equalsIgnoreCase("true") && (destinationParentFile = destFile.getParentFile()) != null) {
            boolean result = destinationParentFile.mkdirs();
            if (logger.isDebugEnabled()) {
                logger.debug("new dirs created: " + result);
            }
        }
        if (destFile.isDirectory()) {
            destPath = destPath + java.io.File.separator + this.getName();
            destFile = new java.io.File(destPath);
        }
        try {
            destFile.createNewFile();
        }
        catch (IOException e) {
            throw new GATInvocationException("Creating local file failed", (Throwable)e);
        }
        LocalFileAdaptor.copy(this.f, destFile);
    }

    private static void copy(java.io.File in, java.io.File out) throws GATInvocationException {
        FileInputStream inBuf = null;
        FileOutputStream outBuf = null;
        try {
            out.createNewFile();
            inBuf = new FileInputStream(in);
            outBuf = new FileOutputStream(out);
        }
        catch (IOException e) {
            throw new GATInvocationException("LocalFile", (Throwable)e);
        }
        try {
            int len;
            byte[] buf = new byte[8192];
            while ((len = inBuf.read(buf)) >= 0) {
                outBuf.write(buf, 0, len);
            }
        }
        catch (IOException e) {
            throw new GATInvocationException("LocalFile", (Throwable)e);
        }
        finally {
            if (outBuf != null) {
                try {
                    outBuf.close();
                }
                catch (IOException e) {
                    throw new GATInvocationException("LocalFile", (Throwable)e);
                }
            }
            if (inBuf != null) {
                try {
                    inBuf.close();
                }
                catch (IOException e) {
                    throw new GATInvocationException("LocalFile", (Throwable)e);
                }
            }
        }
    }

    public boolean canRead() {
        return this.f.canRead();
    }

    public boolean canWrite() {
        return this.f.canWrite();
    }

    public boolean createNewFile() throws GATInvocationException {
        try {
            return this.f.createNewFile();
        }
        catch (IOException e) {
            throw new GATInvocationException("LocalFile", (Throwable)e);
        }
    }

    public boolean delete() {
        return this.f.delete();
    }

    public boolean exists() {
        return this.f.exists();
    }

    public File getAbsoluteFile() throws GATInvocationException {
        try {
            return GAT.createFile((GATContext)this.gatContext, (URI)this.localToURI(this.f.getAbsoluteFile().getPath()));
        }
        catch (Exception e) {
            throw new GATInvocationException("default file", (Throwable)e);
        }
    }

    public String getAbsolutePath() {
        return this.f.getAbsolutePath();
    }

    public File getCanonicalFile() throws GATInvocationException {
        try {
            return GAT.createFile((GATContext)this.gatContext, (URI)this.localToURI(this.f.getCanonicalFile().getPath()));
        }
        catch (Exception e) {
            throw new GATInvocationException("default file", (Throwable)e);
        }
    }

    public String getCanonicalPath() throws GATInvocationException {
        try {
            return this.f.getCanonicalPath();
        }
        catch (IOException e) {
            throw new GATInvocationException("LocalFile", (Throwable)e);
        }
    }

    public String getParent() {
        return this.f.getParent();
    }

    public File getParentFile() throws GATInvocationException {
        java.io.File parent = this.f.getParentFile();
        if (parent == null) {
            return null;
        }
        try {
            return GAT.createFile((GATContext)this.gatContext, (URI)this.localToURI(parent.getPath()));
        }
        catch (Exception e) {
            throw new GATInvocationException("default file", (Throwable)e);
        }
    }

    public boolean isDirectory() {
        return this.f.isDirectory();
    }

    public boolean isFile() {
        return this.f.isFile();
    }

    public boolean isHidden() {
        return this.f.isHidden();
    }

    public long lastModified() throws GATInvocationException {
        return this.f.lastModified();
    }

    public long length() throws GATInvocationException {
        return this.f.length();
    }

    public String[] list() throws GATInvocationException {
        String[] res = this.f.list();
        if (!this.ignoreHiddenFiles) {
            return res;
        }
        ArrayList<String> l = new ArrayList<String>();
        for (int i = 0; i < res.length; ++i) {
            if (res[i].startsWith(".")) continue;
            l.add(res[i]);
        }
        return l.toArray(new String[l.size()]);
    }

    public String[] list(FilenameFilter arg0) {
        String[] res = this.f.list(arg0);
        if (!this.ignoreHiddenFiles) {
            return res;
        }
        ArrayList<String> l = new ArrayList<String>();
        for (int i = 0; i < res.length; ++i) {
            if (res[i].startsWith(".")) continue;
            l.add(res[i]);
        }
        return l.toArray(new String[l.size()]);
    }

    public File[] listFiles() throws GATInvocationException {
        if (!this.isDirectory()) {
            throw new GATInvocationException("this is not a directory: " + this.location);
        }
        java.io.File[] r = this.f.listFiles();
        if (r == null) {
            throw new GATInvocationException("IO error in local file adaptor");
        }
        ArrayList<java.io.File> l = new ArrayList<java.io.File>();
        for (int i = 0; i < r.length; ++i) {
            if (this.ignoreHiddenFiles && r[i].isHidden()) continue;
            l.add(r[i]);
        }
        File[] res = new File[l.size()];
        for (int i = 0; i < res.length; ++i) {
            try {
                res[i] = GAT.createFile((GATContext)this.gatContext, (URI)this.localToURI(((java.io.File)l.get(i)).getPath()));
                continue;
            }
            catch (Exception e) {
                throw new GATInvocationException("LocalFile", (Throwable)e);
            }
        }
        return res;
    }

    public File[] listFiles(FileFilter arg0) throws GATInvocationException {
        java.io.File[] r = this.f.listFiles(arg0);
        ArrayList<java.io.File> l = new ArrayList<java.io.File>();
        for (int i = 0; i < r.length; ++i) {
            if (this.ignoreHiddenFiles && r[i].isHidden()) continue;
            l.add(r[i]);
        }
        File[] res = new File[r.length];
        for (int i = 0; i < res.length; ++i) {
            try {
                res[i] = GAT.createFile((GATContext)this.gatContext, (URI)this.localToURI(((java.io.File)l.get(i)).getPath()));
                continue;
            }
            catch (Exception e) {
                throw new GATInvocationException("LocalFile", (Throwable)e);
            }
        }
        return res;
    }

    public File[] listFiles(FilenameFilter arg0) throws GATInvocationException {
        java.io.File[] r = this.f.listFiles(arg0);
        ArrayList<java.io.File> l = new ArrayList<java.io.File>();
        for (int i = 0; i < r.length; ++i) {
            if (this.ignoreHiddenFiles && r[i].isHidden()) continue;
            l.add(r[i]);
        }
        File[] res = new File[r.length];
        for (int i = 0; i < res.length; ++i) {
            try {
                res[i] = GAT.createFile((GATContext)this.gatContext, (URI)this.localToURI(((java.io.File)l.get(i)).getPath()));
                continue;
            }
            catch (Exception e) {
                throw new GATInvocationException("LocalFile", (Throwable)e);
            }
        }
        return res;
    }

    public boolean mkdir() throws GATInvocationException {
        return this.f.mkdir();
    }

    public boolean mkdirs() {
        return this.f.mkdirs();
    }

    public void move(URI destination) throws GATInvocationException {
        if (!destination.isCompatible("file") && !destination.isCompatible("local") || !destination.refersToLocalHost()) {
            throw new MethodNotApplicableException("LocalFile: cannot move to remote destination");
        }
        destination = this.newcorrectURI(destination);
        String path = this.getPath();
        String destPath = destination.getPath();
        if (logger.isInfoEnabled()) {
            logger.info("local move of " + path + " to " + destPath);
        }
        if (destPath.equals(path)) {
            if (logger.isInfoEnabled()) {
                logger.info("local move, source is the same file as dest.");
            }
            return;
        }
        if (!this.exists()) {
            throw new GATInvocationException("the local source file does not exist, path = " + path);
        }
        java.io.File tmp = new java.io.File(destPath);
        boolean res = this.f.renameTo(tmp);
        if (!res) {
            throw new GATInvocationException("Could not move file");
        }
    }

    public boolean renameTo(File arg0) throws GATInvocationException {
        URI arg = arg0.toGATURI();
        if (!arg.isCompatible("file") && !arg.isCompatible("local") || !arg.refersToLocalHost()) {
            throw new MethodNotApplicableException("LocalFile: cannot rename to remote destination");
        }
        if (!arg.refersToLocalHost()) {
            throw new GATInvocationException("LocalFile: cannot rename to remote destination");
        }
        java.io.File tmp = this.getFile(arg);
        return this.f.renameTo(tmp);
    }

    public boolean setLastModified(long arg0) {
        return this.f.setLastModified(arg0);
    }

    public boolean setReadOnly() {
        return this.f.setReadOnly();
    }

    private URI localToURI(String path) throws URISyntaxException {
        String scheme = this.location.getScheme();
        if (scheme == null || scheme.equals("")) {
            scheme = "file";
        }
        return new URI(scheme + ":///" + path.replace(java.io.File.separatorChar, '/'));
    }
}

