/*
 * Decompiled with CFR 0.152.
 */
package org.gridlab.gat.resources.cpi.local;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.gridlab.gat.GAT;
import org.gridlab.gat.GATContext;
import org.gridlab.gat.GATInvocationException;
import org.gridlab.gat.GATObjectCreationException;
import org.gridlab.gat.engine.GATEngine;
import org.gridlab.gat.engine.util.FileWaiter;
import org.gridlab.gat.engine.util.ProcessBundle;
import org.gridlab.gat.engine.util.StreamForwarder;
import org.gridlab.gat.io.File;
import org.gridlab.gat.monitoring.Metric;
import org.gridlab.gat.monitoring.MetricDefinition;
import org.gridlab.gat.monitoring.MetricEvent;
import org.gridlab.gat.resources.Job;
import org.gridlab.gat.resources.JobDescription;
import org.gridlab.gat.resources.cpi.JobCpi;
import org.gridlab.gat.resources.cpi.Sandbox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalJob
extends JobCpi {
    protected static Logger logger = LoggerFactory.getLogger(LocalJob.class);
    private ProcessBundle p;
    private int exitStatus = 0;
    private MetricDefinition statusMetricDefinition;
    private Metric statusMetric;
    private int processID;
    private final String triggerDirectory;
    private final String jobName;
    private StreamForwarder outputStreamFile;
    private StreamForwarder errorStreamFile;
    private FileWaiter waiter = null;
    private boolean stopping = false;

    protected LocalJob(GATContext gatContext, JobDescription description, Sandbox sandbox) {
        super(gatContext, description, sandbox);
        HashMap<String, Class<Job.JobState>> returnDef = new HashMap<String, Class<Job.JobState>>();
        returnDef.put("status", Job.JobState.class);
        this.statusMetricDefinition = new MetricDefinition("job.status", 2, "JobState", null, null, returnDef);
        this.statusMetric = this.statusMetricDefinition.createMetric(null);
        this.registerMetric("getJobStatus", this.statusMetricDefinition);
        this.triggerDirectory = description.getSoftwareDescription().getStringAttribute("triggerDirectory", null);
        this.jobName = description.getSoftwareDescription().getStringAttribute("job.name", null);
    }

    void setErrorStream(StreamForwarder err) {
        this.errorStreamFile = err;
    }

    void setOutputStream(StreamForwarder out) {
        this.outputStreamFile = out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForTrigger(Job.JobState state) throws GATInvocationException {
        File file;
        if (this.triggerDirectory == null) {
            return;
        }
        if (this.jobName == null) {
            return;
        }
        if (this.waiter == null) {
            try {
                this.waiter = FileWaiter.createFileWaiter((File)GAT.createFile((GATContext)this.gatContext, (String)this.triggerDirectory));
            }
            catch (GATObjectCreationException e) {
                throw new GATInvocationException("Could not create", (Throwable)e);
            }
        }
        String filename = this.jobName + "." + state.toString().substring(0, 3);
        try {
            file = GAT.createFile((GATContext)this.gatContext, (String)(this.triggerDirectory + "/" + filename));
        }
        catch (GATObjectCreationException e) {
            throw new GATInvocationException("Could not create");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Waiting for " + filename + " in directory " + this.triggerDirectory);
        }
        this.waiter.waitFor(filename);
        if (logger.isDebugEnabled()) {
            logger.debug("Finished waiting for " + filename + " in directory " + this.triggerDirectory);
        }
        Class<?> clazz = ((Object)((Object)this)).getClass();
        synchronized (clazz) {
            if (!file.delete() && logger.isDebugEnabled()) {
                logger.debug("Could not remove " + file.toGATURI());
            }
        }
    }

    protected void setProcess(ProcessBundle bundle) {
        this.p = bundle;
        this.processID = bundle.getProcessID();
    }

    protected void setState(Job.JobState state) {
        if (state == this.state) {
            return;
        }
        this.state = state;
        MetricEvent v = new MetricEvent((Object)this, (Object)state, this.statusMetric, System.currentTimeMillis());
        this.fireMetric(v);
    }

    public synchronized Map<String, Object> getInfo() throws GATInvocationException {
        HashMap<String, Object> m = new HashMap<String, Object>();
        this.getState();
        m.put("adaptor.job.id", this.processID);
        m.put("state", this.state.toString());
        if (this.state != Job.JobState.RUNNING) {
            m.put("hostname", null);
        } else {
            m.put("hostname", GATEngine.getLocalHostName());
        }
        if (this.state == Job.JobState.INITIAL || this.state == Job.JobState.UNKNOWN) {
            m.put("submissiontime", null);
        } else {
            m.put("submissiontime", this.submissiontime);
        }
        if (this.state == Job.JobState.INITIAL || this.state == Job.JobState.UNKNOWN || this.state == Job.JobState.SCHEDULED) {
            m.put("starttime", null);
        } else {
            m.put("starttime", this.starttime);
        }
        if (this.state != Job.JobState.STOPPED) {
            m.put("stoptime", null);
        } else {
            m.put("stoptime", this.stoptime);
        }
        m.put("poststage.exception", (Object)this.postStageException);
        m.put("resourcebroker", "Local");
        m.put("exitvalue", "" + this.exitStatus);
        if (this.deleteException != null) {
            m.put("delete.exception", (Object)this.deleteException);
        }
        if (this.wipeException != null) {
            m.put("wipe.exception", (Object)this.wipeException);
        }
        return m;
    }

    public synchronized int getExitStatus() throws GATInvocationException {
        if (this.state != Job.JobState.STOPPED) {
            throw new GATInvocationException("not in STOPPED state");
        }
        return this.exitStatus;
    }

    public void stop() throws GATInvocationException {
        this.stop(this.gatContext.getPreferences().containsKey("job.stop.poststage") && this.gatContext.getPreferences().get("job.stop.poststage").equals("false"), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stop(boolean skipPostStage, boolean kill) throws GATInvocationException {
        LocalJob localJob = this;
        synchronized (localJob) {
            if (this.stopping) {
                return;
            }
            this.stopping = true;
            if (this.state == Job.JobState.POST_STAGING || this.state == Job.JobState.STOPPED || this.state == Job.JobState.SUBMISSION_ERROR) {
                return;
            }
        }
        try {
            this.p.closeInput();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (kill) {
            this.p.kill();
        }
        if (this.outputStreamFile != null) {
            this.outputStreamFile.waitUntilFinished();
            try {
                this.outputStreamFile.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (this.errorStreamFile != null) {
            this.errorStreamFile.waitUntilFinished();
            try {
                this.errorStreamFile.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (!skipPostStage) {
            this.setState(Job.JobState.POST_STAGING);
            if (!kill) {
                this.waitForTrigger(Job.JobState.POST_STAGING);
            }
            this.sandbox.retrieveAndCleanup((JobCpi)this);
        }
        this.setStopTime();
        this.setState(Job.JobState.STOPPED);
        this.finished();
    }

    public OutputStream getStdin() throws GATInvocationException {
        if (this.jobDescription.getSoftwareDescription().streamingStdinEnabled()) {
            return this.p.getStdin();
        }
        throw new GATInvocationException("stdin streaming is not enabled!");
    }

    public InputStream getStdout() throws GATInvocationException {
        if (this.jobDescription.getSoftwareDescription().streamingStdoutEnabled()) {
            return this.p.getStdout();
        }
        throw new GATInvocationException("stdout streaming is not enabled!");
    }

    public InputStream getStderr() throws GATInvocationException {
        if (this.jobDescription.getSoftwareDescription().streamingStderrEnabled()) {
            return this.p.getStderr();
        }
        throw new GATInvocationException("stderr streaming is not enabled!");
    }

    protected void monitorState() {
        new StateMonitor();
    }

    class StateMonitor
    extends Thread {
        StateMonitor() {
            this.setName("local state monitor: " + LocalJob.this.jobDescription.getSoftwareDescription().getExecutable());
            this.setDaemon(true);
            this.start();
        }

        @Override
        public void run() {
            block2: {
                LocalJob.this.exitStatus = LocalJob.this.p.getExitStatus();
                try {
                    LocalJob.this.stop(false, false);
                }
                catch (GATInvocationException e) {
                    e.printStackTrace();
                    if (!logger.isDebugEnabled()) break block2;
                    logger.debug("unable to stop job: " + (Object)((Object)e));
                }
            }
        }
    }
}

