/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.options;

import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.List;
import org.jclouds.googlecomputeengine.domain.UrlMap;
import org.jclouds.googlecomputeengine.options.AutoValue_UrlMapOptions;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.SerializedNames;

public abstract class UrlMapOptions {
    @Nullable
    public abstract String name();

    @Nullable
    public abstract String description();

    @Nullable
    public abstract List<UrlMap.HostRule> hostRules();

    @Nullable
    public abstract List<UrlMap.PathMatcher> pathMatchers();

    @Nullable
    public abstract List<UrlMap.UrlMapTest> tests();

    @Nullable
    public abstract URI defaultService();

    @Nullable
    public abstract String fingerprint();

    @SerializedNames(value={"name", "description", "hostRules", "pathMatchers", "tests", "defaultService", "fingerprint"})
    static UrlMapOptions create(String name, String description, List<UrlMap.HostRule> hostRules, List<UrlMap.PathMatcher> pathMatchers, List<UrlMap.UrlMapTest> tests, URI defaultService, String fingerprint) {
        return new AutoValue_UrlMapOptions(name, description, hostRules, pathMatchers, tests, defaultService, fingerprint);
    }

    UrlMapOptions() {
    }

    public static class Builder {
        private String name;
        private String description;
        private List<UrlMap.HostRule> hostRules;
        private List<UrlMap.PathMatcher> pathMatchers;
        private List<UrlMap.UrlMapTest> tests;
        private URI defaultService;
        private String fingerprint;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder hostRules(List<UrlMap.HostRule> hostRules) {
            this.hostRules = hostRules;
            return this;
        }

        public Builder pathMatchers(List<UrlMap.PathMatcher> pathMatchers) {
            this.pathMatchers = pathMatchers;
            return this;
        }

        public Builder tests(List<UrlMap.UrlMapTest> tests) {
            this.tests = tests;
            return this;
        }

        public Builder defaultService(URI defaultService) {
            this.defaultService = defaultService;
            return this;
        }

        public Builder fingerprint(String fingerprint) {
            this.fingerprint = fingerprint;
            return this;
        }

        public UrlMapOptions build() {
            Preconditions.checkNotNull(this.name, "In UrlMapOptions: A UrlMap name cannot be null, if patching an existing UrlMap use buildForPatch() instead of build()");
            Preconditions.checkNotNull(this.defaultService, "In UrlMapOptions: A UrlMap defaultService cannot be null, if patching an existing UrlMap use buildForPatch() instead of build()");
            return UrlMapOptions.create(this.name, this.description, this.hostRules, this.pathMatchers, this.tests, this.defaultService, this.fingerprint);
        }

        public UrlMapOptions buildForPatch() {
            return UrlMapOptions.create(this.name, this.description, this.hostRules, this.pathMatchers, this.tests, this.defaultService, this.fingerprint);
        }
    }
}

