/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.compute.loaders;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.cache.CacheLoader;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Map;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.aws.ec2.AWSEC2Api;
import org.jclouds.aws.ec2.features.AWSSecurityGroupApi;
import org.jclouds.compute.util.ComputeServiceUtils;
import org.jclouds.ec2.compute.domain.RegionAndName;
import org.jclouds.ec2.compute.domain.RegionNameAndIngressRules;
import org.jclouds.logging.Logger;
import org.jclouds.net.domain.IpPermission;
import org.jclouds.net.domain.IpProtocol;

@Singleton
public class AWSEC2CreateSecurityGroupIfNeeded
extends CacheLoader<RegionAndName, String> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    protected final AWSSecurityGroupApi securityApi;
    protected final Predicate<RegionAndName> securityGroupEventualConsistencyDelay;
    protected final Function<String, String> groupNameToId;

    @Inject
    public AWSEC2CreateSecurityGroupIfNeeded(AWSEC2Api ec2Api, @Named(value="SECGROUP_NAME_TO_ID") Function<String, String> groupNameToId, @Named(value="SECURITY") Predicate<RegionAndName> securityGroupEventualConsistencyDelay) {
        this(Preconditions.checkNotNull(ec2Api, "ec2Api").getSecurityGroupApi().get(), groupNameToId, securityGroupEventualConsistencyDelay);
    }

    public AWSEC2CreateSecurityGroupIfNeeded(AWSSecurityGroupApi securityApi, @Named(value="SECGROUP_NAME_TO_ID") Function<String, String> groupNameToId, @Named(value="SECURITY") Predicate<RegionAndName> securityGroupEventualConsistencyDelay) {
        this.securityApi = Preconditions.checkNotNull(securityApi, "securityApi");
        this.groupNameToId = Preconditions.checkNotNull(groupNameToId, "groupNameToId");
        this.securityGroupEventualConsistencyDelay = Preconditions.checkNotNull(securityGroupEventualConsistencyDelay, "securityGroupEventualConsistencyDelay");
    }

    @Override
    public String load(RegionAndName from) {
        RegionNameAndIngressRules realFrom = (RegionNameAndIngressRules)RegionNameAndIngressRules.class.cast(from);
        this.createSecurityGroupInRegion(from.getRegion(), from.getName(), realFrom.getPorts());
        return from.getName();
    }

    private void createSecurityGroupInRegion(String region, String name, int ... ports) {
        Preconditions.checkNotNull(region, "region");
        Preconditions.checkNotNull(name, "name");
        this.logger.debug(">> creating securityGroup region(%s) name(%s)", region, name);
        try {
            ImmutableCollection perms;
            this.securityApi.createSecurityGroupInRegion(region, name, name);
            boolean created = this.securityGroupEventualConsistencyDelay.apply(new RegionAndName(region, name));
            if (!created) {
                throw new RuntimeException(String.format("security group %s/%s is not available after creating", region, name));
            }
            this.logger.debug("<< created securityGroup(%s)", name);
            ImmutableSet.Builder permissions = ImmutableSet.builder();
            String id = name.startsWith("sg-") ? name : this.groupNameToId.apply(new RegionAndName(region, name).slashEncode());
            if (ports.length > 0) {
                for (Map.Entry<Integer, Integer> range : ComputeServiceUtils.getPortRangesFromList(ports).entrySet()) {
                    permissions.add(IpPermission.builder().fromPort(range.getKey()).toPort(range.getValue()).ipProtocol(IpProtocol.TCP).cidrBlock("0.0.0.0/0").build());
                }
                String myOwnerId = Iterables.get(this.securityApi.describeSecurityGroupsInRegion(region, name), 0).getOwnerId();
                permissions.add(IpPermission.builder().fromPort(0).toPort(65535).ipProtocol(IpProtocol.TCP).tenantIdGroupNamePair(myOwnerId, id).build());
                permissions.add(IpPermission.builder().fromPort(0).toPort(65535).ipProtocol(IpProtocol.UDP).tenantIdGroupNamePair(myOwnerId, id).build());
            }
            if (!(perms = permissions.build()).isEmpty()) {
                this.logger.debug(">> authorizing securityGroup region(%s) name(%s) IpPermissions(%s)", region, name, perms);
                this.securityApi.authorizeSecurityGroupIngressInRegion(region, id, perms);
                this.logger.debug("<< authorized securityGroup(%s)", name);
            }
        }
        catch (IllegalStateException e) {
            this.logger.debug("<< reused securityGroup(%s)", name);
        }
    }
}

