/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid.options;

import com.google.common.base.Preconditions;
import org.jclouds.http.options.BaseHttpRequestOptions;

public class GetServerListOptions
extends BaseHttpRequestOptions {
    public static final GetServerListOptions NONE = new GetServerListOptions();

    public GetServerListOptions limitServerTypeTo(String serverType) {
        Preconditions.checkState(!this.queryParameters.containsKey("server.type"), "Can't have duplicate server type limit");
        this.queryParameters.put("server.type", serverType);
        return this;
    }

    public GetServerListOptions inDatacenter(String datacenterId) {
        Preconditions.checkState(!this.queryParameters.containsKey("datacenter"), "Can't have duplicate datacenter id");
        this.queryParameters.put("datacenter", datacenterId);
        return this;
    }

    public GetServerListOptions onlySandboxServers() {
        Preconditions.checkState(!this.queryParameters.containsKey("isSandbox"), "Can't have duplicate sandbox type limit");
        this.queryParameters.put("isSandbox", "true");
        return this;
    }

    public GetServerListOptions excludeSandboxServers() {
        Preconditions.checkState(!this.queryParameters.containsKey("isSandbox"), "Can't have duplicate sandbox type limit");
        this.queryParameters.put("isSandbox", "false");
        return this;
    }

    public static class Builder {
        public GetServerListOptions inDatacenter(String datacenterId) {
            GetServerListOptions getServerListOptions = new GetServerListOptions();
            getServerListOptions.inDatacenter(Preconditions.checkNotNull(datacenterId));
            return getServerListOptions;
        }

        public GetServerListOptions limitServerTypeTo(String serverType) {
            GetServerListOptions getServerListOptions = new GetServerListOptions();
            getServerListOptions.limitServerTypeTo(Preconditions.checkNotNull(serverType));
            return getServerListOptions;
        }

        public GetServerListOptions onlySandboxServers() {
            GetServerListOptions getServerListOptions = new GetServerListOptions();
            getServerListOptions.onlySandboxServers();
            return getServerListOptions;
        }

        public GetServerListOptions excludeSandboxServers() {
            GetServerListOptions getServerListOptions = new GetServerListOptions();
            getServerListOptions.excludeSandboxServers();
            return getServerListOptions;
        }
    }
}

