/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.joyent.cloudapi.v6_5.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.domain.ComputeMetadata;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeMetadataBuilder;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.functions.GroupNamingConvention;
import org.jclouds.compute.util.ComputeServiceUtils;
import org.jclouds.domain.Location;
import org.jclouds.joyent.cloudapi.v6_5.domain.Machine;
import org.jclouds.joyent.cloudapi.v6_5.domain.datacenterscoped.DatacenterAndId;
import org.jclouds.joyent.cloudapi.v6_5.domain.datacenterscoped.DatacenterAndName;
import org.jclouds.joyent.cloudapi.v6_5.domain.datacenterscoped.MachineInDatacenter;
import org.jclouds.joyent.cloudapi.v6_5.reference.Metadata;
import org.jclouds.logging.Logger;
import org.jclouds.util.InetAddresses2;

public class MachineInDatacenterToNodeMetadata
implements Function<MachineInDatacenter, NodeMetadata> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    protected Map<Machine.State, NodeMetadata.Status> toPortableNodeStatus;
    protected final Supplier<Map<String, Location>> locationIndex;
    protected final Supplier<Set<? extends Image>> images;
    protected final Supplier<Set<? extends Hardware>> hardwares;
    protected final GroupNamingConvention nodeNamingConvention;

    @Inject
    public MachineInDatacenterToNodeMetadata(Map<Machine.State, NodeMetadata.Status> toPortableNodeStatus, Supplier<Map<String, Location>> locationIndex, @Memoized Supplier<Set<? extends Image>> images, @Memoized Supplier<Set<? extends Hardware>> hardwares, GroupNamingConvention.Factory namingConvention) {
        this.toPortableNodeStatus = Preconditions.checkNotNull(toPortableNodeStatus, "toPortableNodeStatus");
        this.nodeNamingConvention = Preconditions.checkNotNull(namingConvention, "namingConvention").createWithoutPrefix();
        this.locationIndex = Preconditions.checkNotNull(locationIndex, "locationIndex");
        this.images = Preconditions.checkNotNull(images, "images");
        this.hardwares = Preconditions.checkNotNull(hardwares, "hardwares");
    }

    @Override
    public NodeMetadata apply(MachineInDatacenter machineInDatacenter) {
        Location zone = this.locationIndex.get().get(machineInDatacenter.getDatacenter());
        Preconditions.checkState(zone != null, "location %s not in locationIndex: %s", machineInDatacenter.getDatacenter(), this.locationIndex.get());
        Machine from = machineInDatacenter.get();
        NodeMetadataBuilder builder = new NodeMetadataBuilder();
        builder.id(machineInDatacenter.slashEncode());
        builder.providerId(from.getId());
        builder.name(from.getName());
        builder.hostname(from.getId());
        builder.location(zone);
        Map<String, String> metadataMap = Maps.filterKeys(from.getMetadata(), new Predicate<String>(){

            @Override
            public boolean apply(String input) {
                for (Metadata key : Metadata.values()) {
                    if (!key.key().equals(input)) continue;
                    return false;
                }
                return true;
            }
        });
        ComputeServiceUtils.addMetadataAndParseTagsFromCommaDelimitedValue(builder, metadataMap);
        builder.group(ComputeServiceUtils.groupFromMapOrName(metadataMap, from.getName(), this.nodeNamingConvention));
        builder.imageId(DatacenterAndName.fromDatacenterAndName(machineInDatacenter.getDatacenter(), from.getDatasetURN()).slashEncode());
        builder.operatingSystem(this.findOperatingSystemForMachineOrNull(machineInDatacenter));
        builder.hardware(this.findHardwareForMachineOrNull(machineInDatacenter));
        builder.status(this.toPortableNodeStatus.get((Object)from.getState()));
        builder.publicAddresses(Iterables.filter(from.getIps(), Predicates.not(InetAddresses2.IsPrivateIPAddress.INSTANCE)));
        builder.privateAddresses(Iterables.filter(from.getIps(), InetAddresses2.IsPrivateIPAddress.INSTANCE));
        return builder.build();
    }

    protected Hardware findHardwareForMachineOrNull(final MachineInDatacenter machineInDatacenter) {
        return Iterables.tryFind((Iterable)this.hardwares.get(), new Predicate<Hardware>(){

            @Override
            public boolean apply(Hardware input) {
                return input.getRam() == machineInDatacenter.get().getMemorySizeMb() && ComputeServiceUtils.getSpace(input) == (double)machineInDatacenter.get().getDiskSizeGb() && input.getLocation().getId().equals(machineInDatacenter.getDatacenter());
            }
        }).orNull();
    }

    protected OperatingSystem findOperatingSystemForMachineOrNull(MachineInDatacenter machineInDatacenter) {
        Image image = this.findObjectOfTypeForMachineOrNull(this.images.get(), "image", machineInDatacenter.get().getDatasetURN(), machineInDatacenter);
        return image != null ? image.getOperatingSystem() : null;
    }

    public <T extends ComputeMetadata> T findObjectOfTypeForMachineOrNull(Set<? extends T> supply, String type, final String objectId, final DatacenterAndId machineInDatacenter) {
        return (T)((ComputeMetadata)Iterables.tryFind(supply, new Predicate<T>(){

            @Override
            public boolean apply(T input) {
                return input.getId().equals(DatacenterAndId.fromDatacenterAndId(machineInDatacenter.getDatacenter(), objectId).slashEncode());
            }
        }).orNull());
    }
}

