/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.v2_0.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Set;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.v2_0.domain.Link;

public class Resource
implements Comparable<Resource> {
    private final String id;
    private final String name;
    private final Set<Link> links;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromResource(this);
    }

    @ConstructorProperties(value={"id", "name", "links"})
    protected Resource(String id, @Nullable String name, @Nullable Set<Link> links) {
        this.id = Preconditions.checkNotNull(id, "id");
        this.name = name;
        this.links = links == null ? ImmutableSet.of() : ImmutableSet.copyOf((Collection)Preconditions.checkNotNull(links, "links"));
    }

    public String getId() {
        return this.id;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    public Set<Link> getLinks() {
        return this.links;
    }

    public int hashCode() {
        return Objects.hashCode(this.id, this.name, this.links);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Resource that = (Resource)Resource.class.cast(obj);
        return Objects.equal(this.id, that.id) && Objects.equal(this.name, that.name) && Objects.equal(this.links, that.links);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper(this).add("id", this.id).add("name", this.name).add("links", this.links);
    }

    public String toString() {
        return this.string().toString();
    }

    @Override
    public int compareTo(Resource that) {
        if (that == null) {
            return 1;
        }
        if (this == that) {
            return 0;
        }
        return this.getId().compareTo(that.getId());
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String id;
        protected String name;
        protected Set<Link> links = ImmutableSet.of();

        protected abstract T self();

        public T id(String id) {
            this.id = id;
            return this.self();
        }

        public T name(String name) {
            this.name = name;
            return this.self();
        }

        public T links(Set<Link> links) {
            this.links = ImmutableSet.copyOf((Collection)Preconditions.checkNotNull(links, "links"));
            return this.self();
        }

        public T links(Link ... in) {
            return this.links(ImmutableSet.copyOf(in));
        }

        public Resource build() {
            return new Resource(this.id, this.name, this.links);
        }

        public T fromResource(Resource in) {
            return ((Builder)((Builder)this.id(in.getId())).name(in.getName())).links(in.getLinks());
        }
    }
}

