/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.compute.suppliers;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.aws.ec2.compute.config.ClusterCompute;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.ec2.compute.domain.EC2HardwareBuilder;
import org.jclouds.ec2.compute.suppliers.EC2HardwareSupplier;

@Singleton
public class AWSEC2HardwareSupplier
extends EC2HardwareSupplier {
    private final Set<String> ccAmis;

    @Inject
    public AWSEC2HardwareSupplier(@ClusterCompute Set<String> ccAmis) {
        this.ccAmis = ccAmis;
    }

    @Override
    public Set<? extends Hardware> get() {
        ImmutableSet.Builder sizes = ImmutableSet.builder();
        sizes.add(EC2HardwareBuilder.cc1_4xlarge().supportsImageIds(this.ccAmis).build());
        sizes.add(EC2HardwareBuilder.cg1_4xlarge().supportsImageIds(this.ccAmis).build());
        sizes.add(EC2HardwareBuilder.cc2_8xlarge().supportsImageIds(this.ccAmis).build());
        sizes.add(EC2HardwareBuilder.hi1_4xlarge().supportsImageIds(this.ccAmis).build());
        sizes.add(EC2HardwareBuilder.hs1_8xlarge().supportsImageIds(this.ccAmis).build());
        sizes.add(EC2HardwareBuilder.g2_2xlarge().supportsImageIds(this.ccAmis).build());
        sizes.add(EC2HardwareBuilder.t1_micro().build());
        sizes.add(EC2HardwareBuilder.t2_micro().build());
        sizes.add(EC2HardwareBuilder.t2_small().build());
        sizes.add(EC2HardwareBuilder.t2_medium().build());
        sizes.add(EC2HardwareBuilder.t2_large().build());
        sizes.add(EC2HardwareBuilder.c1_medium().build());
        sizes.add(EC2HardwareBuilder.c1_xlarge().build());
        sizes.add(EC2HardwareBuilder.c3_large().build());
        sizes.add(EC2HardwareBuilder.c3_xlarge().build());
        sizes.add(EC2HardwareBuilder.c3_2xlarge().build());
        sizes.add(EC2HardwareBuilder.c3_4xlarge().build());
        sizes.add(EC2HardwareBuilder.c3_8xlarge().build());
        sizes.add(EC2HardwareBuilder.c4_large().build());
        sizes.add(EC2HardwareBuilder.c4_xlarge().build());
        sizes.add(EC2HardwareBuilder.c4_2xlarge().build());
        sizes.add(EC2HardwareBuilder.c4_4xlarge().build());
        sizes.add(EC2HardwareBuilder.c4_8xlarge().build());
        sizes.add(EC2HardwareBuilder.i2_xlarge().build());
        sizes.add(EC2HardwareBuilder.i2_2xlarge().build());
        sizes.add(EC2HardwareBuilder.i2_4xlarge().build());
        sizes.add(EC2HardwareBuilder.i2_8xlarge().build());
        sizes.add(EC2HardwareBuilder.m1_large().build());
        sizes.add(EC2HardwareBuilder.m1_small().build());
        sizes.add(EC2HardwareBuilder.m1_medium().build());
        sizes.add(EC2HardwareBuilder.m1_xlarge().build());
        sizes.add(EC2HardwareBuilder.m2_xlarge().build());
        sizes.add(EC2HardwareBuilder.m2_2xlarge().build());
        sizes.add(EC2HardwareBuilder.m2_4xlarge().build());
        sizes.add(EC2HardwareBuilder.m3_medium().build());
        sizes.add(EC2HardwareBuilder.m3_large().build());
        sizes.add(EC2HardwareBuilder.m3_xlarge().build());
        sizes.add(EC2HardwareBuilder.m3_2xlarge().build());
        sizes.add(EC2HardwareBuilder.m4_large().build());
        sizes.add(EC2HardwareBuilder.m4_xlarge().build());
        sizes.add(EC2HardwareBuilder.m4_2xlarge().build());
        sizes.add(EC2HardwareBuilder.m4_4xlarge().build());
        sizes.add(EC2HardwareBuilder.m4_10xlarge().build());
        sizes.add(EC2HardwareBuilder.r3_large().build());
        sizes.add(EC2HardwareBuilder.r3_xlarge().build());
        sizes.add(EC2HardwareBuilder.r3_2xlarge().build());
        sizes.add(EC2HardwareBuilder.r3_4xlarge().build());
        sizes.add(EC2HardwareBuilder.r3_8xlarge().build());
        sizes.add(EC2HardwareBuilder.d2_xlarge().build());
        sizes.add(EC2HardwareBuilder.d2_2xlarge().build());
        sizes.add(EC2HardwareBuilder.d2_4xlarge().build());
        sizes.add(EC2HardwareBuilder.d2_8xlarge().build());
        return sizes.build();
    }
}

