/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.predicates.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import java.util.Set;
import javax.inject.Singleton;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.predicates.internal.RefreshAndDoubleCheckOnFailUnlessStatusInvalid;
import org.jclouds.compute.strategy.GetImageStrategy;

@Singleton
public class RefreshImageAndDoubleCheckOnFailUnlessStatusInvalid
extends RefreshAndDoubleCheckOnFailUnlessStatusInvalid<Image.Status, Image> {
    private final GetImageStrategy client;

    @Inject
    public RefreshImageAndDoubleCheckOnFailUnlessStatusInvalid(Image.Status intended, GetImageStrategy client) {
        this(intended, ImmutableSet.of(Image.Status.ERROR), client);
    }

    public RefreshImageAndDoubleCheckOnFailUnlessStatusInvalid(Image.Status intended, Set<Image.Status> invalids, GetImageStrategy client) {
        super(intended, invalids);
        this.client = Preconditions.checkNotNull(client, "client");
    }

    @Override
    protected Image refreshOrNull(Image resource) {
        if (resource == null || resource.getId() == null) {
            return null;
        }
        return this.client.getImage(resource.getId());
    }
}

