/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.aws.util.AWSUtils;
import org.jclouds.ec2.EC2Api;
import org.jclouds.ec2.domain.SecurityGroup;

@Singleton
public class EC2SecurityGroupIdFromName
implements Function<String, String> {
    protected EC2Api api;

    @Inject
    public EC2SecurityGroupIdFromName(EC2Api api) {
        this.api = Preconditions.checkNotNull(api, "api");
    }

    @Override
    public String apply(String input) {
        Preconditions.checkNotNull(input, "input");
        String[] parts = AWSUtils.parseHandle(input);
        String region = parts[0];
        String name = parts[1];
        return ((SecurityGroup)Iterables.getOnlyElement(this.api.getSecurityGroupApi().get().describeSecurityGroupsInRegion(region, name), null)).getId();
    }
}

