/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.scriptbuilder.statements.ssh;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import org.jclouds.scriptbuilder.domain.OsFamily;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.domain.StatementList;
import org.jclouds.scriptbuilder.domain.Statements;

public class InstallRSAPrivateKey
implements Statement {
    private final String sshDir;
    private final String privateKey;

    public InstallRSAPrivateKey(String privateKey) {
        this("~/.ssh", privateKey);
    }

    public InstallRSAPrivateKey(String sshDir, String privateKey) {
        this.sshDir = Preconditions.checkNotNull(sshDir, "sshDir");
        this.privateKey = Preconditions.checkNotNull(privateKey, "privateKey");
    }

    @Override
    public Iterable<String> functionDependencies(OsFamily family) {
        return ImmutableList.of();
    }

    @Override
    public String render(OsFamily family) {
        Preconditions.checkNotNull(family, "family");
        if (family == OsFamily.WINDOWS) {
            throw new UnsupportedOperationException("windows not yet implemented");
        }
        ImmutableList.Builder statements = ImmutableList.builder();
        statements.add(Statements.exec("{md} " + this.sshDir));
        String idRsa = this.sshDir + "{fs}id_rsa";
        statements.add(Statements.exec("{rm} " + idRsa));
        statements.add(Statements.appendFile(idRsa, Splitter.on('\n').split(this.privateKey)));
        statements.add(Statements.exec("chmod 600 " + idRsa));
        return new StatementList(statements.build()).render(family);
    }
}

