/*
 * Decompiled with CFR 0.152.
 */
package COM.claymoresystems.provider.test;

import COM.claymoresystems.crypto.Blindable;
import COM.claymoresystems.provider.ClaymoreProvider;
import COM.claymoresystems.util.Bench;
import COM.claymoresystems.util.Util;
import cryptix.provider.Cryptix;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import xjava.security.Cipher;
import xjava.security.interfaces.CryptixRSAPublicKey;

class RSATest
extends Bench {
    private static final byte[] testString = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8};

    RSATest() {
    }

    public static void main(String[] args) throws NoSuchAlgorithmException {
        int iter = 1;
        Security.addProvider(new Cryptix());
        Security.addProvider(new ClaymoreProvider());
        Cipher rsaTmp = Cipher.getInstance("RSABlind");
        if (args.length != 0) {
            if (args.length == 1) {
                iter = Integer.parseInt(args[0]);
            } else {
                throw new InternalError("Bad arguments");
            }
        }
        try {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
            keyGen.initialize(1024, new SecureRandom());
            KeyPair pair = keyGen.generateKeyPair();
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            md.update(testString);
            PrivateKey priv = pair.getPrivate();
            CryptixRSAPublicKey pubk = (CryptixRSAPublicKey)pair.getPublic();
            byte[] digest = md.digest();
            int i = 0;
            while (i < iter) {
                Signature rsaSign = Signature.getInstance("RawRSA");
                Signature rsaVerify = Signature.getInstance("RawRSA");
                rsaSign.initSign(priv);
                ((Blindable)((Object)rsaSign)).setBlindingInfo(new SecureRandom(), pubk);
                rsaSign.update(digest);
                byte[] sig = rsaSign.sign();
                Util.xdump("signature", sig);
                PublicKey pub = pair.getPublic();
                rsaVerify.initVerify(pub);
                rsaVerify.update(digest);
                boolean verifies = rsaVerify.verify(sig);
                if (verifies) {
                    System.out.println("Verifies with our implementation");
                } else {
                    System.out.println("Failed our verify. (WRONG!)");
                }
                rsaVerify = Signature.getInstance("RawRSA");
                digest[0] = (byte)(digest[0] + 1);
                rsaVerify.initVerify(pub);
                rsaVerify.update(digest);
                verifies = rsaVerify.verify(sig);
                if (verifies) {
                    System.out.println("Bad signature verifies (WRONG!)");
                } else {
                    System.out.println("Bad signature doesn't verify (OK)");
                }
                ++i;
            }
        }
        catch (Exception e) {
            System.err.println("Caught exception " + e.toString());
            e.printStackTrace(System.out);
        }
        Bench.dump();
    }
}

