/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.connectors.conn.util;

import es.bsc.compss.connectors.ConnectorException;
import es.bsc.conn.Connector;
import es.bsc.conn.exceptions.ConnException;
import es.bsc.conn.types.HardwareDescription;
import es.bsc.conn.types.SoftwareDescription;
import es.bsc.conn.types.VirtualResource;
import java.util.Map;

public class ConnectorProxy {
    private static final String ERROR_NO_CONN = "ERROR: Connector specific implementation is null";
    private final Connector connector;

    public ConnectorProxy(Connector conn) throws ConnectorException {
        if (conn == null) {
            throw new ConnectorException(ERROR_NO_CONN);
        }
        this.connector = conn;
    }

    public Object create(String name, HardwareDescription hardwareDescription, SoftwareDescription softwareDescription, Map<String, String> properties) throws ConnectorException {
        Object created;
        if (this.connector == null) {
            throw new ConnectorException(ERROR_NO_CONN);
        }
        try {
            created = this.connector.create(name, hardwareDescription, softwareDescription, properties);
        }
        catch (ConnException ce) {
            throw new ConnectorException((Exception)ce);
        }
        return created;
    }

    public void destroy(Object id) throws ConnectorException {
        if (this.connector == null) {
            throw new ConnectorException(ERROR_NO_CONN);
        }
        this.connector.destroy(id);
    }

    public VirtualResource waitUntilCreation(Object id) throws ConnectorException {
        VirtualResource vr;
        if (this.connector == null) {
            throw new ConnectorException(ERROR_NO_CONN);
        }
        try {
            vr = this.connector.waitUntilCreation(id);
        }
        catch (ConnException ce) {
            throw new ConnectorException((Exception)ce);
        }
        return vr;
    }

    public float getPriceSlot(VirtualResource vr, float defaultPrice) {
        if (this.connector == null) {
            return defaultPrice;
        }
        return this.connector.getPriceSlot(vr);
    }

    public long getTimeSlot(long defaultLength) {
        if (this.connector == null) {
            return defaultLength;
        }
        return this.connector.getTimeSlot();
    }

    public void close() {
        this.connector.close();
    }
}

