/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.v2_0.domain;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.util.Iterator;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.http.utils.Queries;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.v2_0.domain.Link;
import org.jclouds.openstack.v2_0.options.PaginationOptions;

public class PaginatedCollection<T>
extends IterableWithMarker<T> {
    private final Iterable<T> resources;
    private final Iterable<Link> links;
    private final Integer totalEntries;

    protected PaginatedCollection(@Nullable Iterable<T> resources, @Nullable Iterable<Link> links, @Nullable Integer totalEntries) {
        this.resources = resources != null ? resources : ImmutableSet.of();
        this.links = links != null ? links : ImmutableSet.of();
        this.totalEntries = totalEntries;
    }

    protected PaginatedCollection(Iterable<T> resources, Iterable<Link> links) {
        this(resources, links, null);
    }

    @Override
    public Iterator<T> iterator() {
        return this.resources.iterator();
    }

    public Iterable<Link> getLinks() {
        return this.links;
    }

    public Optional<Integer> getTotalEntries() {
        return Optional.fromNullable(this.totalEntries);
    }

    public PaginationOptions nextPaginationOptions() {
        return (PaginationOptions)PaginationOptions.class.cast(this.nextMarker().get());
    }

    @Override
    public Optional<Object> nextMarker() {
        for (Link link : this.getLinks()) {
            if (Link.Relation.NEXT != link.getRelation()) continue;
            return Optional.of(this.toPaginationOptions(link));
        }
        return Optional.absent();
    }

    private Object toPaginationOptions(Link link) {
        Multimap<String, String> queryParams = Queries.queryParser().apply(link.getHref().getRawQuery());
        PaginationOptions paginationOptions = PaginationOptions.Builder.queryParameters(queryParams);
        return paginationOptions;
    }
}

