/*
 * Decompiled with CFR 0.152.
 */
package org.gridlab.gat.io;

import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.gridlab.gat.GAT;
import org.gridlab.gat.GATContext;
import org.gridlab.gat.GATIOException;
import org.gridlab.gat.GATInvocationException;
import org.gridlab.gat.URI;
import org.gridlab.gat.advert.Advertisable;
import org.gridlab.gat.io.FileInterface;
import org.gridlab.gat.io.attributes.FileAttributeView;
import org.gridlab.gat.monitoring.Metric;
import org.gridlab.gat.monitoring.MetricDefinition;
import org.gridlab.gat.monitoring.MetricEvent;
import org.gridlab.gat.monitoring.MetricListener;
import org.gridlab.gat.monitoring.Monitorable;

public class File
extends java.io.File
implements Monitorable,
Advertisable,
Serializable {
    FileInterface f;

    public File(FileInterface f) {
        super("dummy");
        this.f = f;
    }

    public void copy(URI loc) throws GATInvocationException {
        this.f.copy(loc);
    }

    public FileInterface getFileInterface() {
        return this.f;
    }

    public void move(URI location) throws GATInvocationException {
        this.f.move(location);
    }

    public void recursivelyDeleteDirectory() throws GATInvocationException {
        this.f.recursivelyDeleteDirectory();
    }

    @Override
    public boolean canRead() {
        try {
            return this.f.canRead();
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean canWrite() {
        try {
            return this.f.canWrite();
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public int compareTo(File pathname) {
        return this.f.compareTo(pathname);
    }

    @Override
    public boolean createNewFile() throws IOException {
        try {
            return this.f.createNewFile();
        }
        catch (GATInvocationException e) {
            throw new GATIOException(e);
        }
    }

    @Override
    public boolean delete() {
        try {
            return this.f.delete();
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void deleteOnExit() {
        Runtime.getRuntime().addShutdownHook(new DeleteHook(this));
    }

    @Override
    public boolean equals(Object obj) {
        return this.f.equals(obj);
    }

    @Override
    public boolean exists() {
        try {
            return this.f.exists();
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public java.io.File getAbsoluteFile() {
        try {
            return this.f.getAbsoluteFile();
        }
        catch (GATInvocationException e) {
            throw new Error("Got exception", e);
        }
    }

    @Override
    public String getAbsolutePath() {
        try {
            return this.f.getAbsolutePath();
        }
        catch (GATInvocationException e) {
            throw new Error("Got exception", e);
        }
    }

    @Override
    public java.io.File getCanonicalFile() throws IOException {
        try {
            return this.f.getCanonicalFile();
        }
        catch (GATInvocationException e) {
            throw new GATIOException(e);
        }
    }

    @Override
    public String getCanonicalPath() throws IOException {
        try {
            return this.f.getCanonicalPath();
        }
        catch (GATInvocationException e) {
            throw new GATIOException(e);
        }
    }

    public <V extends FileAttributeView> V getFileAttributeView(Class<V> type, boolean followSymbLinks) {
        try {
            return this.f.getFileAttributeView(type, followSymbLinks);
        }
        catch (GATInvocationException e) {
            throw new Error("Got exception", e);
        }
    }

    @Override
    public String getName() {
        try {
            return this.f.getName();
        }
        catch (GATInvocationException e) {
            throw new Error("Got exception", e);
        }
    }

    @Override
    public String getParent() {
        try {
            return this.f.getParent();
        }
        catch (GATInvocationException e) {
            throw new Error("Got exception", e);
        }
    }

    @Override
    public java.io.File getParentFile() {
        try {
            return this.f.getParentFile();
        }
        catch (GATInvocationException e) {
            throw new Error("Got exception", e);
        }
    }

    @Override
    public String getPath() {
        try {
            return this.f.getPath();
        }
        catch (GATInvocationException e) {
            throw new Error("Got exception", e);
        }
    }

    @Override
    public int hashCode() {
        try {
            return this.f.hashCode();
        }
        catch (Exception e) {
            return 0;
        }
    }

    @Override
    public boolean isAbsolute() {
        return this.f.isAbsolute();
    }

    @Override
    public boolean isDirectory() {
        try {
            return this.f.isDirectory();
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean isFile() {
        try {
            return this.f.isFile();
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean isHidden() {
        try {
            return this.f.isHidden();
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public long lastModified() {
        try {
            return this.f.lastModified();
        }
        catch (Exception e) {
            return 0L;
        }
    }

    @Override
    public long length() {
        try {
            return this.f.length();
        }
        catch (Exception e) {
            return -1L;
        }
    }

    @Override
    public String[] list() {
        try {
            return this.f.list();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public String[] list(FilenameFilter filter) {
        try {
            return this.f.list(filter);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public java.io.File[] listFiles() {
        try {
            return this.f.listFiles();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public java.io.File[] listFiles(FileFilter filter) {
        try {
            return this.f.listFiles(filter);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public java.io.File[] listFiles(FilenameFilter filter) {
        try {
            return this.f.listFiles(filter);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public boolean mkdir() {
        try {
            return this.f.mkdir();
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean mkdirs() {
        try {
            return this.f.mkdirs();
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean renameTo(java.io.File dest) {
        try {
            File a = (File)dest;
            return this.f.renameTo(a);
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean setLastModified(long time) {
        try {
            return this.f.setLastModified(time);
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean setReadOnly() {
        try {
            return this.f.setReadOnly();
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public String toString() {
        return this.f.toString();
    }

    @Override
    public java.net.URI toURI() {
        throw new Error("please use toGATURI to retreive a file's URI.");
    }

    public URI toGATURI() {
        return this.f.toURI();
    }

    @Override
    public URL toURL() throws MalformedURLException {
        return this.f.toURI().toURL();
    }

    @Override
    public String marshal() {
        return this.f.marshal();
    }

    @Override
    public void addMetricListener(MetricListener metricListener, Metric metric) throws GATInvocationException {
        this.f.addMetricListener(metricListener, metric);
    }

    @Override
    public MetricEvent getMeasurement(Metric metric) throws GATInvocationException {
        return this.f.getMeasurement(metric);
    }

    @Override
    public MetricDefinition getMetricDefinitionByName(String name) throws GATInvocationException {
        return this.f.getMetricDefinitionByName(name);
    }

    @Override
    public List<MetricDefinition> getMetricDefinitions() throws GATInvocationException {
        return this.f.getMetricDefinitions();
    }

    @Override
    public void removeMetricListener(MetricListener metricListener, Metric metric) throws GATInvocationException {
        this.f.removeMetricListener(metricListener, metric);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        URI u = (URI)stream.readObject();
        GATContext c = (GATContext)stream.readObject();
        try {
            File newFile = GAT.createFile(c, u);
            this.f = newFile.f;
        }
        catch (Exception e) {
            throw new Error("Could not create File object: " + u);
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeObject(this.toGATURI());
        stream.writeObject(this.getFileInterface().getGATContext());
    }

    private static class DeleteHook
    extends Thread {
        File f;

        DeleteHook(File f) {
            this.f = f;
        }

        @Override
        public void run() {
            try {
                this.f.delete();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

