/*
 * Decompiled with CFR 0.152.
 */
package org.gridlab.gat.resources;

import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gridlab.gat.GAT;
import org.gridlab.gat.GATContext;
import org.gridlab.gat.GATInvocationException;
import org.gridlab.gat.GATObjectCreationException;
import org.gridlab.gat.URI;
import org.gridlab.gat.io.File;

public class SoftwareDescription
implements Serializable {
    public static final String DIRECTORY = "directory";
    public static final String HOST_COUNT = "host.count";
    public static final String TIME_MAX = "time.max";
    public static final String WALLTIME_MAX = "walltime.max";
    public static final String CPUTIME_MAX = "cputime.max";
    public static final String JOB_TYPE = "job.type";
    public static final String JOB_QUEUE = "job.queue";
    public static final String PROJECT = "project";
    public static final String DRY_RUN = "dry.run";
    public static final String MEMORY_MIN = "memory.min";
    public static final String MEMORY_MAX = "memory.max";
    public static final String SAVE_STATE = "save.state";
    public static final String RESTART = "restart";
    public static final String STOP_ON_EXIT = "job.stop.on.exit";
    public static final String SANDBOX_ROOT = "sandbox.root";
    public static final String SANDBOX_USEROOT = "sandbox.useroot";
    public static final String SANDBOX_DELETE = "sandbox.delete";
    public static final String SANDBOX_PRESTAGE_STDIN = "sandbox.prestage.stdin";
    public static final String SANDBOX_POSTSTAGE_STDOUT = "sandbox.poststage.stdout";
    public static final String SANDBOX_POSTSTAGE_STDERR = "sandbox.poststage.stderr";
    private String executable;
    private String[] arguments;
    private HashMap<String, Object> environment;
    private File stdinFile;
    private File stdoutFile;
    private File stderrFile;
    private HashMap<File, File> preStagedFiles;
    private HashMap<File, File> postStagedFiles;
    private ArrayList<File> deletedFiles;
    private ArrayList<File> wipedFiles;
    private HashMap<String, Object> attributes;
    private boolean deletePreStaged;
    private boolean deletePostStaged;
    private boolean wipePreStaged;
    private boolean wipePostStaged;
    private boolean streamingStderr = false;
    private boolean streamingStdout = false;
    private boolean streamingStdin = false;
    protected boolean toWrapper = false;

    public SoftwareDescription() {
        this.attributes = new HashMap();
        this.preStagedFiles = new HashMap();
        this.postStagedFiles = new HashMap();
        this.deletedFiles = new ArrayList();
        this.wipedFiles = new ArrayList();
    }

    SoftwareDescription(SoftwareDescription sd) {
        this.executable = sd.executable;
        this.stdinFile = sd.stdinFile;
        this.stdoutFile = sd.stdoutFile;
        this.stderrFile = sd.stderrFile;
        this.streamingStderr = sd.streamingStderr;
        this.streamingStdin = sd.streamingStdin;
        this.streamingStdout = sd.streamingStdout;
        this.preStagedFiles = sd.preStagedFiles;
        this.postStagedFiles = sd.postStagedFiles;
        this.deletedFiles = sd.deletedFiles;
        this.wipedFiles = sd.wipedFiles;
        this.deletePostStaged = sd.deletePostStaged;
        this.deletePreStaged = sd.deletePreStaged;
        this.wipePostStaged = sd.wipePostStaged;
        this.wipePreStaged = sd.wipePreStaged;
        if (sd.arguments != null) {
            this.arguments = new String[sd.arguments.length];
            System.arraycopy(sd.arguments, 0, this.arguments, 0, this.arguments.length);
        }
        if (sd.attributes != null) {
            this.attributes = (HashMap)sd.attributes.clone();
        }
        if (sd.environment != null) {
            this.environment = (HashMap)sd.environment.clone();
        }
    }

    public SoftwareDescription(String jsdlString) {
    }

    public SoftwareDescription(Map<String, Object> attributes) {
        this.attributes = new HashMap<String, Object>(attributes);
        this.executable = (String)attributes.get("executable");
        this.arguments = (String[])attributes.get("arguments");
        this.checkArguments();
        this.environment = new HashMap((Map)attributes.get("environment"));
        this.stdinFile = (File)attributes.get("stdin");
        this.stdoutFile = (File)attributes.get("stdout");
        this.stderrFile = (File)attributes.get("stderr");
    }

    private void checkArguments() {
        if (this.arguments != null) {
            for (int i = 0; i < this.arguments.length; ++i) {
                if (this.arguments[i] != null) continue;
                throw new NullPointerException("Argument " + i + " is null");
            }
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof SoftwareDescription)) {
            return false;
        }
        SoftwareDescription other = (SoftwareDescription)o;
        return other.attributes.equals(this.attributes);
    }

    public int hashCode() {
        return this.attributes.hashCode();
    }

    public String[] getArguments() {
        return this.arguments;
    }

    public void setArguments(String ... arguments) {
        this.arguments = arguments;
        this.checkArguments();
    }

    public Map<String, Object> getAttributes() {
        Set<String> s = this.attributes.keySet();
        for (String key : s) {
            Object tmp = this.attributes.get(key);
            if (!(tmp instanceof String)) continue;
            String val = (String)tmp;
            if (key.equalsIgnoreCase(TIME_MAX)) {
                this.attributes.put(key, new Long(val));
                continue;
            }
            if (key.equalsIgnoreCase(WALLTIME_MAX)) {
                this.attributes.put(key, new Long(val));
                continue;
            }
            if (key.equalsIgnoreCase(CPUTIME_MAX)) {
                this.attributes.put(key, new Long(val));
                continue;
            }
            if (key.equalsIgnoreCase(DRY_RUN)) {
                this.attributes.put(key, new Boolean(val));
                continue;
            }
            if (key.equalsIgnoreCase(MEMORY_MIN)) {
                this.attributes.put(key, new Integer(val));
                continue;
            }
            if (key.equalsIgnoreCase(MEMORY_MAX)) {
                this.attributes.put(key, new Integer(val));
                continue;
            }
            if (!key.equalsIgnoreCase(SAVE_STATE)) continue;
            this.attributes.put(key, new Boolean(val));
        }
        return this.attributes;
    }

    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = new HashMap<String, Object>(attributes);
    }

    public void addAttribute(String key, Object value) {
        this.attributes.put(key, value);
    }

    public Object removeAttribute(String key) {
        return this.attributes.remove(key);
    }

    public Map<String, Object> getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Map<String, Object> environment) {
        this.environment = new HashMap<String, Object>(environment);
    }

    public String getExecutable() {
        return this.executable;
    }

    public void setExecutable(String executable) {
        this.executable = executable;
    }

    public Map<File, File> getPreStaged() {
        return this.preStagedFiles;
    }

    public void setPreStaged(File ... files) {
        this.preStagedFiles = new HashMap();
        for (int i = 0; i < files.length; ++i) {
            this.addPreStagedFile(files[i]);
        }
    }

    public void addPreStagedFile(File src) {
        this.addPreStagedFile(src, null);
    }

    public void addPreStagedFile(File src, File dest) {
        if (src == null) {
            throw new NullPointerException("the source file cannot be null when adding a preStaged file");
        }
        this.preStagedFiles.put(src, dest);
    }

    public Map<File, File> getPostStaged() {
        return this.postStagedFiles;
    }

    public void setPostStaged(File ... files) {
        this.postStagedFiles = new HashMap();
        for (int i = 0; i < files.length; ++i) {
            this.addPostStagedFile(files[i]);
        }
    }

    public void addPostStagedFile(File src) {
        this.addPostStagedFile(src, null);
    }

    public void addPostStagedFile(File src, File dest) {
        if (src == null) {
            throw new NullPointerException("the destination file cannot be null when adding a postStaged file");
        }
        this.postStagedFiles.put(src, dest);
    }

    public List<File> getDeletedFiles() {
        return this.deletedFiles;
    }

    public void addDeletedFile(File file) {
        if (file == null) {
            throw new NullPointerException("addDeletedFile(): argument is null");
        }
        this.deletedFiles.add(file);
    }

    public List<File> getWipedFiles() {
        return this.wipedFiles;
    }

    public void addWipedFile(File file) {
        if (file == null) {
            throw new NullPointerException("addWipedFile(): argument is null");
        }
        this.wipedFiles.add(file);
    }

    public File getStderr() {
        return this.stderrFile;
    }

    public void enableStreamingStderr(boolean enabled) {
        this.streamingStderr = enabled;
    }

    public boolean streamingStderrEnabled() {
        return this.streamingStderr;
    }

    public void enableStreamingStdout(boolean enabled) {
        this.streamingStdout = enabled;
    }

    public boolean streamingStdoutEnabled() {
        return this.streamingStdout;
    }

    public void enableStreamingStdin(boolean enabled) {
        this.streamingStdin = enabled;
    }

    public boolean streamingStdinEnabled() {
        return this.streamingStdin;
    }

    public void setStderr(File stderr) {
        this.stderrFile = stderr;
    }

    public File getStdin() {
        return this.stdinFile;
    }

    public void setStdin(File stdin) {
        this.stdinFile = stdin;
    }

    public File getStdout() {
        return this.stdoutFile;
    }

    public void setStdout(File stdout) {
        this.stdoutFile = stdout;
    }

    public String toString() {
        String res = "SoftwareDescription(";
        res = res + "executable: " + this.executable;
        res = res + ", arguments: {";
        if (this.getArguments() != null) {
            for (String argument : this.getArguments()) {
                res = res + argument + ",";
            }
        } else {
            res = res + "null";
        }
        res = res + "}";
        res = res + ", stdin: " + (this.stdinFile == null ? "null" : this.stdinFile.toString());
        res = res + ", stdout: " + (this.stdoutFile == null ? "null" : this.stdoutFile.toString());
        res = res + ", stderr: " + (this.stderrFile == null ? "null" : this.stderrFile.toString());
        res = res + ", environment: " + (this.environment == null ? "null" : this.environment.toString());
        res = res + ", preStaged: " + (this.preStagedFiles == null ? "null" : this.preStagedFiles.toString());
        res = res + ", postStaged: " + (this.postStagedFiles == null ? "null" : this.postStagedFiles.toString());
        res = res + ", attributes: " + (this.attributes == null ? "null" : this.attributes.toString());
        res = res + ")";
        return res;
    }

    public boolean deletePostStaged() {
        return this.deletePostStaged;
    }

    public void setDeletePostStaged(boolean deletePostStaged) {
        this.deletePostStaged = deletePostStaged;
    }

    public boolean deletePreStaged() {
        return this.deletePreStaged;
    }

    public void setDeletePreStaged(boolean deletePreStaged) {
        this.deletePreStaged = deletePreStaged;
    }

    public boolean wipePostStaged() {
        return this.wipePostStaged;
    }

    public void setWipePostStaged(boolean wipePostStaged) {
        this.wipePostStaged = wipePostStaged;
    }

    public boolean wipePreStaged() {
        return this.wipePreStaged;
    }

    public void setWipePreStaged(boolean wipePreStaged) {
        this.wipePreStaged = wipePreStaged;
    }

    public int getIntAttribute(String name, int defaultVal) {
        Object val = this.attributes.get(name);
        if (val == null) {
            return defaultVal;
        }
        if (val instanceof Integer) {
            Integer ival = (Integer)val;
            return ival;
        }
        if (val instanceof String) {
            return Integer.parseInt((String)val);
        }
        throw new Error("illegal int value: " + val);
    }

    public long getLongAttribute(String name, long defaultVal) {
        Object val = this.attributes.get(name);
        if (val == null) {
            return defaultVal;
        }
        if (val instanceof Long) {
            Long lval = (Long)val;
            return lval;
        }
        if (val instanceof String) {
            return Long.parseLong((String)val);
        }
        throw new Error("illegal long value: " + val);
    }

    public String getStringAttribute(String name, String defaultVal) {
        String val = (String)this.attributes.get(name);
        if (val == null) {
            return defaultVal;
        }
        return val;
    }

    public Object getObjectAttribute(String name) {
        return this.attributes.get(name);
    }

    public boolean getBooleanAttribute(String name, boolean defaultVal) {
        Object val = this.attributes.get(name);
        if (val == null) {
            return defaultVal;
        }
        if (val instanceof Boolean) {
            return (Boolean)val;
        }
        if (val instanceof String) {
            return ((String)val).equalsIgnoreCase("true");
        }
        throw new Error("illegal type for boolean attribute: " + name + ": " + val);
    }

    public void toWrapper(GATContext context, String wrapperFileName, String exitValueFileName) throws GATInvocationException {
        String newline = System.getProperty("line.separator");
        try {
            StringBuffer sb = new StringBuffer();
            sb.append("#!/bin/sh");
            sb.append(newline);
            sb.append("# wrapper script for " + this.executable);
            sb.append(newline);
            sb.append("typeset int rc");
            sb.append(newline);
            sb.append("rcfile=" + exitValueFileName);
            sb.append(newline);
            sb.append("cmd=\"");
            sb.append(this.executable);
            String[] args = this.getArguments();
            if (args != null) {
                for (String argument : args) {
                    sb.append(" ");
                    sb.append(argument);
                }
            }
            sb.append("\"");
            sb.append(newline);
            sb.append("$cmd");
            sb.append(newline);
            sb.append("rc=$?");
            sb.append(newline);
            sb.append("echo $rc > $rcfile");
            sb.append(newline);
            sb.append("exit $rc");
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(wrapperFileName));
            bufferedWriter.write(sb.toString());
            bufferedWriter.flush();
            bufferedWriter.close();
        }
        catch (FileNotFoundException e) {
            throw new GATInvocationException("SoftwareDescription toWrapper", e);
        }
        catch (IOException e) {
            throw new GATInvocationException("SoftwareDescription toWrapper", e);
        }
        this.executable = "/bin/sh";
        this.arguments = new String[]{wrapperFileName};
        try {
            this.addPreStagedFile(GAT.createFile(context, new URI(wrapperFileName)));
        }
        catch (GATObjectCreationException e) {
            throw new GATInvocationException("SoftwareDescription toWrapper", e);
        }
        catch (URISyntaxException e) {
            throw new GATInvocationException("SoftwareDescription toWrapper", e);
        }
        try {
            this.addPostStagedFile(GAT.createFile(context, new URI(exitValueFileName)));
        }
        catch (GATObjectCreationException e) {
            throw new GATInvocationException("SoftwareDescription toWrapper", e);
        }
        catch (URISyntaxException e) {
            throw new GATInvocationException("SoftwareDescription toWrapper", e);
        }
        this.toWrapper = true;
    }

    public Object clone() {
        return new SoftwareDescription(this);
    }

    public String getJSDL() {
        return null;
    }
}

