/*
 * Decompiled with CFR 0.152.
 */
package org.gridlab.gat.engine.util;

import java.util.HashMap;
import java.util.Iterator;
import org.gridlab.gat.GATInvocationException;
import org.gridlab.gat.engine.util.ScheduledExecutor;
import org.gridlab.gat.io.File;

public class FileWaiter
implements Runnable {
    private final File directory;
    private static HashMap<String, FileWaiter> scanners = new HashMap();
    private final HashMap<String, Entry> entries = new HashMap();
    private boolean stopped;

    public static synchronized FileWaiter createFileWaiter(File directory) throws GATInvocationException {
        String name = directory.toGATURI().toString();
        FileWaiter w = scanners.get(name);
        if (w == null) {
            w = new FileWaiter(directory);
            scanners.put(name, w);
        }
        return w;
    }

    public static synchronized void end() {
        for (FileWaiter w : scanners.values()) {
            ScheduledExecutor.remove(w);
            w.stop();
        }
        scanners.clear();
    }

    private FileWaiter(File directory) throws GATInvocationException {
        if (!directory.isDirectory()) {
            throw new GATInvocationException("Not a directory");
        }
        this.directory = directory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.stopped) {
            FileWaiter fileWaiter = this;
            synchronized (fileWaiter) {
                Iterator<Entry> iterator = this.entries.values().iterator();
                while (iterator.hasNext()) {
                    Entry e;
                    Entry entry = e = iterator.next();
                    synchronized (entry) {
                        e.notifyAll();
                    }
                }
                this.entries.clear();
            }
            ScheduledExecutor.remove(this);
            return;
        }
        String[] list = this.directory.list();
        if (list != null) {
            for (String s : list) {
                Entry e;
                Object object = this;
                synchronized (object) {
                    e = this.entries.get(s);
                }
                if (e == null) continue;
                object = e;
                synchronized (object) {
                    e.notifyAll();
                }
            }
        }
    }

    private synchronized void stop() {
        this.stopped = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitFor(String file) {
        Entry e = new Entry(file);
        Object object = this;
        synchronized (object) {
            if (this.stopped) {
                return;
            }
            if (this.entries.size() == 0) {
                ScheduledExecutor.schedule(this, 1000L, 1000L);
            }
            this.entries.put(file, e);
        }
        object = e;
        synchronized (object) {
            try {
                e.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        object = this;
        synchronized (object) {
            this.entries.remove(file);
            if (this.entries.size() == 0) {
                ScheduledExecutor.remove(this);
            }
        }
    }

    private static class Entry {
        private String file;

        public Entry(String file) {
            this.file = file;
        }

        public boolean equals(Object e) {
            if (!(e instanceof Entry)) {
                return false;
            }
            Entry entry = (Entry)e;
            return entry.file.equals(this.file);
        }

        public int hashCode() {
            return this.file.hashCode();
        }
    }
}

