/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.nio;

import es.bsc.compss.nio.NIOParam;
import es.bsc.compss.types.implementations.AbstractMethodImplementation;
import es.bsc.compss.types.job.Job;
import es.bsc.compss.types.resources.MethodResourceDescription;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class NIOTask
implements Externalizable {
    private String lang;
    private boolean workerDebug;
    private AbstractMethodImplementation impl;
    private boolean hasTarget;
    private boolean hasReturn;
    private LinkedList<NIOParam> params;
    private MethodResourceDescription reqs;
    private List<String> slaveWorkersNodeNames;
    private int taskId;
    private int taskType;
    private int jobId;
    private Job.JobHistory hist;
    private int transferGroupId;
    private int numParams;
    private int numReturns;

    public NIOTask() {
    }

    public NIOTask(String lang, boolean workerDebug, AbstractMethodImplementation impl, boolean hasTarget, boolean hasReturn, int numReturns, LinkedList<NIOParam> params, int numParams, MethodResourceDescription reqs, List<String> slaveWorkersNodeNames, int taskId, int taskType, int jobId, Job.JobHistory hist, int transferGroupId) {
        this.lang = lang;
        this.workerDebug = workerDebug;
        this.impl = impl;
        this.hasTarget = hasTarget;
        this.hasReturn = hasReturn;
        this.numReturns = numReturns;
        this.params = params;
        this.reqs = reqs;
        this.slaveWorkersNodeNames = slaveWorkersNodeNames;
        this.taskType = taskType;
        this.taskId = taskId;
        this.jobId = jobId;
        this.hist = hist;
        this.numParams = numParams;
        this.transferGroupId = transferGroupId;
    }

    public String getLang() {
        return this.lang;
    }

    public boolean isWorkerDebug() {
        return this.workerDebug;
    }

    public AbstractMethodImplementation.MethodType getMethodType() {
        return this.impl.getMethodType();
    }

    public String getMethodDefinition() {
        return this.impl.getMethodDefinition();
    }

    public AbstractMethodImplementation getMethodImplementation() {
        return this.impl;
    }

    public boolean hasTarget() {
        return this.hasTarget;
    }

    public boolean hasReturn() {
        return this.hasReturn;
    }

    public int getNumReturns() {
        return this.numReturns;
    }

    public int getNumParams() {
        return this.numParams;
    }

    public LinkedList<NIOParam> getParams() {
        return this.params;
    }

    public int getTaskId() {
        return this.taskId;
    }

    public int getTaskType() {
        return this.taskType;
    }

    public int getJobId() {
        return this.jobId;
    }

    public Job.JobHistory getHist() {
        return this.hist;
    }

    public int getTransferGroupId() {
        return this.transferGroupId;
    }

    public MethodResourceDescription getResourceDescription() {
        return this.reqs;
    }

    public List<String> getSlaveWorkersNodeNames() {
        return this.slaveWorkersNodeNames;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.lang = (String)in.readObject();
        this.workerDebug = in.readBoolean();
        this.impl = (AbstractMethodImplementation)in.readObject();
        this.hasTarget = in.readBoolean();
        this.hasReturn = in.readBoolean();
        this.numReturns = in.readInt();
        this.params = (LinkedList)in.readObject();
        this.reqs = (MethodResourceDescription)in.readObject();
        this.slaveWorkersNodeNames = (ArrayList)in.readObject();
        this.taskType = in.readInt();
        this.taskId = in.readInt();
        this.jobId = in.readInt();
        this.hist = (Job.JobHistory)((Object)in.readObject());
        this.numParams = in.readInt();
        this.transferGroupId = in.readInt();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.lang);
        out.writeBoolean(this.workerDebug);
        out.writeObject(this.impl);
        out.writeBoolean(this.hasTarget);
        out.writeBoolean(this.hasReturn);
        out.writeInt(this.numReturns);
        out.writeObject(this.params);
        out.writeObject(this.reqs);
        out.writeObject(this.slaveWorkersNodeNames);
        out.writeInt(this.taskType);
        out.writeInt(this.taskId);
        out.writeInt(this.jobId);
        out.writeObject((Object)this.hist);
        out.writeInt(this.numParams);
        out.writeInt(this.transferGroupId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[TASK ");
        sb.append("[LANG= ").append(this.lang).append("]");
        sb.append("[TASK TYPE= ").append(this.taskType).append("]");
        sb.append("[TASK ID= ").append(this.taskId).append("]");
        sb.append("[JOB ID= ").append(this.jobId).append("]");
        sb.append("[HISTORY= ").append((Object)this.hist).append("]");
        sb.append("[IMPLEMENTATION= ").append(this.impl.getMethodDefinition()).append("]");
        sb.append(" [PARAMS ");
        for (NIOParam param : this.params) {
            sb.append(param);
        }
        sb.append("]");
        sb.append("[REQUIREMENTS= ").append(this.reqs).append("]");
        sb.append("[SLAVE_WORKERS_NODE_NAMES= ");
        for (String name : this.slaveWorkersNodeNames) {
            sb.append("[SW_NAME=").append(name).append("]");
        }
        sb.append("]");
        sb.append("]");
        return sb.toString();
    }
}

