/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.nio.worker;

import es.bsc.comm.Connection;
import es.bsc.comm.exceptions.CommException;
import es.bsc.comm.nio.NIONode;
import es.bsc.comm.stage.Transfer;
import es.bsc.compss.COMPSsConstants;
import es.bsc.compss.nio.NIOAgent;
import es.bsc.compss.nio.NIOMessageHandler;
import es.bsc.compss.nio.NIOParam;
import es.bsc.compss.nio.NIOTask;
import es.bsc.compss.nio.NIOTaskResult;
import es.bsc.compss.nio.NIOTracer;
import es.bsc.compss.nio.NIOURI;
import es.bsc.compss.nio.commands.CommandDataReceived;
import es.bsc.compss.nio.commands.CommandExecutorShutdownACK;
import es.bsc.compss.nio.commands.CommandNIOTaskDone;
import es.bsc.compss.nio.commands.CommandShutdownACK;
import es.bsc.compss.nio.commands.Data;
import es.bsc.compss.nio.commands.workerFiles.CommandWorkerDebugFilesDone;
import es.bsc.compss.nio.dataRequest.DataRequest;
import es.bsc.compss.nio.dataRequest.WorkerDataRequest;
import es.bsc.compss.nio.exceptions.SerializedObjectException;
import es.bsc.compss.nio.worker.components.DataManager;
import es.bsc.compss.nio.worker.components.ExecutionManager;
import es.bsc.compss.nio.worker.exceptions.InitializationException;
import es.bsc.compss.nio.worker.exceptions.InvalidMapException;
import es.bsc.compss.nio.worker.util.ThreadPrintStream;
import es.bsc.compss.types.BindingObject;
import es.bsc.compss.util.BindingDataManager;
import es.bsc.compss.util.ErrorManager;
import es.bsc.compss.util.Serializer;
import es.bsc.compss.util.Tracer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import storage.StorageException;
import storage.StorageItf;

public class NIOWorker
extends NIOAgent {
    private static final int MAX_RETRIES = 10;
    private static final Logger WORKER_LOGGER = LogManager.getLogger("es.bsc.compss.Worker");
    private static final boolean WORKER_LOGGER_DEBUG = WORKER_LOGGER.isDebugEnabled();
    private static final String EXECUTION_MANAGER_ERR = "Error starting ExecutionManager";
    private static final String DATA_MANAGER_ERROR = "Error starting DataManager";
    private static final String ERROR_INCORRECT_NUM_PARAMS = "Error: Incorrect number of parameters";
    private static boolean removeWDFlagDefined = System.getProperty("compss.worker.removeWD") != null && !System.getProperty("compss.worker.removeWD").isEmpty();
    private static boolean removeWD = removeWDFlagDefined ? Boolean.valueOf(System.getProperty("compss.worker.removeWD")) : true;
    private static boolean isWorkerDebugEnabled;
    private final String deploymentId;
    private final String lang;
    private final String host;
    private final String workingDir;
    private final String installDir;
    private final String appDir;
    private final String libraryPath;
    private final String classpath;
    private final String pythonpath;
    private static String storageConf;
    private static String executionType;
    private static String pythonInterpreter;
    private static String pythonVersion;
    private static String pythonVirtualEnvironment;
    private static String pythonPropagateVirtualEnvironment;
    private final ExecutionManager executionManager;
    private final DataManager dataManager;
    private static ThreadPrintStream out;
    private static ThreadPrintStream err;
    public static final String SUFFIX_OUT = ".out";
    public static final String SUFFIX_ERR = ".err";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NIOWorker(int snd, int rcv, String hostName, int masterPort, int computingUnitsCPU, int computingUnitsGPU, int computingUnitsFPGA, String cpuMap, String gpuMap, String fpgaMap, int limitOfTasks, String appUuid, String lang, String workingDir, String installDir, String appDir, String libPath, String classpath, String pythonpath) {
        super(snd, rcv, masterPort);
        WORKER_LOGGER.info("NIO Worker init");
        this.deploymentId = appUuid;
        this.lang = lang;
        this.host = hostName;
        this.workingDir = workingDir.endsWith(File.separator) ? workingDir : workingDir + File.separator;
        this.installDir = installDir.endsWith(File.separator) ? installDir : installDir + File.separator;
        this.appDir = appDir.equals("null") ? "" : appDir;
        this.libraryPath = libPath.equals("null") ? "" : libPath;
        this.classpath = classpath.equals("null") ? "" : classpath;
        this.pythonpath = pythonpath.equals("null") ? "" : pythonpath;
        this.masterNode = null;
        this.dataManager = new DataManager();
        try {
            this.dataManager.init();
        }
        catch (InitializationException ie) {
            ErrorManager.error(DATA_MANAGER_ERROR, ie);
        }
        ExecutionManager em = null;
        try {
            em = new ExecutionManager(this, computingUnitsCPU, computingUnitsGPU, computingUnitsFPGA, cpuMap, gpuMap, fpgaMap, limitOfTasks);
        }
        catch (InvalidMapException ime) {
            ErrorManager.fatal(ime);
            return;
        }
        finally {
            this.executionManager = em;
        }
        if (tracing_level == 1) {
            NIOTracer.enablePThreads();
        }
        try {
            this.executionManager.init();
        }
        catch (InitializationException ie) {
            ErrorManager.error(EXECUTION_MANAGER_ERR, ie);
        }
        if (tracing_level == 1) {
            NIOTracer.disablePThreads();
        }
    }

    @Override
    public void setWorkerIsReady(String nodeName) {
    }

    @Override
    public void setMaster(NIONode master) {
        if (this.masterNode == null) {
            this.masterNode = new NIONode(master.getIp(), masterPort);
        }
    }

    @Override
    public boolean isMyUuid(String uuid, String nodeName) {
        return uuid.equals(this.deploymentId) && nodeName.equals(this.host);
    }

    public static boolean isWorkerDebugEnabled() {
        return isWorkerDebugEnabled;
    }

    public static String getExecutionType() {
        return executionType;
    }

    public static boolean isTracingEnabled() {
        return NIOTracer.isActivated();
    }

    public static String getStorageConf() {
        if (storageConf == null || storageConf.equals("") || storageConf.equals("null")) {
            return "null";
        }
        return storageConf;
    }

    public static String getPythonInterpreter() {
        return pythonInterpreter;
    }

    public static String getPythonVersion() {
        return pythonVersion;
    }

    public static String getPythonVirtualEnvironment() {
        return pythonVirtualEnvironment;
    }

    public static String getPythonPropagateVirtualEnvironment() {
        return pythonPropagateVirtualEnvironment;
    }

    public ExecutionManager getExecutionManager() {
        return this.executionManager;
    }

    public String getLang() {
        return this.lang;
    }

    @Override
    public String getWorkingDir() {
        return this.workingDir;
    }

    public String getInstallDir() {
        return this.installDir;
    }

    public String getAppDir() {
        return this.appDir;
    }

    public String getLibPath() {
        return this.libraryPath;
    }

    public String getClasspath() {
        return this.classpath;
    }

    public String getPythonpath() {
        return this.pythonpath;
    }

    @Override
    public void receivedNewTask(NIONode master, NIOTask task, List<String> obsoleteFiles) {
        WORKER_LOGGER.info("Received Job " + task);
        if (NIOTracer.isActivated()) {
            NIOTracer.emitEvent(Tracer.Event.WORKER_RECEIVED_NEW_TASK.getId(), Tracer.Event.WORKER_RECEIVED_NEW_TASK.getType());
        }
        if (obsoleteFiles != null) {
            this.removeObsolete(obsoleteFiles);
        }
        WORKER_LOGGER.info("Checking parameters");
        WorkerDataRequest.TransferringTask tt = new WorkerDataRequest.TransferringTask(task);
        int i = 0;
        block7: for (NIOParam param : task.getParams()) {
            ++i;
            if (param.getData() != null) {
                WORKER_LOGGER.debug("- Checking transfers for data of parameter " + (String)param.getValue());
                switch (param.getType()) {
                    case OBJECT_T: {
                        this.askForObject(param, i, tt);
                        continue block7;
                    }
                    case PSCO_T: {
                        this.askForPSCO(param);
                        continue block7;
                    }
                    case EXTERNAL_PSCO_T: {
                        continue block7;
                    }
                    case BINDING_OBJECT_T: {
                        this.askForBindingObject(param, i, tt);
                        continue block7;
                    }
                    case FILE_T: {
                        this.askForFile(param, i, tt);
                        continue block7;
                    }
                }
                continue;
            }
            tt.decreaseParams();
        }
        if (NIOTracer.isActivated()) {
            NIOTracer.emitEvent(tt.getTask().getTaskId(), NIOTracer.getTaskTransfersType());
        }
        this.requestTransfers();
        if (NIOTracer.isActivated()) {
            NIOTracer.emitEvent(0L, NIOTracer.getTaskTransfersType());
        }
        if (tt.getParams() == 0) {
            this.executeTask(tt.getTask());
        }
        if (NIOTracer.isActivated()) {
            NIOTracer.emitEvent(0L, Tracer.Event.WORKER_RECEIVED_NEW_TASK.getType());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void askForPSCO(NIOParam param) {
        String pscoId = (String)param.getValue();
        WORKER_LOGGER.debug("   - " + pscoId + " registered as PSCO.");
        WORKER_LOGGER.debug("   - Checking if " + pscoId + " is in cache.");
        boolean inCache = this.dataManager.checkPresence(pscoId);
        if (!inCache) {
            WORKER_LOGGER.debug("   - Retrieving psco " + pscoId + " from Storage");
            Object obj = null;
            if (NIOTracer.isActivated()) {
                NIOTracer.emitEvent(Tracer.Event.STORAGE_GETBYID.getId(), Tracer.Event.STORAGE_GETBYID.getType());
            }
            try {
                obj = StorageItf.getByID(pscoId);
            }
            catch (StorageException e) {
                WORKER_LOGGER.error("Cannot getByID PSCO " + pscoId, (Throwable)e);
            }
            finally {
                if (NIOTracer.isActivated()) {
                    NIOTracer.emitEvent(0L, Tracer.Event.STORAGE_GETBYID.getType());
                }
            }
            this.storeObject(pscoId, obj);
        }
        WORKER_LOGGER.debug("   - PSCO with id " + pscoId + " stored");
    }

    private void askForBindingObject(NIOParam param, int index, WorkerDataRequest.TransferringTask tt) {
        WORKER_LOGGER.debug("   - " + (String)param.getValue() + " registered as binding object.");
        BindingObject dest_bo = BindingObject.generate((String)param.getValue());
        String value = dest_bo.getName();
        int type = dest_bo.getType();
        int elements = dest_bo.getElements();
        boolean askTransfer = false;
        WORKER_LOGGER.debug("   - Checking if " + value + " is in binding cache.");
        boolean cached = BindingDataManager.isInBinding(value);
        if (!cached) {
            int res;
            BindingObject bo;
            boolean locationsInCache = false;
            WORKER_LOGGER.debug("   - Checking if " + value + " locations are catched");
            for (NIOURI loc : param.getData().getSources()) {
                bo = BindingObject.generate(loc.getPath());
                if (!BindingDataManager.isInBinding(bo.getName())) continue;
                WORKER_LOGGER.debug("   - Parameter " + index + "(" + value + ") location found in cache.");
                if (param.isPreserveSourceData()) {
                    WORKER_LOGGER.debug("   - Parameter " + index + "(" + value + ") preserves sources. CACHE-COPYING");
                    res = BindingDataManager.copyCachedData(bo.getName(), value);
                    if (res != 0) {
                        WORKER_LOGGER.error("CACHE-COPY from " + bo.getName() + " to " + value + " has failed. ");
                        break;
                    }
                } else {
                    WORKER_LOGGER.debug("   - Parameter " + index + "(" + value + ") erases sources. CACHE-MOVING");
                    res = BindingDataManager.moveCachedData(bo.getName(), value);
                    if (res != 0) {
                        WORKER_LOGGER.error("CACHE-MOVE from " + bo.getName() + " to " + value + " has failed. ");
                        break;
                    }
                }
                locationsInCache = true;
                break;
            }
            if (!locationsInCache) {
                NIOURI loc;
                boolean existInHost = false;
                WORKER_LOGGER.debug("   - Checking if " + (String)param.getValue() + " locations are in host");
                loc = param.getData().getURIinHost(this.host);
                if (loc != null) {
                    bo = BindingObject.generate(loc.getPath());
                    WORKER_LOGGER.debug("   - Parameter " + index + "(" + (String)param.getValue() + ") found at host with location " + loc.getPath() + " Checking if id " + bo.getName() + " is in cache...");
                    if (BindingDataManager.isInBinding(bo.getName())) {
                        WORKER_LOGGER.debug("   - Parameter " + index + "(" + value + ") location found in cache.");
                        if (param.isPreserveSourceData()) {
                            WORKER_LOGGER.debug("   - Parameter " + index + "(" + value + ") preserves sources. CACHE-COPYING");
                            res = BindingDataManager.copyCachedData(bo.getName(), value);
                            if (res != 0) {
                                WORKER_LOGGER.error("CACHE-COPY from " + bo.getName() + " to " + value + " has failed. ");
                            }
                        } else {
                            WORKER_LOGGER.debug("   - Parameter " + index + "(" + value + ") erases sources. CACHE-MOVING");
                            res = BindingDataManager.moveCachedData(bo.getName(), value);
                            if (res != 0) {
                                WORKER_LOGGER.error("CACHE-MOVE from " + bo.getName() + " to " + value + " has failed. ");
                            }
                        }
                        existInHost = true;
                    } else {
                        WORKER_LOGGER.debug("   - Parameter " + index + "(" + (String)param.getValue() + ") not in cache with id " + bo.getName());
                        File inFile = new File(bo.getId());
                        if (!inFile.isAbsolute()) {
                            inFile = new File(this.workingDir + File.separator + loc.getPath());
                        }
                        String path = inFile.getAbsolutePath();
                        WORKER_LOGGER.debug("   - Checking if file " + path + " exists ");
                        if (inFile.exists()) {
                            existInHost = true;
                            int res2 = BindingDataManager.loadFromFile(value, path, type, elements);
                            if (res2 != 0) {
                                WORKER_LOGGER.error("Error loading " + param.getValue() + " from file " + loc.getPath());
                            }
                        } else {
                            WORKER_LOGGER.debug("   - Parameter " + index + "(" + (String)param.getValue() + ") not in cache.");
                        }
                    }
                }
                if (!existInHost) {
                    askTransfer = true;
                }
            }
        }
        this.askForTransfer(askTransfer, param, index, tt);
    }

    private void askForObject(NIOParam param, int index, WorkerDataRequest.TransferringTask tt) {
        WORKER_LOGGER.debug("   - " + (String)param.getValue() + " registered as object.");
        boolean askTransfer = false;
        WORKER_LOGGER.debug("   - Checking if " + (String)param.getValue() + " is in cache.");
        boolean catched = this.dataManager.checkPresence((String)param.getValue());
        if (!catched) {
            boolean locationsInCache = false;
            WORKER_LOGGER.debug("   - Checking if " + (String)param.getValue() + " locations are catched");
            for (NIOURI loc : param.getData().getSources()) {
                if (!this.dataManager.checkPresence(loc.getPath())) continue;
                WORKER_LOGGER.debug("   - Parameter " + index + "(" + (String)param.getValue() + ") location found in cache.");
                try {
                    Object o;
                    if (param.isPreserveSourceData()) {
                        WORKER_LOGGER.debug("   - Parameter " + index + "(" + (String)param.getValue() + ") preserves sources. CACHE-COPYING");
                        o = Serializer.deserialize(loc.getPath());
                        this.storeObject((String)param.getValue(), o);
                    } else {
                        WORKER_LOGGER.debug("   - Parameter " + index + "(" + (String)param.getValue() + ") erases sources. CACHE-MOVING");
                        o = this.dataManager.getObject(loc.getPath());
                        this.dataManager.remove(loc.getPath());
                        this.storeObject((String)param.getValue(), o);
                    }
                    locationsInCache = true;
                }
                catch (IOException ioe) {
                    WORKER_LOGGER.error("IOException", (Throwable)ioe);
                }
                catch (ClassNotFoundException e) {
                    WORKER_LOGGER.error("ClassNotFoundException", (Throwable)e);
                }
                break;
            }
            if (!locationsInCache) {
                NIOURI loc;
                boolean existInHost = false;
                WORKER_LOGGER.debug("   - Checking if " + (String)param.getValue() + " locations are in host");
                loc = param.getData().getURIinHost(this.host);
                if (loc != null) {
                    WORKER_LOGGER.debug("   - Parameter " + index + "(" + (String)param.getValue() + ") found at host.");
                    try {
                        File source = new File(this.workingDir + File.separator + loc.getPath());
                        File target = new File(this.workingDir + File.separator + param.getValue().toString());
                        if (param.isPreserveSourceData()) {
                            WORKER_LOGGER.debug("   - Parameter " + index + "(" + (String)param.getValue() + ") preserves sources. COPYING");
                            WORKER_LOGGER.debug("         Source: " + source);
                            WORKER_LOGGER.debug("         Target: " + target);
                            Files.copy(source.toPath(), target.toPath(), new CopyOption[0]);
                        } else {
                            WORKER_LOGGER.debug("   - Parameter " + index + "(" + (String)param.getValue() + ") erases sources. MOVING");
                            WORKER_LOGGER.debug("         Source: " + source);
                            WORKER_LOGGER.debug("         Target: " + target);
                            if (!source.renameTo(target)) {
                                WORKER_LOGGER.error("Error renaming file from " + source.getAbsolutePath() + " to " + target.getAbsolutePath());
                            }
                        }
                        Object o = Serializer.deserialize((String)param.getValue());
                        this.storeObject((String)param.getValue(), o);
                        existInHost = true;
                    }
                    catch (IOException ioe) {
                        WORKER_LOGGER.error("IOException", (Throwable)ioe);
                    }
                    catch (ClassNotFoundException e) {
                        WORKER_LOGGER.error("ClassNotFoundException", (Throwable)e);
                    }
                }
                if (!existInHost) {
                    askTransfer = true;
                }
            }
        }
        this.askForTransfer(askTransfer, param, index, tt);
    }

    private void askForFile(NIOParam param, int index, WorkerDataRequest.TransferringTask tt) {
        WORKER_LOGGER.debug("   - " + (String)param.getValue() + " registered as file.");
        boolean locationsInHost = false;
        boolean askTransfer = false;
        WORKER_LOGGER.debug("   - Checking if file " + (String)param.getValue() + " exists.");
        File f = new File(param.getValue().toString());
        if (!f.exists()) {
            WORKER_LOGGER.debug("   - Checking if " + (String)param.getValue() + " exists in worker");
            NIOURI loc = param.getData().getURIinHost(this.host);
            if (loc != null) {
                WORKER_LOGGER.debug("   - Parameter " + index + "(" + (String)param.getValue() + ") found at host.");
                try {
                    File source = new File(loc.getPath());
                    File target = new File(param.getValue().toString());
                    if (param.isPreserveSourceData()) {
                        WORKER_LOGGER.debug("   - Parameter " + index + "(" + (String)param.getValue() + ") preserves sources. COPYING");
                        WORKER_LOGGER.debug("         Source: " + source);
                        WORKER_LOGGER.debug("         Target: " + target);
                        if (!source.exists()) {
                            WORKER_LOGGER.debug("source does not exist, preserve data");
                            WORKER_LOGGER.debug("lang is " + this.getLang());
                            if (this.getLang().toUpperCase() != "C") {
                                WORKER_LOGGER.debug("[ERROR] File " + loc.getPath() + " does not exist but it could be an object in cache. Ignoring.");
                            }
                        } else {
                            WORKER_LOGGER.debug("before copy");
                            Files.copy(source.toPath(), target.toPath(), new CopyOption[0]);
                            WORKER_LOGGER.debug("after copy");
                        }
                    } else {
                        WORKER_LOGGER.debug("   - Parameter " + index + "(" + (String)param.getValue() + ") erases sources. MOVING");
                        WORKER_LOGGER.debug("         Source: " + source);
                        WORKER_LOGGER.debug("         Target: " + target);
                        if (!source.exists()) {
                            WORKER_LOGGER.debug("source does not exist, no preserve data");
                            WORKER_LOGGER.debug("lang is " + this.getLang() + ", in uppercase is " + this.getLang().toUpperCase());
                            if (this.getLang().toUpperCase() != "C") {
                                WORKER_LOGGER.debug("File " + loc.getPath() + " does not exist but it could be an object in cache. Ignoring.");
                            }
                        } else {
                            try {
                                Files.move(source.toPath(), target.toPath(), StandardCopyOption.ATOMIC_MOVE);
                            }
                            catch (AtomicMoveNotSupportedException amnse) {
                                WORKER_LOGGER.warn("WARN: AtomicMoveNotSupportedException. File cannot be atomically moved. Trying to move without atomic");
                                Files.move(source.toPath(), target.toPath(), new CopyOption[0]);
                            }
                        }
                    }
                    locationsInHost = true;
                }
                catch (IOException ioe) {
                    WORKER_LOGGER.error("IOException", (Throwable)ioe);
                }
            }
            if (!locationsInHost) {
                askTransfer = true;
            }
        } else if (this.getDataRequests(param.getData().getName()) != null) {
            askTransfer = true;
        }
        this.askForTransfer(askTransfer, param, index, tt);
    }

    private void askForTransfer(boolean askTransfer, NIOParam param, int index, WorkerDataRequest.TransferringTask tt) {
        if (askTransfer) {
            WORKER_LOGGER.info("- Parameter " + index + "(" + (String)param.getValue() + ") does not exist, requesting data transfer");
            WorkerDataRequest dr = new WorkerDataRequest(tt, param.getType(), param.getData(), (String)param.getValue());
            this.addTransferRequest(dr);
        } else {
            WORKER_LOGGER.info("- Parameter " + index + "(" + (String)param.getValue() + ") already exists.");
            tt.decreaseParams();
        }
    }

    @Override
    protected void handleDataToSendNotAvailable(Connection c, Data d) {
        WORKER_LOGGER.debug("handling data not available");
        if (COMPSsConstants.Lang.valueOf(this.lang.toUpperCase()) == COMPSsConstants.Lang.C) {
            String path = d.getFirstURI().getPath();
            WORKER_LOGGER.debug("about to serialize");
            if (this.executionManager.serializeExternalData(d.getName(), path)) {
                c.sendDataFile(path);
                return;
            }
        }
        ErrorManager.warn("Data " + d.getName() + "in this worker " + this.getHostName() + " could not be sent to master.");
        c.finishConnection();
    }

    @Override
    public void handleRequestedDataNotAvailableError(List<DataRequest> failedRequests, String dataId) {
        for (DataRequest dr : failedRequests) {
            Throwable throwable;
            WorkerDataRequest wdr = (WorkerDataRequest)dr;
            wdr.getTransferringTask().decreaseParams();
            wdr.getTransferringTask().setError(true);
            if (wdr.getTransferringTask().getParams() == 0) {
                this.sendTaskDone(wdr.getTransferringTask().getTask(), false);
            }
            String baseJobPath = this.workingDir + File.separator + "jobs" + File.separator + "job" + wdr.getTransferringTask().getTask().getJobId() + "_" + (Object)((Object)wdr.getTransferringTask().getTask().getHist());
            File fout = new File(baseJobPath + SUFFIX_OUT);
            File ferr = new File(baseJobPath + SUFFIX_ERR);
            if (fout.exists() && ferr.exists()) continue;
            String errorMessage = "Worker closed because the data " + dataId + " couldn't be retrieved.";
            try {
                throwable = null;
                try (FileOutputStream outputStream = new FileOutputStream(fout);){
                    outputStream.write(errorMessage.getBytes());
                    outputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (IOException ioe) {
                WORKER_LOGGER.error("IOException writing worker output file: " + fout, (Throwable)ioe);
            }
            try {
                FileOutputStream errorStream = new FileOutputStream(ferr);
                throwable = null;
                try {
                    errorStream.write(errorMessage.getBytes());
                    errorStream.close();
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                finally {
                    if (errorStream == null) continue;
                    if (throwable != null) {
                        try {
                            errorStream.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                        continue;
                    }
                    errorStream.close();
                }
            }
            catch (IOException ioe) {
                WORKER_LOGGER.error("IOException writing worker error file: " + ferr, (Throwable)ioe);
            }
        }
    }

    @Override
    public void receivedValue(Transfer.Destination type, String dataId, Object object, List<DataRequest> achievedRequests) {
        if (type == Transfer.Destination.OBJECT) {
            WORKER_LOGGER.info("Received data " + dataId + " with associated object " + object);
            this.storeObject(dataId, object);
        } else {
            WORKER_LOGGER.info("Received data " + dataId);
        }
        for (DataRequest dr : achievedRequests) {
            WorkerDataRequest wdr = (WorkerDataRequest)dr;
            wdr.getTransferringTask().decreaseParams();
            if (NIOTracer.isActivated()) {
                NIOTracer.emitDataTransferEvent("0");
            }
            if (wdr.getTransferringTask().getParams() != 0) continue;
            if (!wdr.getTransferringTask().getError()) {
                this.executeTask(wdr.getTransferringTask().getTask());
                continue;
            }
            this.sendTaskDone(wdr.getTransferringTask().getTask(), false);
        }
    }

    public void sendTaskDone(NIOTask nt, boolean successful) {
        File ferr;
        int jobId = nt.getJobId();
        int taskId = nt.getTaskId();
        Connection c = TM.startConnection(this.masterNode);
        NIOTaskResult tr = new NIOTaskResult(jobId, nt.getParams());
        if (WORKER_LOGGER.isDebugEnabled()) {
            WORKER_LOGGER.debug("RESULT FOR JOB " + jobId + " (TASK ID: " + taskId + ")");
            WORKER_LOGGER.debug(tr);
        }
        CommandNIOTaskDone cmd = new CommandNIOTaskDone(this, tr, successful);
        c.sendCommand(cmd);
        String taskFileOutName = this.workingDir + File.separator + "jobs" + File.separator + "job" + jobId + "_" + (Object)((Object)nt.getHist()) + SUFFIX_OUT;
        String taskFileErrName = this.workingDir + File.separator + "jobs" + File.separator + "job" + jobId + "_" + (Object)((Object)nt.getHist()) + SUFFIX_ERR;
        File fout = new File(taskFileOutName);
        if (!fout.exists()) {
            String errorMessage = "Autogenerated Empty file. An error was produced before generating any log in the stdout";
            try (FileOutputStream outputStream = new FileOutputStream(fout);){
                outputStream.write(errorMessage.getBytes());
                outputStream.close();
            }
            catch (IOException ioe) {
                WORKER_LOGGER.error("IOException writing worker output file: " + fout, (Throwable)ioe);
            }
        }
        if (!(ferr = new File(taskFileErrName)).exists()) {
            String errorMessage = "Autogenerated Empty file. An error was produced before generating any log in the stderr";
            try (FileOutputStream errorStream = new FileOutputStream(ferr);){
                errorStream.write(errorMessage.getBytes());
                errorStream.close();
            }
            catch (IOException ioe) {
                WORKER_LOGGER.error("IOException writing worker error file: " + ferr, (Throwable)ioe);
            }
        }
        if (isWorkerDebugEnabled || !successful) {
            WORKER_LOGGER.debug("Sending file " + taskFileOutName);
            c.sendDataFile(taskFileOutName);
            WORKER_LOGGER.debug("Sending file " + taskFileErrName);
            c.sendDataFile(taskFileErrName);
        }
        c.finishConnection();
        WORKER_LOGGER.debug("Job " + jobId + "(Task " + taskId + ") send job done");
    }

    private void executeTask(NIOTask task) {
        if (isWorkerDebugEnabled) {
            WORKER_LOGGER.debug("Enqueueing job " + task.getJobId() + " for execution.");
        }
        this.executionManager.enqueue(task);
        if (isWorkerDebugEnabled) {
            WORKER_LOGGER.debug("Notifying presence of all data for job " + task.getJobId() + ".");
        }
        CommandDataReceived cdr = new CommandDataReceived(this, task.getTransferGroupId());
        for (int retries = 0; retries < 10; ++retries) {
            if (this.tryNofiyDataReceived(cdr)) {
                return;
            }
            try {
                Thread.sleep(10L);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private boolean tryNofiyDataReceived(CommandDataReceived cdr) {
        Connection c = TM.startConnection(this.masterNode);
        c.sendCommand(cdr);
        c.finishConnection();
        return true;
    }

    public void removeObsolete(List<String> obsolete) {
        try {
            for (String name : obsolete) {
                String dataName;
                if (name.startsWith(File.separator)) {
                    WORKER_LOGGER.debug("Removing file " + name);
                    File f = new File(name);
                    if (!f.delete()) {
                        WORKER_LOGGER.error("Error removing file " + f.getAbsolutePath());
                    }
                    if (COMPSsConstants.Lang.valueOf(this.lang.toUpperCase()) == COMPSsConstants.Lang.C && persistentC) {
                        this.executionManager.removeExternalData(name);
                    }
                }
                if (!this.dataManager.checkPresence(dataName = new File(name).getName())) continue;
                this.removeFromCache(dataName);
            }
        }
        catch (Exception e) {
            WORKER_LOGGER.error("Exception", (Throwable)e);
        }
    }

    public void receivedUpdateSources(Connection c) {
    }

    @Override
    public void shutdownExecutionManager(Connection closingConnection) {
        WORKER_LOGGER.debug("Stopping Execution Manager...");
        this.executionManager.stop();
        if (closingConnection != null) {
            closingConnection.sendCommand(new CommandExecutorShutdownACK());
            closingConnection.finishConnection();
        }
    }

    @Override
    public void shutdownExecutionManagerNotification(Connection c) {
        ErrorManager.warn("Shutdown execution ACK notification should never be received by a worker");
    }

    @Override
    public void shutdown(Connection closingConnection) {
        WORKER_LOGGER.debug("Entering shutdown method on worker");
        this.dataManager.stop();
        if (closingConnection != null) {
            closingConnection.sendCommand(new CommandShutdownACK());
            closingConnection.finishConnection();
        }
        TM.shutdown(closingConnection);
        String storageConf = System.getProperty("compss.storage.conf");
        if (storageConf != null && !storageConf.equals("") && !storageConf.equals("null")) {
            try {
                StorageItf.finish();
            }
            catch (StorageException e) {
                WORKER_LOGGER.error("Error releasing storage library: " + e.getMessage(), (Throwable)e);
            }
        }
        if (removeWD) {
            WORKER_LOGGER.debug("Erasing Worker Sandbox WorkingDir: " + this.workingDir);
            try {
                this.removeFolder(this.workingDir);
            }
            catch (IOException ioe) {
                WORKER_LOGGER.error("Exception", (Throwable)ioe);
            }
        }
        WORKER_LOGGER.debug("Finish shutdown method on worker");
    }

    private void removeFolder(String sandBox) throws IOException {
        File wdirFile = new File(sandBox);
        this.remove(wdirFile);
    }

    private void remove(File f) throws IOException {
        if (f.exists()) {
            if (f.isDirectory()) {
                for (File child : f.listFiles()) {
                    this.remove(child);
                }
            }
            Files.delete(f.toPath());
        }
    }

    @Override
    public Object getObject(String name) throws SerializedObjectException {
        String realName = name.substring(name.lastIndexOf(47) + 1);
        return this.dataManager.getObject(realName);
    }

    public Object getPersistentObject(String id) throws StorageException {
        if (this.dataManager.checkPresence(id)) {
            return this.dataManager.getObject(id);
        }
        if (NIOTracer.isActivated()) {
            NIOTracer.emitEvent(Tracer.Event.STORAGE_GETBYID.getId(), Tracer.Event.STORAGE_GETBYID.getType());
        }
        Object obj = null;
        try {
            obj = StorageItf.getByID(id);
            this.dataManager.storeObject(id, obj);
        }
        catch (StorageException e) {
            throw e;
        }
        finally {
            if (NIOTracer.isActivated()) {
                NIOTracer.emitEvent(0L, Tracer.Event.STORAGE_GETBYID.getType());
            }
        }
        return obj;
    }

    @Override
    public String getObjectAsFile(String s) {
        WORKER_LOGGER.warn("getObjectAsFile has been called in the worker side!");
        return null;
    }

    public void storeObject(String name, Object value) {
        this.dataManager.storeObject(name, value);
    }

    public void storePersistentObject(String id, Object value) {
        this.dataManager.storeObject(id, value);
    }

    public void removeFromCache(String name) {
        this.dataManager.remove(name);
        WORKER_LOGGER.debug(name + " removed from cache.");
    }

    public static void registerOutputs(String path) {
        err.registerThread(path);
        out.registerThread(path);
    }

    public static void unregisterOutputs() {
        err.unregisterThread();
        out.unregisterThread();
    }

    @Override
    public void receivedNIOTaskDone(Connection c, NIOTaskResult tr, boolean successful) {
    }

    @Override
    public void copiedData(int transfergroupID) {
    }

    @Override
    public void shutdownNotification(Connection c) {
    }

    public String getHostName() {
        return this.host;
    }

    @Override
    public void waitUntilTracingPackageGenerated() {
    }

    @Override
    public void notifyTracingPackageGeneration() {
    }

    @Override
    public void waitUntilWorkersDebugInfoGenerated() {
    }

    @Override
    public void notifyWorkersDebugInfoGeneration() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generateWorkersDebugInfo(Connection c) {
        String outSource = this.workingDir + File.separator + "log" + File.separator + "worker_" + this.host + SUFFIX_OUT;
        String outTarget = this.workingDir + File.separator + "log" + File.separator + "static_" + "worker_" + this.host + SUFFIX_OUT;
        if (new File(outSource).exists()) {
            try {
                Files.copy(new File(outSource).toPath(), new File(outTarget).toPath(), new CopyOption[0]);
            }
            catch (Exception e) {
                WORKER_LOGGER.error("Exception", (Throwable)e);
            }
        } else {
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(outTarget);
                fos.write("Empty file".getBytes());
                fos.close();
            }
            catch (Exception e) {
                WORKER_LOGGER.error("Exception", (Throwable)e);
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (Exception e) {
                        WORKER_LOGGER.error("Exception", (Throwable)e);
                    }
                }
            }
        }
        String errSource = this.workingDir + File.separator + "log" + File.separator + "worker_" + this.host + SUFFIX_ERR;
        String errTarget = this.workingDir + File.separator + "log" + File.separator + "static_" + "worker_" + this.host + SUFFIX_ERR;
        if (new File(errSource).exists()) {
            try {
                Files.copy(new File(errSource).toPath(), new File(errTarget).toPath(), new CopyOption[0]);
            }
            catch (Exception e) {
                WORKER_LOGGER.error("Exception", (Throwable)e);
            }
        } else {
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(errTarget);
                fos.write("Empty file".getBytes());
                fos.close();
            }
            catch (Exception e) {
                WORKER_LOGGER.error("Exception", (Throwable)e);
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (Exception e) {
                        WORKER_LOGGER.error("Exception", (Throwable)e);
                    }
                }
            }
        }
        c.sendCommand(new CommandWorkerDebugFilesDone());
        c.finishConnection();
    }

    public static void main(String[] args) {
        if (args.length != 31) {
            if (WORKER_LOGGER_DEBUG) {
                WORKER_LOGGER.debug("Received parameters: ");
                for (int i = 0; i < args.length; ++i) {
                    WORKER_LOGGER.debug("Param " + i + ":  " + args[i]);
                }
            }
            ErrorManager.fatal(ERROR_INCORRECT_NUM_PARAMS);
        }
        isWorkerDebugEnabled = Boolean.valueOf(args[0]);
        int maxSnd = Integer.parseInt(args[1]);
        int maxRcv = Integer.parseInt(args[2]);
        String workerIP = args[3];
        int wPort = Integer.parseInt(args[4]);
        int mPort = Integer.parseInt(args[5]);
        int computingUnitsCPU = Integer.parseInt(args[6]);
        int computingUnitsGPU = Integer.parseInt(args[7]);
        int computingUnitsFPGA = Integer.parseInt(args[8]);
        String cpuMap = args[9];
        String gpuMap = args[10];
        String fpgaMap = args[11];
        int limitOfTasks = Integer.parseInt(args[12]);
        String appUuid = args[13];
        String lang = args[14];
        String workingDir = args[15];
        String installDir = args[16];
        String appDir = args[17];
        String libPath = args[18];
        String classpath = args[19];
        String pythonpath = args[20];
        String trace = args[21];
        String extraeFile = args[22];
        String host = args[23];
        storageConf = args[24];
        executionType = args[25];
        NIOWorker.setPersistent(Boolean.parseBoolean(args[26]));
        pythonInterpreter = args[27];
        pythonVersion = args[28];
        pythonVirtualEnvironment = args[29];
        pythonPropagateVirtualEnvironment = args[30];
        if (isWorkerDebugEnabled) {
            WORKER_LOGGER.debug("maxSnd: " + String.valueOf(maxSnd));
            WORKER_LOGGER.debug("maxRcv: " + String.valueOf(maxRcv));
            WORKER_LOGGER.debug("WorkerName: " + workerIP);
            WORKER_LOGGER.debug("WorkerPort: " + String.valueOf(wPort));
            WORKER_LOGGER.debug("MasterPort: " + String.valueOf(mPort));
            WORKER_LOGGER.debug("Computing Units CPU: " + String.valueOf(computingUnitsCPU));
            WORKER_LOGGER.debug("Computing Units GPU: " + String.valueOf(computingUnitsGPU));
            WORKER_LOGGER.debug("Computing Units FPGA: " + String.valueOf(computingUnitsFPGA));
            WORKER_LOGGER.debug("User defined CPU Map: " + cpuMap);
            WORKER_LOGGER.debug("User defined GPU Map: " + gpuMap);
            WORKER_LOGGER.debug("User defined FPGA Map: " + fpgaMap);
            WORKER_LOGGER.debug("Limit Of Tasks: " + String.valueOf(limitOfTasks));
            WORKER_LOGGER.debug("App uuid: " + appUuid);
            WORKER_LOGGER.debug("WorkingDir:" + workingDir);
            WORKER_LOGGER.debug("Install Dir: " + installDir);
            WORKER_LOGGER.debug("Tracing: " + trace);
            WORKER_LOGGER.debug("Extrae config File: " + extraeFile);
            WORKER_LOGGER.debug("Host: " + host);
            WORKER_LOGGER.debug("LibraryPath: " + libPath);
            WORKER_LOGGER.debug("Classpath: " + classpath);
            WORKER_LOGGER.debug("Pythonpath: " + pythonpath);
            WORKER_LOGGER.debug("StorageConf: " + storageConf);
            WORKER_LOGGER.debug("executionType: " + executionType);
            WORKER_LOGGER.debug("Persistent c: " + persistentC);
            WORKER_LOGGER.debug("Python interpreter: " + pythonInterpreter);
            WORKER_LOGGER.debug("Python version: " + pythonVersion);
            WORKER_LOGGER.debug("Python virtual environment: " + pythonVirtualEnvironment);
            WORKER_LOGGER.debug("Python propagate virtual environment: " + pythonPropagateVirtualEnvironment);
            WORKER_LOGGER.debug("Remove Sanbox WD: " + removeWD);
        }
        System.setProperty("compss.storage.conf", storageConf);
        try {
            if (storageConf == null || storageConf.equals("") || storageConf.equals("null")) {
                WORKER_LOGGER.warn("No storage configuration file passed");
            } else {
                StorageItf.init(storageConf);
            }
        }
        catch (StorageException e) {
            ErrorManager.fatal("Error loading storage configuration file: " + storageConf, e);
        }
        System.setProperty("compss.extrae.file", extraeFile);
        tracing_level = Integer.parseInt(trace);
        if (tracing_level > 0) {
            NIOTracer.init(tracing_level);
            NIOTracer.emitEvent(Tracer.Event.START.getId(), Tracer.Event.START.getType());
            try {
                tracingID = Integer.parseInt(host);
                NIOTracer.setWorkerInfo(installDir, workerIP, workingDir, tracingID);
            }
            catch (Exception e) {
                WORKER_LOGGER.error("No valid hostID provided to the tracing system. Provided ID: " + host);
            }
        }
        NIOWorker nw = new NIOWorker(maxSnd, maxRcv, workerIP, mPort, computingUnitsCPU, computingUnitsGPU, computingUnitsFPGA, cpuMap, gpuMap, fpgaMap, limitOfTasks, appUuid, lang, workingDir, installDir, appDir, libPath, classpath, pythonpath);
        NIOMessageHandler mh = new NIOMessageHandler(nw);
        WORKER_LOGGER.debug("  Initializing the TransferManager structures...");
        try {
            TM.init(NIO_EVENT_MANAGER_CLASS, null, mh);
        }
        catch (CommException ce) {
            WORKER_LOGGER.error("Error initializing Transfer Manager on worker " + nw.getHostName(), (Throwable)ce);
            nw.shutdown(null);
            return;
        }
        WORKER_LOGGER.debug("  Starting TransferManager Thread");
        TM.start();
        try {
            TM.startServer(new NIONode(null, wPort));
        }
        catch (CommException ce) {
            WORKER_LOGGER.error("Error starting TransferManager Server at Worker" + nw.getHostName(), (Throwable)ce);
            nw.shutdown(null);
            return;
        }
        if (NIOTracer.isActivated()) {
            NIOTracer.emitEvent(0L, Tracer.Event.START.getType());
        }
        try {
            TM.join();
        }
        catch (InterruptedException ie) {
            WORKER_LOGGER.warn("TransferManager interrupted", (Throwable)ie);
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void receivedBindingObjectAsFile(String filename, String target) {
    }

    public PrintStream getThreadErrStream() {
        return err.getStream();
    }

    public PrintStream getThreadOutStream() {
        return out.getStream();
    }

    @Override
    protected boolean isMaster() {
        return false;
    }

    static {
        try {
            out = new ThreadPrintStream(SUFFIX_OUT, System.out);
            err = new ThreadPrintStream(SUFFIX_ERR, System.err);
            System.setErr(err);
            System.setOut(out);
        }
        catch (Exception e) {
            WORKER_LOGGER.error("Exception", (Throwable)e);
        }
    }
}

