/*
 * Decompiled with CFR 0.152.
 */
package org.gridlab.gat.io.cpi.sftpTrilead;

import java.io.File;
import org.gridlab.gat.CouldNotInitializeCredentialException;
import org.gridlab.gat.CredentialExpiredException;
import org.gridlab.gat.GATContext;
import org.gridlab.gat.InvalidUsernameOrPasswordException;
import org.gridlab.gat.URI;
import org.gridlab.gat.io.cpi.sftpTrilead.SftpTrileadContextCreator;
import org.gridlab.gat.io.cpi.sftpTrilead.SftpTrileadUserInfo;
import org.gridlab.gat.security.cpi.SecurityContextCreator;
import org.gridlab.gat.security.cpi.SecurityContextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SftpTrileadSecurityUtils {
    protected static Logger logger = LoggerFactory.getLogger(SftpTrileadSecurityUtils.class);

    protected static SftpTrileadUserInfo getSftpCredential(GATContext context, String adaptorName, URI location, int defaultPort) throws CouldNotInitializeCredentialException, CredentialExpiredException, InvalidUsernameOrPasswordException {
        Object data = SecurityContextUtils.getSecurityUserData((GATContext)context, (String)adaptorName, (String)"sftpTrilead", (URI)location, (int)defaultPort, (SecurityContextCreator)new SftpTrileadContextCreator());
        return (SftpTrileadUserInfo)data;
    }

    protected static SftpTrileadUserInfo getDefaultUserInfo(GATContext gatContext, URI location) throws CouldNotInitializeCredentialException, CredentialExpiredException, InvalidUsernameOrPasswordException {
        SftpTrileadUserInfo info = new SftpTrileadUserInfo();
        info.privateKey = SftpTrileadSecurityUtils.getDefaultPrivateKey();
        info.username = SecurityContextUtils.getUser((GATContext)gatContext, null, (URI)location);
        info.defaultContext = true;
        return info;
    }

    static File getDefaultPrivateKey() throws CouldNotInitializeCredentialException, CredentialExpiredException {
        String keyfile = null;
        String home = System.getProperty("user.home");
        home = home == null ? "" : home + File.separator;
        try {
            keyfile = home + ".ssh" + File.separator + "identity";
            return SftpTrileadSecurityUtils.loadKey(keyfile);
        }
        catch (Exception exception) {
            try {
                keyfile = home + ".ssh" + File.separator + "id_dsa";
                return SftpTrileadSecurityUtils.loadKey(keyfile);
            }
            catch (Exception exception2) {
                try {
                    keyfile = home + ".ssh" + File.separator + "id_rsa";
                    return SftpTrileadSecurityUtils.loadKey(keyfile);
                }
                catch (Exception exception3) {
                    try {
                        keyfile = home + "ssh" + File.separator + "identity";
                        return SftpTrileadSecurityUtils.loadKey(keyfile);
                    }
                    catch (Exception exception4) {
                        try {
                            keyfile = home + "ssh" + File.separator + "id_dsa";
                            return SftpTrileadSecurityUtils.loadKey(keyfile);
                        }
                        catch (Exception exception5) {
                            try {
                                keyfile = home + "ssh" + File.separator + "id_rsa";
                                return SftpTrileadSecurityUtils.loadKey(keyfile);
                            }
                            catch (Exception exception6) {
                                return null;
                            }
                        }
                    }
                }
            }
        }
    }

    protected static File loadKey(String keyfile) throws CouldNotInitializeCredentialException, CredentialExpiredException {
        File keyf;
        if (logger.isDebugEnabled()) {
            logger.debug("trying to load ssh key from: " + keyfile);
        }
        if (!(keyf = new File(keyfile)).exists()) {
            throw new CouldNotInitializeCredentialException("could not find private key");
        }
        return keyf;
    }
}

