/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.allocatableactions;

import es.bsc.compss.comm.Comm;
import es.bsc.compss.components.impl.ResourceScheduler;
import es.bsc.compss.components.impl.TaskProducer;
import es.bsc.compss.scheduler.exceptions.BlockedActionException;
import es.bsc.compss.scheduler.exceptions.FailedActionException;
import es.bsc.compss.scheduler.exceptions.UnassignedActionException;
import es.bsc.compss.scheduler.types.ActionOrchestrator;
import es.bsc.compss.scheduler.types.AllocatableAction;
import es.bsc.compss.scheduler.types.SchedulingInformation;
import es.bsc.compss.scheduler.types.Score;
import es.bsc.compss.types.Task;
import es.bsc.compss.types.TaskDescription;
import es.bsc.compss.types.annotations.parameter.Direction;
import es.bsc.compss.types.data.DataAccessId;
import es.bsc.compss.types.data.DataInstanceId;
import es.bsc.compss.types.data.LogicalData;
import es.bsc.compss.types.data.Transferable;
import es.bsc.compss.types.data.listener.EventListener;
import es.bsc.compss.types.data.location.DataLocation;
import es.bsc.compss.types.data.operation.JobTransfersListener;
import es.bsc.compss.types.implementations.Implementation;
import es.bsc.compss.types.job.Job;
import es.bsc.compss.types.job.JobListener;
import es.bsc.compss.types.job.JobStatusListener;
import es.bsc.compss.types.parameter.DependencyParameter;
import es.bsc.compss.types.parameter.Parameter;
import es.bsc.compss.types.resources.Worker;
import es.bsc.compss.types.resources.WorkerResourceDescription;
import es.bsc.compss.types.uri.SimpleURI;
import es.bsc.compss.util.CoreManager;
import es.bsc.compss.util.ErrorManager;
import es.bsc.compss.util.JobDispatcher;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ExecutionAction
extends AllocatableAction {
    private static final int TRANSFER_CHANCES = 2;
    private static final int SUBMISSION_CHANCES = 2;
    private static final int SCHEDULING_CHANCES = 2;
    private static final Logger JOB_LOGGER = LogManager.getLogger("es.bsc.compss.Components.TaskDispatcher.JobManager");
    protected final TaskProducer producer;
    protected final Task task;
    private final LinkedList<Integer> jobs;
    private int transferErrors = 0;
    protected int executionErrors = 0;

    public ExecutionAction(SchedulingInformation schedulingInformation, ActionOrchestrator orchestrator, TaskProducer producer, Task task) {
        super(schedulingInformation, orchestrator);
        this.producer = producer;
        this.task = task;
        this.jobs = new LinkedList();
        this.transferErrors = 0;
        this.executionErrors = 0;
        this.task.addExecution(this);
        for (Task predecessor : this.task.getPredecessors()) {
            for (ExecutionAction e : predecessor.getExecutions()) {
                if (e == null || !e.isPending()) continue;
                this.addDataPredecessor(e);
            }
        }
        Task resourceConstraintTask = this.task.getEnforcingTask();
        if (resourceConstraintTask != null) {
            for (ExecutionAction e : resourceConstraintTask.getExecutions()) {
                this.addResourceConstraint(e);
            }
        }
    }

    public final Task getTask() {
        return this.task;
    }

    @Override
    public boolean isToReserveResources() {
        return true;
    }

    @Override
    public boolean isToReleaseResources() {
        return true;
    }

    @Override
    public boolean isToStopResource() {
        return false;
    }

    @Override
    protected void doAction() {
        JOB_LOGGER.info("Ordering transfers to " + this.getAssignedResource() + " to run task: " + this.task.getId());
        this.transferErrors = 0;
        this.executionErrors = 0;
        this.doInputTransfers();
    }

    private final void doInputTransfers() {
        JobTransfersListener listener = new JobTransfersListener(this);
        this.transferInputData(listener);
        listener.enable();
    }

    private final void transferInputData(JobTransfersListener listener) {
        TaskDescription taskDescription = this.task.getTaskDescription();
        block4: for (Parameter p : taskDescription.getParameters()) {
            JOB_LOGGER.debug("    * " + p);
            if (!(p instanceof DependencyParameter)) continue;
            DependencyParameter dp = (DependencyParameter)p;
            switch (taskDescription.getType()) {
                case METHOD: {
                    this.transferJobData(dp, listener);
                    continue block4;
                }
                case SERVICE: {
                    if (dp.getDirection() == Direction.INOUT) continue block4;
                    this.transferJobData(dp, listener);
                }
            }
        }
    }

    private final void transferJobData(DependencyParameter param, JobTransfersListener listener) {
        Worker<? extends WorkerResourceDescription> w = this.getAssignedResource().getResource();
        DataAccessId access = param.getDataAccessId();
        if (access instanceof DataAccessId.WAccessId) {
            String tgtName = ((DataAccessId.WAccessId)access).getWrittenDataInstance().getRenaming();
            if (DEBUG) {
                JOB_LOGGER.debug("Setting data target job transfer: " + w.getCompleteRemotePath(param.getType(), tgtName));
            }
            param.setDataTarget(w.getCompleteRemotePath(param.getType(), tgtName).getPath());
            return;
        }
        listener.addOperation();
        if (access instanceof DataAccessId.RAccessId) {
            String srcName = ((DataAccessId.RAccessId)access).getReadDataInstance().getRenaming();
            w.getData(srcName, srcName, (Transferable)param, (EventListener)listener);
        } else {
            String srcName = ((DataAccessId.RWAccessId)access).getReadDataInstance().getRenaming();
            String tgtName = ((DataAccessId.RWAccessId)access).getWrittenDataInstance().getRenaming();
            w.getData(srcName, tgtName, (LogicalData)null, (Transferable)param, (EventListener)listener);
        }
    }

    public final void failedTransfers(int failedtransfers) {
        JOB_LOGGER.debug("Received a notification for the transfers for task " + this.task.getId() + " with state FAILED");
        ++this.transferErrors;
        if (this.transferErrors < 2) {
            JOB_LOGGER.debug("Resubmitting input files for task " + this.task.getId() + " to host " + this.getAssignedResource().getName() + " since " + failedtransfers + " transfers failed.");
            this.doInputTransfers();
        } else {
            ErrorManager.warn("Transfers for running task " + this.task.getId() + " on worker " + this.getAssignedResource().getName() + " have failed.");
            this.notifyError();
        }
    }

    public final void doSubmit(int transferGroupId) {
        JOB_LOGGER.debug("Received a notification for the transfers of task " + this.task.getId() + " with state DONE");
        JobStatusListener listener = new JobStatusListener(this);
        Job<?> job = this.submitJob(transferGroupId, listener);
        this.jobs.add(job.getJobId());
        JOB_LOGGER.info((this.getExecutingResources().size() > 1 ? "Rescheduled" : "New") + " Job " + job.getJobId() + " (Task: " + this.task.getId() + ")");
        JOB_LOGGER.info("  * Method name: " + this.task.getTaskDescription().getName());
        JOB_LOGGER.info("  * Target host: " + this.getAssignedResource().getName());
        this.profile.start();
        JobDispatcher.dispatch(job);
    }

    protected Job<?> submitJob(int transferGroupId, JobStatusListener listener) {
        if (DEBUG) {
            LOGGER.debug(this.toString() + " starts job creation");
        }
        Worker<? extends WorkerResourceDescription> w = this.getAssignedResource().getResource();
        ArrayList<String> slaveNames = new ArrayList<String>();
        Job<?> job = w.newJob(this.task.getId(), this.task.getTaskDescription(), this.getAssignedImplementation(), slaveNames, listener);
        job.setTransferGroupId(transferGroupId);
        job.setHistory(Job.JobHistory.NEW);
        return job;
    }

    public final void failedJob(Job<?> job, JobListener.JobEndStatus endStatus) {
        this.profile.end();
        int jobId = job.getJobId();
        JOB_LOGGER.error("Received a notification for job " + jobId + " with state FAILED");
        ++this.executionErrors;
        if (this.transferErrors + this.executionErrors < 2) {
            JOB_LOGGER.error("Job " + job.getJobId() + " for running task " + this.task.getId() + " on worker " + this.getAssignedResource().getName() + " has failed; resubmitting task to the same worker.");
            ErrorManager.warn("Job " + job.getJobId() + " for running task " + this.task.getId() + " on worker " + this.getAssignedResource().getName() + " has failed; resubmitting task to the same worker.");
            job.setHistory(Job.JobHistory.RESUBMITTED);
            this.profile.start();
            JobDispatcher.dispatch(job);
        } else {
            this.notifyError();
        }
    }

    public final void completedJob(Job<?> job) {
        this.profile.end();
        int jobId = job.getJobId();
        JOB_LOGGER.info("Received a notification for job " + jobId + " with state OK (avg. duration: " + this.profile.getAverageExecutionTime() + ")");
        this.doOutputTransfers(job);
        this.notifyCompleted();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void doOutputTransfers(Job<?> job) {
        Worker<? extends WorkerResourceDescription> w = this.getAssignedResource().getResource();
        Parameter[] parameterArray = job.getTaskParams().getParameters();
        int n = parameterArray.length;
        int n2 = 0;
        while (true) {
            block18: {
                if (n2 >= n) {
                    return;
                }
                Parameter p = parameterArray[n2];
                if (!(p instanceof DependencyParameter)) break block18;
                DataInstanceId dId = null;
                DependencyParameter dp = (DependencyParameter)p;
                switch (p.getDirection()) {
                    case IN: {
                        break block18;
                    }
                    case OUT: {
                        dId = ((DataAccessId.WAccessId)dp.getDataAccessId()).getWrittenDataInstance();
                        break;
                    }
                    case INOUT: {
                        dId = ((DataAccessId.RWAccessId)dp.getDataAccessId()).getWrittenDataInstance();
                        if (job.getType() == Implementation.TaskType.SERVICE) break block18;
                    }
                }
                String name = dId.getRenaming();
                if (job.getType() == Implementation.TaskType.METHOD) {
                    String targetProtocol = null;
                    switch (dp.getType()) {
                        case FILE_T: {
                            targetProtocol = DataLocation.Protocol.FILE_URI.getSchema();
                            break;
                        }
                        case OBJECT_T: {
                            targetProtocol = DataLocation.Protocol.OBJECT_URI.getSchema();
                            break;
                        }
                        case PSCO_T: {
                            targetProtocol = DataLocation.Protocol.PERSISTENT_URI.getSchema();
                            break;
                        }
                        case EXTERNAL_PSCO_T: {
                            targetProtocol = DataLocation.Protocol.PERSISTENT_URI.getSchema();
                            break;
                        }
                        case BINDING_OBJECT_T: {
                            targetProtocol = DataLocation.Protocol.BINDING_URI.getSchema();
                            break;
                        }
                        default: {
                            targetProtocol = DataLocation.Protocol.ANY_URI.getSchema();
                        }
                    }
                    DataLocation outLoc = null;
                    try {
                        SimpleURI targetURI = new SimpleURI(targetProtocol + dp.getDataTarget());
                        outLoc = DataLocation.createLocation(w, targetURI);
                    }
                    catch (Exception e) {
                        ErrorManager.error("ERROR: Invalid location URI " + dp.getDataTarget(), e);
                    }
                    Comm.registerLocation(name, outLoc);
                } else {
                    Object value = job.getReturnValue();
                    Comm.registerValue(name, value);
                }
            }
            ++n2;
        }
    }

    @Override
    protected void doCompleted() {
        this.getAssignedResource().profiledExecution(this.getAssignedImplementation(), this.profile);
        this.task.decreaseExecutionCount();
        this.task.setStatus(Task.TaskState.FINISHED);
        this.producer.notifyTaskEnd(this.task);
    }

    @Override
    protected void doError() throws FailedActionException {
        if (this.getExecutingResources().size() >= 2) {
            LOGGER.warn("Task " + this.task.getId() + " has already been rescheduled; notifying task failure.");
            ErrorManager.warn("Task " + this.task.getId() + " has already been rescheduled; notifying task failure.");
            throw new FailedActionException();
        }
        ErrorManager.warn("Task " + this.task.getId() + " execution on worker " + this.getAssignedResource().getName() + " has failed; rescheduling task execution. (changing worker)");
        LOGGER.warn("Task " + this.task.getId() + " execution on worker " + this.getAssignedResource().getName() + " has failed; rescheduling task execution. (changing worker)");
    }

    @Override
    protected void doFailed() {
        String taskName = this.task.getTaskDescription().getName();
        StringBuilder sb = new StringBuilder();
        sb.append("Task '").append(taskName).append("' TOTALLY FAILED.\n");
        sb.append("Possible causes:\n");
        sb.append("     -Exception thrown by task '").append(taskName).append("'.\n");
        sb.append("     -Expected output files not generated by task '").append(taskName).append("'.\n");
        sb.append("     -Could not provide nor retrieve needed data between master and worker.\n");
        sb.append("\n");
        sb.append("Check files '").append(Comm.getAppHost().getJobsDirPath()).append("job[");
        Iterator j = this.jobs.iterator();
        while (j.hasNext()) {
            sb.append(j.next());
            if (!j.hasNext()) break;
            sb.append("|");
        }
        sb.append("'] to find out the error.\n");
        sb.append(" \n");
        ErrorManager.warn(sb.toString());
        this.task.decreaseExecutionCount();
        this.task.setStatus(Task.TaskState.FAILED);
        this.producer.notifyTaskEnd(this.task);
    }

    @Override
    public final List<ResourceScheduler<? extends WorkerResourceDescription>> getCompatibleWorkers() {
        return this.getCoreElementExecutors(this.task.getTaskDescription().getId());
    }

    @Override
    public final Implementation[] getImplementations() {
        List<Implementation> coreImpls = CoreManager.getCoreImplementations(this.task.getTaskDescription().getId());
        int coreImplsSize = coreImpls.size();
        Implementation[] impls = new Implementation[coreImplsSize];
        for (int i = 0; i < coreImplsSize; ++i) {
            impls[i] = coreImpls.get(i);
        }
        return impls;
    }

    @Override
    public <W extends WorkerResourceDescription> boolean isCompatible(Worker<W> r) {
        return r.canRun(this.task.getTaskDescription().getId());
    }

    @Override
    public final <T extends WorkerResourceDescription> List<Implementation> getCompatibleImplementations(ResourceScheduler<T> r) {
        return r.getExecutableImpls(this.task.getTaskDescription().getId());
    }

    @Override
    public final Integer getCoreId() {
        return this.task.getTaskDescription().getId();
    }

    @Override
    public final int getPriority() {
        return this.task.getTaskDescription().hasPriority() ? 1 : 0;
    }

    @Override
    public final <T extends WorkerResourceDescription> Score schedulingScore(ResourceScheduler<T> targetWorker, Score actionScore) {
        Score computedScore = targetWorker.generateResourceScore(this, this.task.getTaskDescription(), actionScore);
        return computedScore;
    }

    @Override
    public final void schedule(Score actionScore) throws BlockedActionException, UnassignedActionException {
        LinkedList<ResourceScheduler<? extends WorkerResourceDescription>> candidates = new LinkedList<ResourceScheduler<? extends WorkerResourceDescription>>();
        if (this.isTargetResourceEnforced()) {
            candidates.add(this.getEnforcedTargetResource());
        } else if (this.isSchedulingConstrained()) {
            for (AllocatableAction a : this.getConstrainingPredecessors()) {
                candidates.add(a.getAssignedResource());
            }
        } else {
            candidates = this.getCompatibleWorkers();
        }
        this.schedule(actionScore, candidates);
    }

    @Override
    public final void tryToSchedule(Score actionScore) throws BlockedActionException, UnassignedActionException {
        LinkedList<ResourceScheduler<? extends WorkerResourceDescription>> candidates = new LinkedList<ResourceScheduler<? extends WorkerResourceDescription>>();
        if (this.isTargetResourceEnforced()) {
            candidates.add(this.getEnforcedTargetResource());
        } else if (this.isSchedulingConstrained()) {
            for (AllocatableAction a : this.getConstrainingPredecessors()) {
                candidates.add(a.getAssignedResource());
            }
        } else {
            List<ResourceScheduler<? extends WorkerResourceDescription>> compatibleCandidates = this.getCompatibleWorkers();
            if (compatibleCandidates.size() == 0) {
                throw new BlockedActionException();
            }
            for (ResourceScheduler<? extends WorkerResourceDescription> currentWorker : compatibleCandidates) {
                if (!currentWorker.getResource().hasAvailableSlots()) continue;
                candidates.add(currentWorker);
            }
            if (candidates.size() == 0) {
                throw new UnassignedActionException();
            }
        }
        this.schedule(actionScore, candidates);
    }

    private final <T extends WorkerResourceDescription> void schedule(Score actionScore, List<ResourceScheduler<? extends WorkerResourceDescription>> candidates) throws BlockedActionException, UnassignedActionException {
        StringBuilder debugString = new StringBuilder("Scheduling " + this + " execution:\n");
        ResourceScheduler<? extends WorkerResourceDescription> bestWorker = null;
        Implementation bestImpl = null;
        Score bestScore = null;
        int usefulResources = 0;
        for (ResourceScheduler<? extends WorkerResourceDescription> worker : candidates) {
            if (this.getExecutingResources().contains(worker)) {
                if (!DEBUG) continue;
                LOGGER.debug("Task already ran on worker " + worker.getName());
                continue;
            }
            Score resourceScore = worker.generateResourceScore(this, this.task.getTaskDescription(), actionScore);
            ++usefulResources;
            for (Implementation impl : this.getCompatibleImplementations(worker)) {
                Score implScore = worker.generateImplementationScore(this, this.task.getTaskDescription(), impl, resourceScore);
                if (DEBUG) {
                    debugString.append(" Resource ").append(worker.getName()).append(" ").append(" Implementation ").append(impl.getImplementationId()).append(" ").append(" Score ").append(implScore).append("\n");
                }
                if (!Score.isBetter(implScore, bestScore)) continue;
                bestWorker = worker;
                bestImpl = impl;
                bestScore = implScore;
            }
        }
        if (DEBUG) {
            LOGGER.debug(debugString.toString());
        }
        if (bestWorker == null && usefulResources == 0) {
            LOGGER.warn("No worker can run " + this);
            throw new BlockedActionException();
        }
        this.schedule(bestWorker, bestImpl);
    }

    @Override
    public final <T extends WorkerResourceDescription> void schedule(ResourceScheduler<T> targetWorker, Score actionScore) throws BlockedActionException, UnassignedActionException {
        if (targetWorker == null || !targetWorker.getResource().canRun(this.task.getTaskDescription().getId()) || this.getExecutingResources().contains(targetWorker)) {
            String message = "Worker " + (targetWorker == null ? "null" : targetWorker.getName()) + " has not available resources to run " + this;
            LOGGER.warn(message);
            throw new UnassignedActionException();
        }
        Implementation bestImpl = null;
        Score bestScore = null;
        Score resourceScore = targetWorker.generateResourceScore(this, this.task.getTaskDescription(), actionScore);
        for (Implementation impl : this.getCompatibleImplementations(targetWorker)) {
            Score implScore = targetWorker.generateImplementationScore(this, this.task.getTaskDescription(), impl, resourceScore);
            if (!Score.isBetter(implScore, bestScore)) continue;
            bestImpl = impl;
            bestScore = implScore;
        }
        this.schedule(targetWorker, bestImpl);
    }

    @Override
    public final <T extends WorkerResourceDescription> void schedule(ResourceScheduler<T> targetWorker, Implementation impl) throws BlockedActionException, UnassignedActionException {
        if (targetWorker == null || impl == null) {
            throw new UnassignedActionException();
        }
        if (DEBUG) {
            LOGGER.debug("Scheduling " + this + " on worker " + (targetWorker == null ? "null" : targetWorker.getName()) + " with implementation " + (impl == null ? "null" : impl.getImplementationId()));
        }
        if (!targetWorker.getResource().canRun(impl) || this.getExecutingResources().contains(targetWorker)) {
            LOGGER.debug("Worker " + targetWorker.getName() + " has not available resources to run " + this);
            throw new UnassignedActionException();
        }
        LOGGER.info("Assigning action " + this + " to worker " + targetWorker.getName() + " with implementation " + impl.getImplementationId());
        this.assignImplementation(impl);
        this.assignResource(targetWorker);
        targetWorker.scheduleAction(this);
    }

    @Override
    public String toString() {
        return "ExecutionAction ( Task " + this.task.getId() + ", CE name " + this.task.getTaskDescription().getName() + ")";
    }
}

