/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.concurrent;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import net.schmizz.concurrent.ExceptionChainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Promise<V, T extends Throwable> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final String name;
    private final ExceptionChainer<T> chainer;
    private final ReentrantLock lock;
    private final Condition cond;
    private V val;
    private T pendingEx;

    public Promise(String name, ExceptionChainer<T> chainer) {
        this(name, chainer, null);
    }

    public Promise(String name, ExceptionChainer<T> chainer, ReentrantLock lock) {
        this.name = name;
        this.chainer = chainer;
        this.lock = lock == null ? new ReentrantLock() : lock;
        this.cond = this.lock.newCondition();
    }

    public void deliver(V val) {
        this.lock.lock();
        try {
            this.log.debug("Setting <<{}>> to `{}`", (Object)this.name, (Object)val);
            this.val = val;
            this.cond.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void deliverError(Throwable e) {
        this.lock.lock();
        try {
            this.pendingEx = this.chainer.chain(e);
            this.cond.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void clear() {
        this.lock.lock();
        try {
            this.pendingEx = null;
            this.deliver(null);
        }
        finally {
            this.lock.unlock();
        }
    }

    public V retrieve() throws T {
        return this.tryRetrieve(0L, TimeUnit.SECONDS);
    }

    public V retrieve(long timeout, TimeUnit unit) throws T {
        V value = this.tryRetrieve(timeout, unit);
        if (value == null) {
            throw this.chainer.chain(new TimeoutException("Timeout expired"));
        }
        return value;
    }

    public V tryRetrieve(long timeout, TimeUnit unit) throws T {
        this.lock.lock();
        try {
            if (this.pendingEx != null) {
                throw this.pendingEx;
            }
            if (this.val != null) {
                V v = this.val;
                return v;
            }
            this.log.debug("Awaiting <<{}>>", (Object)this.name);
            if (timeout == 0L) {
                while (this.val == null && this.pendingEx == null) {
                    this.cond.await();
                }
            } else if (!this.cond.await(timeout, unit)) {
                V v = null;
                return v;
            }
            if (this.pendingEx != null) {
                this.log.error("<<{}>> woke to: {}", (Object)this.name, (Object)((Throwable)this.pendingEx).toString());
                throw this.pendingEx;
            }
            V v = this.val;
            return v;
        }
        catch (InterruptedException ie) {
            throw this.chainer.chain(ie);
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isDelivered() {
        this.lock.lock();
        try {
            boolean bl = this.pendingEx == null && this.val != null;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean inError() {
        this.lock.lock();
        try {
            boolean bl = this.pendingEx != null;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean hasWaiters() {
        this.lock.lock();
        try {
            boolean bl = this.lock.hasWaiters(this.cond);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void lock() {
        this.lock.lock();
    }

    public void unlock() {
        this.lock.unlock();
    }

    public String toString() {
        return this.name;
    }
}

