/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cim;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import org.jclouds.cim.ResourceAllocationSettingData;

public class CIMPredicates {
    public static Predicate<ResourceAllocationSettingData> resourceTypeIn(ResourceAllocationSettingData.ResourceType ... types) {
        Preconditions.checkNotNull(types, "resourceTypes");
        final ImmutableSet<ResourceAllocationSettingData.ResourceType> resourceTypes = ImmutableSet.copyOf(types);
        return new Predicate<ResourceAllocationSettingData>(){

            @Override
            public boolean apply(ResourceAllocationSettingData in) {
                return resourceTypes.contains((Object)in.getResourceType());
            }

            public String toString() {
                return "resourceTypeIn(" + resourceTypes + ")";
            }
        };
    }
}

