/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.compute.strategy;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.ExecutionException;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.aws.util.AWSUtils;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.strategy.DestroyNodeStrategy;
import org.jclouds.compute.strategy.GetNodeMetadataStrategy;
import org.jclouds.ec2.EC2Api;
import org.jclouds.ec2.compute.domain.RegionAndName;
import org.jclouds.logging.Logger;

@Singleton
public class EC2DestroyNodeStrategy
implements DestroyNodeStrategy {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    protected final EC2Api client;
    protected final GetNodeMetadataStrategy getNode;
    protected final LoadingCache<RegionAndName, String> elasticIpCache;
    @Inject
    @Named(value="jclouds.ec2.auto-allocate-elastic-ips")
    @VisibleForTesting
    boolean autoAllocateElasticIps = false;

    @Inject
    protected EC2DestroyNodeStrategy(EC2Api client, GetNodeMetadataStrategy getNode, @Named(value="ELASTICIP") LoadingCache<RegionAndName, String> elasticIpCache) {
        this.client = Preconditions.checkNotNull(client, "client");
        this.getNode = Preconditions.checkNotNull(getNode, "getNode");
        this.elasticIpCache = Preconditions.checkNotNull(elasticIpCache, "elasticIpCache");
    }

    @Override
    public NodeMetadata destroyNode(String id) {
        String[] parts = AWSUtils.parseHandle(id);
        String region = parts[0];
        String instanceId = parts[1];
        this.releaseAnyPublicIpForInstanceInRegion(instanceId, region);
        this.destroyInstanceInRegion(instanceId, region);
        return this.getNode.getNode(id);
    }

    protected void releaseAnyPublicIpForInstanceInRegion(String instanceId, String region) {
        if (!this.autoAllocateElasticIps) {
            return;
        }
        try {
            String ip = this.elasticIpCache.get(new RegionAndName(region, instanceId));
            this.logger.debug(">> disassociating elastic IP %s", ip);
            this.client.getElasticIPAddressApi().get().disassociateAddressInRegion(region, ip);
            this.logger.trace("<< disassociated elastic IP %s", ip);
            this.elasticIpCache.invalidate(new RegionAndName(region, instanceId));
            this.logger.debug(">> releasing elastic IP %s", ip);
            this.client.getElasticIPAddressApi().get().releaseAddressInRegion(region, ip);
            this.logger.trace("<< released elastic IP %s", ip);
        }
        catch (CacheLoader.InvalidCacheLoadException e) {
            return;
        }
        catch (ExecutionException e) {
            this.logger.warn(e, "error cleaning up elastic ip for instance %s/%s", region, instanceId);
        }
    }

    protected void destroyInstanceInRegion(String instanceId, String region) {
        this.client.getInstanceApi().get().terminateInstancesInRegion(region, instanceId);
    }
}

