/*
 * Decompiled with CFR 0.152.
 */
package org.gridlab.gat.resources;

import ibis.util.IPUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.gridlab.gat.GAT;
import org.gridlab.gat.GATContext;
import org.gridlab.gat.GATObjectCreationException;
import org.gridlab.gat.Preferences;
import org.gridlab.gat.URI;
import org.gridlab.gat.resources.JobDescription;
import org.gridlab.gat.resources.Resource;
import org.gridlab.gat.resources.ResourceDescription;
import org.gridlab.gat.resources.SoftwareDescription;
import org.gridlab.gat.resources.WrapperSoftwareDescription;

public class WrapperJobDescription
extends JobDescription {
    public static final String WRAPPER_COMMON_SRC = "wrapper.common.src";
    public static final String WRAPPER_COMMON_DEST = "wrapper.common.dest";
    public static final String WRAPPER_COMMON_TRIGGER = "wrapper.common.trigger";
    private static final long serialVersionUID = -3241293801064308501L;
    private static int wrapperJobCount = 0;
    private static URI triggerDirectory;
    private List<WrappedJobInfo> jobInfos = new ArrayList<WrappedJobInfo>();
    private ScheduledType scheduledType;
    private int level;
    private int wrapperJobIndex;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WrapperJobDescription(WrapperSoftwareDescription softwareDescription) {
        super(softwareDescription);
        Class<WrapperJobDescription> clazz = WrapperJobDescription.class;
        synchronized (WrapperJobDescription.class) {
            this.wrapperJobIndex = wrapperJobCount++;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public int getWrapperJobIndex() {
        return this.wrapperJobIndex;
    }

    public WrapperJobDescription(WrapperSoftwareDescription softwareDescription, ResourceDescription resourceDescription) {
        super((SoftwareDescription)softwareDescription, resourceDescription);
    }

    public WrapperJobDescription(WrapperSoftwareDescription softwareDescription, Resource resource) {
        super((SoftwareDescription)softwareDescription, resource);
    }

    public void setScheduledType(ScheduledType scheduledType) {
        this.scheduledType = scheduledType;
    }

    public void setLoggingLevel(int level) {
        this.level = level;
    }

    public void add(JobDescription jobDescription, URI brokerURI, Preferences preferences) {
        this.jobInfos.add(new WrappedJobInfo(jobDescription, brokerURI, preferences, this.jobInfos.size(), this.wrapperJobIndex));
    }

    public void add(JobDescription[] jobDescriptions, URI brokerURI, Preferences preferences) {
        for (JobDescription jobDescription : jobDescriptions) {
            this.add(jobDescription, brokerURI, preferences);
        }
    }

    public List<WrappedJobInfo> getJobInfos() {
        return this.jobInfos;
    }

    public ScheduledType getScheduledType() {
        return this.scheduledType;
    }

    public int getLevel() {
        return this.level;
    }

    public org.gridlab.gat.io.File getInfoFile(GATContext context) throws GATObjectCreationException {
        File f = null;
        try {
            f = org.gridlab.gat.io.File.createTempFile("GAT", "jobDescription");
            f.deleteOnExit();
            FileOutputStream tmp = new FileOutputStream(f);
            ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(tmp));
            URI originator = new URI("any://" + IPUtils.getLocalHostAddress().getCanonicalHostName() + "/" + System.getProperty("user.dir"));
            out.writeObject(originator);
            out.writeInt(this.level);
            out.writeInt(this.wrapperJobIndex);
            String wrapperCommonSrc = (String)this.softwareDescription.getAttributes().get(WRAPPER_COMMON_SRC);
            out.writeObject(wrapperCommonSrc);
            String wrapperCommonDest = (String)this.softwareDescription.getAttributes().get(WRAPPER_COMMON_DEST);
            out.writeObject(wrapperCommonDest);
            String sandboxTrigger = (String)this.softwareDescription.getAttributes().get(WRAPPER_COMMON_TRIGGER);
            out.writeObject(sandboxTrigger);
            if (triggerDirectory == null) {
                triggerDirectory = originator;
            }
            out.writeObject(triggerDirectory);
            out.writeObject((Object)this.scheduledType);
            for (WrappedJobInfo jobInfo : this.jobInfos) {
                jobInfo.generateJobStateFileName();
            }
            out.writeObject(this.jobInfos);
            out.close();
        }
        catch (Exception e) {
            throw new GATObjectCreationException("Failed to create wrapper info file", e);
        }
        return GAT.createFile(context, f.getPath());
    }

    public URI getJobStateFileName(JobDescription description) {
        for (WrappedJobInfo info : this.jobInfos) {
            if (info.getJobDescription() != description) continue;
            return info.jobStateFileName;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setTriggerDirectory(URI location) throws Exception {
        Class<WrapperJobDescription> clazz = WrapperJobDescription.class;
        synchronized (WrapperJobDescription.class) {
            if (triggerDirectory != null) {
                throw new Exception("triggerdirectory already set!");
            }
            triggerDirectory = location;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public class WrappedJobInfo
    implements Serializable {
        private static final long serialVersionUID = 4870069252793683143L;
        private JobDescription jobDescription;
        private URI brokerURI;
        private Preferences preferences;
        private URI jobStateFileName;
        private int wrappedJobIndex;
        private int wrapperJobIndex;

        public WrappedJobInfo(JobDescription jobDescription, URI brokerURI, Preferences preferences, int wrappedJobIndex, int wrapperJobIndex) {
            this.jobDescription = jobDescription;
            this.brokerURI = brokerURI;
            this.preferences = preferences;
            this.wrappedJobIndex = wrappedJobIndex;
            this.wrapperJobIndex = wrapperJobIndex;
        }

        public JobDescription getJobDescription() {
            return this.jobDescription;
        }

        public URI getBrokerURI() {
            return this.brokerURI;
        }

        public Preferences getPreferences() {
            return this.preferences;
        }

        public URI getJobStateFileName() {
            return this.jobStateFileName;
        }

        public int getWrappedJobIndex() {
            return this.wrappedJobIndex;
        }

        public int getWrapperJobIndex() {
            return this.wrapperJobIndex;
        }

        void generateJobStateFileName() {
            String path = triggerDirectory.getPath();
            path = path + "/jobstate_" + this.wrapperJobIndex + "_" + this.wrappedJobIndex;
            try {
                this.jobStateFileName = triggerDirectory.setPath(path);
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
    }

    public static enum ScheduledType {
        COORDINATED,
        PARALLEL;

    }
}

