/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.gat.master;

import es.bsc.compss.comm.CommAdaptor;
import es.bsc.compss.comm.Dispatcher;
import es.bsc.compss.exceptions.ConstructConfigurationException;
import es.bsc.compss.gat.master.GATJob;
import es.bsc.compss.gat.master.GATWorkerNode;
import es.bsc.compss.gat.master.configuration.GATConfiguration;
import es.bsc.compss.types.data.operation.DataOperation;
import es.bsc.compss.types.data.operation.copy.Copy;
import es.bsc.compss.types.resources.configuration.Configuration;
import es.bsc.compss.types.uri.MultiURI;
import es.bsc.compss.util.ErrorManager;
import es.bsc.compss.util.RequestQueue;
import es.bsc.compss.util.ThreadPool;
import java.io.File;
import java.net.URISyntaxException;
import java.util.LinkedList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.gridlab.gat.GAT;
import org.gridlab.gat.GATContext;
import org.gridlab.gat.URI;

public class GATAdaptor
implements CommAdaptor {
    public static final String ID = GATAdaptor.class.getCanonicalName();
    protected static final String POOL_NAME = "FTM";
    private static final int GAT_POOL_SIZE = 5;
    protected static final String SAFE_POOL_NAME = "SAFE_FTM";
    protected static final int SAFE_POOL_SIZE = 1;
    protected static final String THREAD_POOL_ERR = "Error starting pool of threads";
    protected static final String POOL_ERR = "Error deleting pool of threads";
    private static RequestQueue<DataOperation> copyQueue;
    private static RequestQueue<DataOperation> safeQueue;
    protected static ThreadPool pool;
    protected static ThreadPool safePool;
    private static String masterUser;
    private static GATContext transferContext;
    private static final Logger logger;
    private static final boolean debug;

    @Override
    public void init() {
        copyQueue = new RequestQueue();
        safeQueue = new RequestQueue();
        String adaptor = System.getProperty("gat.file.adaptor");
        if (debug) {
            logger.debug("Initializing GAT");
        }
        pool = new ThreadPool(5, POOL_NAME, new Dispatcher(copyQueue));
        try {
            pool.startThreads();
        }
        catch (Exception e) {
            ErrorManager.error(THREAD_POOL_ERR, e);
        }
        safePool = new ThreadPool(1, SAFE_POOL_NAME, new Dispatcher(safeQueue));
        try {
            safePool.startThreads();
        }
        catch (Exception e) {
            ErrorManager.error(THREAD_POOL_ERR, e);
        }
        if (debug) {
            logger.debug("Initializing GAT Tranfer Context");
        }
        transferContext = new GATContext();
        transferContext.addPreference("File.adaptor.name", adaptor + ", srcToLocalToDestCopy, local");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Configuration constructConfiguration(Object project_properties, Object resources_properties) throws ConstructConfigurationException {
        String brokerAdaptorName = System.getProperty("gat.broker.adaptor");
        String project_brokerAdaptor = (String)project_properties;
        String resources_brokerAdaptor = (String)resources_properties;
        if (project_brokerAdaptor != null) {
            if (resources_brokerAdaptor != null) {
                if (!project_brokerAdaptor.equals(resources_brokerAdaptor)) throw new ConstructConfigurationException("GATAdaptor: BrokerAdaptor defined in resources.xml and project.xml donesn't match");
                brokerAdaptorName = project_brokerAdaptor;
                return new GATConfiguration(this.getClass().getName(), brokerAdaptorName);
            } else {
                brokerAdaptorName = project_brokerAdaptor;
            }
            return new GATConfiguration(this.getClass().getName(), brokerAdaptorName);
        } else if (resources_brokerAdaptor != null) {
            brokerAdaptorName = resources_brokerAdaptor;
            return new GATConfiguration(this.getClass().getName(), brokerAdaptorName);
        } else {
            logger.debug("GAT Broker Adaptor not specified. Setting default value " + brokerAdaptorName);
        }
        return new GATConfiguration(this.getClass().getName(), brokerAdaptorName);
    }

    @Override
    public GATWorkerNode initWorker(String name, Configuration config) {
        GATWorkerNode node = new GATWorkerNode(name, (GATConfiguration)config);
        return node;
    }

    public static void addTransferContextPreferences(String name, String value) {
        transferContext.addPreference(name, value);
    }

    public LinkedList<DataOperation> getPending() {
        LinkedList<DataOperation> l = new LinkedList<DataOperation>();
        for (DataOperation c : copyQueue.getQueue()) {
            l.add(c);
        }
        for (DataOperation c : safeQueue.getQueue()) {
            l.add(c);
        }
        return l;
    }

    @Override
    public void stop() {
        try {
            pool.stopThreads();
            safePool.stopThreads();
        }
        catch (Exception e) {
            logger.error(POOL_ERR, (Throwable)e);
        }
        GAT.end();
    }

    @Override
    public void stopSubmittedJobs() {
        GATJob.stopAll();
    }

    @Override
    public void completeMasterURI(MultiURI uri) {
        String scheme = uri.getScheme();
        String user = masterUser + "@";
        String host = uri.getHost().getName();
        String path = uri.getPath();
        if (!path.contains(File.separator)) {
            return;
        }
        String s = scheme + user + host + File.separator + path;
        try {
            uri.setInternalURI(ID, new URI(s));
        }
        catch (URISyntaxException e) {
            logger.error("Exception", (Throwable)e);
        }
    }

    public static void enqueueCopy(Copy c) {
        copyQueue.enqueue(c);
    }

    public static GATContext getTransferContext() {
        return transferContext;
    }

    static {
        masterUser = System.getProperty("user.name");
        logger = LogManager.getLogger("es.bsc.compss.Communication");
        debug = logger.isDebugEnabled();
    }
}

