/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.gat.master.configuration;

import es.bsc.compss.gat.master.GATAdaptor;
import es.bsc.compss.types.resources.configuration.MethodConfiguration;
import java.util.Map;
import org.gridlab.gat.GATContext;

public class GATConfiguration
extends MethodConfiguration {
    private GATContext context;
    private boolean usingGlobus = false;
    private boolean userNeeded = false;
    private String queue = "";

    public GATConfiguration(String adaptorName, String brokerAdaptorName) {
        super(adaptorName);
        this.initContext(brokerAdaptorName, System.getProperty("gat.file.adaptor"));
        for (Map.Entry<String, String> entry : super.getAdditionalProperties().entrySet()) {
            String propName = entry.getKey();
            String propValue = entry.getValue();
            if (propName.startsWith("[context=job]")) {
                propName = propName.substring(13);
                this.addContextPreference(propName, propValue);
                continue;
            }
            if (!propName.startsWith("[context=file]")) continue;
            propName = propName.substring(14);
            this.addContextPreference(propName, propValue);
            GATAdaptor.addTransferContextPreferences(propName.substring(14), propValue);
        }
    }

    public GATConfiguration(GATConfiguration clone) {
        super(clone);
        this.context = clone.context;
        this.usingGlobus = clone.usingGlobus;
        this.userNeeded = clone.userNeeded;
        this.queue = clone.queue;
    }

    @Override
    public MethodConfiguration copy() {
        return new GATConfiguration(this);
    }

    private void initContext(String brokerAdaptor, String fileAdaptor) {
        this.context = new GATContext();
        this.context.addPreference("ResourceBroker.adaptor.name", brokerAdaptor);
        this.context.addPreference("File.adaptor.name", fileAdaptor + ", srcToLocalToDestCopy, local");
        this.usingGlobus = brokerAdaptor.equalsIgnoreCase("globus");
        this.userNeeded = brokerAdaptor.regionMatches(true, 0, "ssh", 0, 3);
    }

    public GATContext getContext() {
        return this.context;
    }

    public void setContext(GATContext context) {
        this.context = context;
    }

    public void addContextPreference(String key, String value) {
        this.context.addPreference(key, value);
    }

    public boolean isUsingGlobus() {
        return this.usingGlobus;
    }

    public void setUsingGlobus(boolean usingGlobus) {
        this.usingGlobus = usingGlobus;
    }

    public boolean isUserNeeded() {
        return this.userNeeded;
    }

    public void setUserNeeded(boolean userNeeded) {
        this.userNeeded = userNeeded;
    }

    public String getQueue() {
        return this.queue;
    }

    public void setQueue(String queue) {
        this.queue = queue;
    }
}

